/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server.handler;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.request.Method;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.Link;
import org.readium.r2.streamer.fetcher.Fetcher;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J5\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/readium/r2/streamer/server/handler/ResourceHandler;", "Lorg/nanohttpd/router/RouterNanoHTTPD$DefaultHandler;", "()V", "TAG", "", "kotlin.jvm.PlatformType", "createResponse", "Lorg/nanohttpd/protocols/http/response/Response;", "status", "Lorg/nanohttpd/protocols/http/response/Status;", "mimeType", "message", "Ljava/io/InputStream;", "get", "uriResource", "Lorg/nanohttpd/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "session", "Lorg/nanohttpd/protocols/http/IHTTPSession;", "getMimeType", "getResponse", "getStatus", "Lorg/nanohttpd/protocols/http/response/IStatus;", "getText", "serveResponse", "inputStream", "r2-streamer_intTestappDebug"})
public final class ResourceHandler
extends RouterNanoHTTPD.DefaultHandler {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();

    @Nullable
    public String getMimeType() {
        return null;
    }

    @NotNull
    public String getText() {
        return "{\"success\":false}";
    }

    @NotNull
    public IStatus getStatus() {
        return (IStatus)Status.OK;
    }

    @Nullable
    public Response get(@Nullable RouterNanoHTTPD.UriResource uriResource, @Nullable Map<String, String> urlParams, @Nullable IHTTPSession session) {
        String encodedUri;
        URI uri;
        IHTTPSession iHTTPSession = session;
        if (iHTTPSession == null) {
            Intrinsics.throwNpe();
        }
        Method method = iHTTPSession.getMethod();
        try {
            uri = new URI(null, null, session.getUri(), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        String string = encodedUri = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"encodedUri");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"//", (boolean)false, (int)2, null)) {
            String string2 = session.getUri();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"session.uri");
            encodedUri = StringsKt.replace$default((String)string2, (String)"//", (String)"/", (boolean)false, (int)4, null);
        }
        String string3 = this.TAG + " Method: " + method + ", Url: " + encodedUri;
        System.out.println((Object)string3);
        try {
            String mimeType;
            RouterNanoHTTPD.UriResource uriResource2 = uriResource;
            if (uriResource2 == null) {
                Intrinsics.throwNpe();
            }
            Fetcher fetcher = (Fetcher)uriResource2.initParameter(Fetcher.class);
            String string4 = encodedUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"encodedUri");
            int offset = StringsKt.indexOf$default((CharSequence)string4, (String)"/", (int)0, (boolean)false, (int)4, null);
            int startIndex = StringsKt.indexOf$default((CharSequence)encodedUri, (String)"/", (int)(offset + 1), (boolean)false, (int)4, null);
            String string5 = encodedUri;
            int n = startIndex + 1;
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String filePath = string6;
            Link link = fetcher.getPublication().linkWithHref('/' + filePath);
            if (link == null) {
                Intrinsics.throwNpe();
            }
            Link link2 = link;
            String string7 = link2.getTypeLink();
            if (string7 == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)(mimeType = string7), (Object)"application/xhtml+xml")) {
                return this.serveResponse(session, fetcher.dataStream(filePath), mimeType);
            }
            return this.serveResponse(session, fetcher.dataStream(filePath), mimeType);
        }
        catch (Exception e) {
            String string8 = this.TAG + " Exception " + e.toString();
            System.out.println((Object)string8);
            Log.e((String)this.TAG, (String)e.toString());
            return Response.newFixedLengthResponse((IStatus)((IStatus)Status.INTERNAL_ERROR), (String)this.getMimeType(), (String)"{\"success\":false}");
        }
    }

    private final Response serveResponse(IHTTPSession session, InputStream inputStream, String mimeType) {
        Response response;
        Response response2;
        String rangeRequest = (String)session.getHeaders().get("range");
        try {
            String etag = Integer.toHexString(inputStream.hashCode());
            long startFrom = 0L;
            long endAt = -1L;
            if (rangeRequest != null && StringsKt.startsWith$default((String)rangeRequest, (String)"bytes=", (boolean)false, (int)2, null)) {
                String string = rangeRequest;
                int n = "bytes=".length();
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                rangeRequest = string2;
                int minus = StringsKt.indexOf$default((CharSequence)rangeRequest, (char)'-', (int)0, (boolean)false, (int)6, null);
                try {
                    if (minus > 0) {
                        String string3 = rangeRequest;
                        int n2 = 0;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(n2, minus);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        startFrom = Long.parseLong(string5);
                        string3 = rangeRequest;
                        n2 = minus + 1;
                        String string6 = string3;
                        if (string6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                        endAt = Long.parseLong(string7);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long streamLength = inputStream.available();
            if (rangeRequest != null && startFrom >= 0L) {
                if (startFrom >= streamLength) {
                    response2 = this.createResponse(Status.RANGE_NOT_SATISFIABLE, "text/plain", "");
                    response2.addHeader("Content-Range", "bytes 0-0/" + streamLength);
                    response2.addHeader("ETag", etag);
                } else {
                    long newLen;
                    if (endAt < 0L) {
                        endAt = streamLength - 1L;
                    }
                    if ((newLen = endAt - startFrom + 1L) < 0L) {
                        newLen = 0L;
                    }
                    long dataLen = newLen;
                    inputStream.skip(startFrom);
                    response2 = this.createResponse(Status.PARTIAL_CONTENT, mimeType, inputStream);
                    response2.addHeader("Content-Length", "" + dataLen);
                    response2.addHeader("Content-Range", "bytes " + startFrom + '-' + endAt + '/' + streamLength);
                    response2.addHeader("ETag", etag);
                }
            } else if (Intrinsics.areEqual((Object)etag, (Object)((String)session.getHeaders().get("if-none-match")))) {
                response2 = this.createResponse(Status.NOT_MODIFIED, mimeType, "");
            } else {
                response2 = this.createResponse(Status.OK, mimeType, inputStream);
                response2.addHeader("Content-Length", "" + streamLength);
                response2.addHeader("ETag", etag);
            }
        }
        catch (IOException ioe) {
            response2 = this.getResponse("Forbidden: Reading file failed");
        }
        catch (NullPointerException ioe) {
            response2 = this.getResponse("Forbidden: Reading file failed");
        }
        if ((response = response2) == null) {
            response = this.getResponse("Error 404: File not found");
        }
        return response;
    }

    private final Response createResponse(Status status, String mimeType, InputStream message) {
        Response response = Response.newChunkedResponse((IStatus)((IStatus)status), (String)mimeType, (InputStream)message);
        response.addHeader("Accept-Ranges", "bytes");
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2;
    }

    private final Response createResponse(Status status, String mimeType, String message) {
        Response response = Response.newFixedLengthResponse((IStatus)((IStatus)status), (String)mimeType, (String)message);
        response.addHeader("Accept-Ranges", "bytes");
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2;
    }

    private final Response getResponse(String message) {
        return this.createResponse(Status.OK, "text/plain", message);
    }
}

