/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.streamer.container.Container;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lorg/readium/r2/streamer/container/DirectoryContainer;", "Lorg/readium/r2/streamer/container/Container;", "data", "", "relativePath", "", "dataInputStream", "Ljava/io/FileInputStream;", "dataLength", "", "r2-streamer_intTestappDebug"})
public interface DirectoryContainer
extends Container {
    @Override
    @NotNull
    public byte[] data(@NotNull String var1);

    @Override
    public long dataLength(@NotNull String var1);

    @Override
    @NotNull
    public FileInputStream dataInputStream(@NotNull String var1);

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static byte[] data(DirectoryContainer $this, @NotNull String relativePath) {
            int nRead;
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            String filePath = $this.getRootFile().toString() + "/" + relativePath;
            File epubFile = new File(filePath);
            if (!epubFile.exists()) {
                throw (Throwable)new Exception("Missing File");
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            FileInputStream fis = new FileInputStream(epubFile);
            do {
                nRead = fis.read(data, 0, data.length);
                buffer.write(data, 0, nRead);
            } while (nRead != -1);
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"buffer.toByteArray()");
            return byArray;
        }

        public static long dataLength(DirectoryContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new File($this.getRootFile().toString() + "/" + relativePath).length();
        }

        @NotNull
        public static FileInputStream dataInputStream(DirectoryContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new FileInputStream(new File($this.getRootFile().toString() + "/" + relativePath));
        }
    }
}

