/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.drm.Drm;
import org.readium.r2.shared.parser.xml.XmlParser;
import org.readium.r2.streamer.container.EpubContainer;
import org.readium.r2.streamer.container.ZipArchiveContainer;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0012\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/readium/r2/streamer/container/ContainerEpub;", "Lorg/readium/r2/streamer/container/EpubContainer;", "Lorg/readium/r2/streamer/container/ZipArchiveContainer;", "path", "", "(Ljava/lang/String;)V", "drm", "Lorg/readium/r2/shared/drm/Drm;", "getDrm", "()Lorg/readium/r2/shared/drm/Drm;", "setDrm", "(Lorg/readium/r2/shared/drm/Drm;)V", "rootFile", "Lorg/readium/r2/shared/RootFile;", "getRootFile", "()Lorg/readium/r2/shared/RootFile;", "setRootFile", "(Lorg/readium/r2/shared/RootFile;)V", "successCreated", "", "getSuccessCreated", "()Z", "setSuccessCreated", "(Z)V", "zipFile", "Ljava/util/zip/ZipFile;", "getZipFile", "()Ljava/util/zip/ZipFile;", "setZipFile", "(Ljava/util/zip/ZipFile;)V", "xmlDocumentForFile", "Lorg/readium/r2/shared/parser/xml/XmlParser;", "relativePath", "xmlDocumentForResource", "link", "Lorg/readium/r2/shared/Link;", "r2-streamer_release"})
public final class ContainerEpub
implements EpubContainer,
ZipArchiveContainer {
    @NotNull
    private RootFile rootFile;
    @NotNull
    private ZipFile zipFile;
    @Nullable
    private Drm drm;
    private boolean successCreated;

    @Override
    @NotNull
    public XmlParser xmlDocumentForFile(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        byte[] containerData = this.data(relativePath);
        XmlParser document = new XmlParser();
        byte[] byArray = containerData;
        XmlParser xmlParser = document;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xmlParser.parseXml((InputStream)byteArrayInputStream);
        return document;
    }

    @Override
    @NotNull
    public XmlParser xmlDocumentForResource(@Nullable Link link) {
        Object object = link;
        if (object == null || (object = object.getHref()) == null) {
            Link link2 = link;
            throw (Throwable)new Exception("Missing Link : " + (link2 != null ? link2.getTitle() : null));
        }
        Object pathFile = object;
        if (StringsKt.first((CharSequence)((CharSequence)pathFile)) == '/') {
            Object object2 = pathFile;
            int n = 1;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            pathFile = string;
        }
        return this.xmlDocumentForFile((String)pathFile);
    }

    @Override
    @NotNull
    public RootFile getRootFile() {
        return this.rootFile;
    }

    @Override
    public void setRootFile(@NotNull RootFile rootFile) {
        Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"<set-?>");
        this.rootFile = rootFile;
    }

    @Override
    @NotNull
    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public void setZipFile(@NotNull ZipFile zipFile) {
        Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"<set-?>");
        this.zipFile = zipFile;
    }

    @Override
    @Nullable
    public Drm getDrm() {
        return this.drm;
    }

    @Override
    public void setDrm(@Nullable Drm drm) {
        this.drm = drm;
    }

    @Override
    public boolean getSuccessCreated() {
        return this.successCreated;
    }

    @Override
    public void setSuccessCreated(boolean bl) {
        this.successCreated = bl;
    }

    public ContainerEpub(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (new File(path).exists()) {
            this.setSuccessCreated(true);
        }
        this.setZipFile(new ZipFile(path));
        this.setRootFile(new RootFile(path, "application/epub+zip", null, null, 12, null));
    }

    @Override
    @NotNull
    public byte[] data(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return ZipArchiveContainer.DefaultImpls.data(this, relativePath);
    }

    @Override
    public long dataLength(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return ZipArchiveContainer.DefaultImpls.dataLength(this, relativePath);
    }

    @Override
    @NotNull
    public InputStream dataInputStream(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return ZipArchiveContainer.DefaultImpls.dataInputStream(this, relativePath);
    }
}

