/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Parser.EpubParserSubClasses;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Encryption;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.XmlParser.Node;
import org.readium.r2.streamer.Parser.PublicationParserKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/EncryptionParser;", "", "()V", "add", "", "encryption", "Lorg/readium/r2/shared/Encryption;", "publication", "Lorg/readium/r2/shared/Publication;", "encryptedDataElement", "Lorg/readium/r2/shared/XmlParser/Node;", "parseCompressionElement", "encryptionProperty", "parseEncryptionProperties", "r2-streamer_release"})
public final class EncryptionParser {
    public final void parseEncryptionProperties(@NotNull Node encryptedDataElement, @NotNull Encryption encryption) {
        Intrinsics.checkParameterIsNotNull((Object)encryptedDataElement, (String)"encryptedDataElement");
        Intrinsics.checkParameterIsNotNull((Object)encryption, (String)"encryption");
        Object object = encryptedDataElement.getFirst("EncryptionProperties");
        if (object == null || (object = object.get("EncryptionProperty")) == null) {
            return;
        }
        Object encryptionProperties = object;
        Iterator iterator = encryptionProperties.iterator();
        while (iterator.hasNext()) {
            Node encryptionProperty = (Node)iterator.next();
            this.parseCompressionElement(encryptionProperty, encryption);
        }
    }

    public final void parseCompressionElement(@NotNull Node encryptionProperty, @NotNull Encryption encryption) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)encryptionProperty, (String)"encryptionProperty");
        Intrinsics.checkParameterIsNotNull((Object)encryption, (String)"encryption");
        Node node = encryptionProperty.getFirst("Compression");
        if (node == null) {
            return;
        }
        Node compressionElement = node;
        String originalLength = (String)compressionElement.getAttributes().get("OriginalLength");
        Encryption encryption2 = encryption;
        String string = originalLength;
        if (string != null) {
            String string2 = string;
            Encryption encryption3 = encryption2;
            int n2 = Integer.parseInt(string2);
            encryption2 = encryption3;
            n = n2;
        } else {
            n = null;
        }
        encryption2.setOriginalLength(n);
        String string3 = (String)compressionElement.getAttributes().get("Method");
        if (string3 == null) {
            return;
        }
        String method = string3;
        encryption.setCompression(Intrinsics.areEqual((Object)method, (Object)"8") ? "deflate" : "none");
    }

    public final void add(@NotNull Encryption encryption, @NotNull Publication publication, @NotNull Node encryptedDataElement) {
        Node node;
        Node it;
        Intrinsics.checkParameterIsNotNull((Object)encryption, (String)"encryption");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)encryptedDataElement, (String)"encryptedDataElement");
        Object object = encryptedDataElement.getFirst("CipherData");
        if (object == null || (object = object.getFirst("CipherReference")) == null || (object = (String)(it = (node = object)).getAttributes().get("URI")) == null) {
            return;
        }
        Object resourceURI = object;
        resourceURI = PublicationParserKt.normalize("/", (String)resourceURI);
        Link link = publication.linkWithHref((String)resourceURI);
        if (link == null) {
            return;
        }
        Link link2 = link;
        link2.getProperties().setEncryption(encryption);
    }
}

