/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Parser;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Encryption;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.XmlParser.Node;
import org.readium.r2.shared.XmlParser.XmlParser;
import org.readium.r2.shared.drm.Drm;
import org.readium.r2.streamer.Containers.Container;
import org.readium.r2.streamer.Containers.ContainerEpub;
import org.readium.r2.streamer.Containers.ContainerEpubDirectory;
import org.readium.r2.streamer.Containers.EpubContainer;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.EncryptionParser;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.NCXParser;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.NavigationDocumentParser;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.OPFParser;
import org.readium.r2.streamer.Parser.PubBox;
import org.readium.r2.streamer.Parser.PublicationParser;
import org.zeroturnaround.zip.ZipUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J,\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u000f0\"2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/readium/r2/streamer/Parser/EpubParser;", "Lorg/readium/r2/streamer/Parser/PublicationParser;", "()V", "TAG", "", "kotlin.jvm.PlatformType", "encp", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/EncryptionParser;", "ncxp", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/NCXParser;", "ndp", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/NavigationDocumentParser;", "opfParser", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/OPFParser;", "fillEncryptionProfile", "Lorg/readium/r2/shared/Publication;", "publication", "drm", "Lorg/readium/r2/shared/drm/Drm;", "generateContainerFrom", "Lorg/readium/r2/streamer/Containers/EpubContainer;", "path", "getRootFilePath", "data", "", "parse", "Lorg/readium/r2/streamer/Parser/PubBox;", "fileAtPath", "parseEncryption", "", "container", "parseNavigationDocument", "parseNcxDocument", "parseRemainingResource", "Lkotlin/Pair;", "Lorg/readium/r2/streamer/Containers/Container;", "scanForDrm", "r2-streamer_release"})
public final class EpubParser
implements PublicationParser {
    private final String TAG = this.getClass().getSimpleName();
    private final OPFParser opfParser = new OPFParser();
    private final NavigationDocumentParser ndp = new NavigationDocumentParser();
    private final NCXParser ncxp = new NCXParser();
    private final EncryptionParser encp = new EncryptionParser();

    private final EpubContainer generateContainerFrom(String path) {
        EpubContainer epubContainer;
        boolean isDirectory = new File(path).isDirectory();
        if (!new File(path).exists()) {
            throw (Throwable)new Exception("Missing File");
        }
        boolean bl = isDirectory;
        if (bl) {
            epubContainer = new ContainerEpubDirectory(path);
        } else if (!bl) {
            epubContainer = new ContainerEpub(path);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EpubContainer container = epubContainer;
        if (!container.getSuccessCreated()) {
            throw (Throwable)new Exception("Missing File");
        }
        return container;
    }

    @NotNull
    public final Pair<Container, Publication> parseRemainingResource(@NotNull Container container, @NotNull Publication publication, @Nullable Drm drm) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        container.setDrm(drm);
        this.fillEncryptionProfile(publication, drm);
        this.parseNavigationDocument((EpubContainer)container, publication);
        this.parseNcxDocument((EpubContainer)container, publication);
        return new Pair((Object)container, (Object)publication);
    }

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath) {
        byte[] documentData;
        byte[] byArray;
        byte[] e2;
        EpubContainer epubContainer;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        try {
            epubContainer = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            Log.e((String)"Error", (String)"Could not generate container", (Throwable)e2);
            return null;
        }
        EpubContainer container = epubContainer;
        try {
            e2 = container.data("META-INF/container.xml");
        }
        catch (Exception e3) {
            Log.e((String)"Error", (String)"Missing File : META-INF/container.xml", (Throwable)e3);
            return null;
        }
        byte[] data = e2;
        container.getRootFile().setMimetype("application/epub+zip");
        container.getRootFile().setRootFilePath(this.getRootFilePath(data));
        XmlParser xmlParser = new XmlParser();
        try {
            byArray = container.data(container.getRootFile().getRootFilePath());
        }
        catch (Exception e4) {
            Log.e((String)"Error", (String)("Missing File : " + container.getRootFile().getRootFilePath()), (Throwable)e4);
            return null;
        }
        byArray = documentData = byArray;
        XmlParser xmlParser2 = xmlParser;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xmlParser2.parseXml((InputStream)byteArrayInputStream);
        Object v = xmlParser.root().getAttributes().get("version");
        if (v == null) {
            Intrinsics.throwNpe();
        }
        String string = (String)v;
        double epubVersion = Double.parseDouble(string);
        Publication publication = this.opfParser.parseOpf(xmlParser, container.getRootFile().getRootFilePath(), epubVersion);
        if (publication == null) {
            return null;
        }
        Publication publication2 = publication;
        Drm drm = this.scanForDrm(container);
        this.parseEncryption(container, publication2, drm);
        EpubContainer epubContainer2 = container;
        if (epubContainer2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.readium.r2.streamer.Containers.EpubContainer");
        }
        this.parseNavigationDocument(epubContainer2, publication2);
        this.parseNcxDocument(container, publication2);
        container.setDrm(drm);
        return new PubBox(publication2, container);
    }

    private final String getRootFilePath(byte[] data) {
        XmlParser xmlParser = new XmlParser();
        byte[] byArray = data;
        XmlParser xmlParser2 = xmlParser;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xmlParser2.parseXml((InputStream)byteArrayInputStream);
        Object object = xmlParser.getFirst("container");
        if (object == null || (object = object.getFirst("rootfiles")) == null || (object = object.getFirst("rootfile")) == null || (object = object.getAttributes()) == null || (object = (String)object.get("full-path")) == null) {
            object = "content.opf";
        }
        return object;
    }

    private final Publication fillEncryptionProfile(Publication publication, Drm drm) {
        Drm drm2 = drm;
        if (drm2 != null) {
            Drm drm3;
            Drm it = drm3 = drm2;
            for (Link link : publication.getResources()) {
                Encryption encryption = link.getProperties().getEncryption();
                if ((encryption != null ? encryption.getScheme() : null) != it.getScheme()) continue;
                Encryption encryption2 = link.getProperties().getEncryption();
                if (encryption2 == null) continue;
                encryption2.setProfile(it.getProfile());
            }
            for (Link link : publication.getSpine()) {
                Encryption encryption = link.getProperties().getEncryption();
                if ((encryption != null ? encryption.getScheme() : null) != it.getScheme()) continue;
                Encryption encryption3 = link.getProperties().getEncryption();
                if (encryption3 == null) continue;
                encryption3.setProfile(it.getProfile());
            }
        }
        return publication;
    }

    @Nullable
    public final Drm scanForDrm(@NotNull EpubContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        if (ZipUtil.containsEntry((File)new File(container.getRootFile().getRootPath()), (String)"META-INF/license.lcpl")) {
            return new Drm(Drm.Brand.lcp);
        }
        return null;
    }

    private final void parseEncryption(EpubContainer container, Publication publication, Drm drm) {
        byte[] byArray;
        try {
            byArray = container.data("META-INF/encryption.xml");
        }
        catch (Exception e) {
            return;
        }
        byte[] documentData = byArray;
        XmlParser document = new XmlParser();
        byte[] e = documentData;
        XmlParser xmlParser = document;
        Object object = new ByteArrayInputStream(e);
        xmlParser.parseXml((InputStream)object);
        Object object2 = document.getFirst("encryption");
        if (object2 == null || (object2 = object2.get("EncryptedData")) == null) {
            return;
        }
        Object encryptedDataElements = object2;
        Iterator iterator = encryptedDataElements.iterator();
        while (iterator.hasNext()) {
            Object object3;
            String keyInfoUri;
            String string;
            Node it;
            Node node;
            Node encryptedDataElement = (Node)iterator.next();
            Encryption encryption = new Encryption();
            Node node2 = encryptedDataElement.getFirst("KeyInfo");
            if (node2 != null && (node2 = node2.getFirst("RetrievalMethod")) != null) {
                it = node = node2;
                string = (String)it.getAttributes().get("URI");
            } else {
                string = keyInfoUri = null;
            }
            if (Intrinsics.areEqual(keyInfoUri, (Object)"license.lcpl#/encryption/content_key")) {
                Drm drm2 = drm;
                if ((drm2 != null ? drm2.getBrand() : null) == Drm.Brand.lcp) {
                    encryption.setScheme(Drm.Scheme.lcp);
                }
            }
            Encryption encryption2 = encryption;
            if (encryptedDataElement.getFirst("EncryptionMethod") != null) {
                xmlParser = encryption2;
                it = node;
                object = (String)it.getAttributes().get("Algorithm");
                encryption2 = xmlParser;
                object3 = object;
            } else {
                object3 = null;
            }
            encryption2.setAlgorithm(object3);
            this.encp.parseEncryptionProperties(encryptedDataElement, encryption);
            this.encp.add(encryption, publication, encryptedDataElement);
        }
    }

    private final void parseNavigationDocument(EpubContainer container, Publication publication) {
        Object object;
        Link link = publication.linkWithRel("contents");
        if (link == null) {
            return;
        }
        Link navLink = link;
        try {
            object = container.xmlDocumentforResource(navLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Navigation parsing", (Throwable)e);
            return;
        }
        XmlParser navDocument = object;
        String string = navLink.getHref();
        if (string == null) {
            return;
        }
        this.ndp.setNavigationDocumentPath(string);
        object = publication.getTableOfContents();
        Iterable iterable = this.ndp.tableOfContent(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getLandmarks();
        iterable = this.ndp.landmarks(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfAudioFiles();
        iterable = this.ndp.listOfAudiofiles(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfIllustrations();
        iterable = this.ndp.listOfIllustrations(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfTables();
        iterable = this.ndp.listOfTables(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfVideos();
        iterable = this.ndp.listOfVideos(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getPageList();
        iterable = this.ndp.pageList(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
    }

    private final void parseNcxDocument(EpubContainer container, Publication publication) {
        Iterable iterable;
        Object object;
        Object v0;
        block7: {
            Iterable $receiver$iv = publication.getResources();
            for (Object element$iv : $receiver$iv) {
                Link it = (Link)element$iv;
                if (!Intrinsics.areEqual((Object)it.getTypeLink(), (Object)"application/x-dtbncx+xml")) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        Link link = v0;
        if (link == null) {
            return;
        }
        Link ncxLink = link;
        try {
            object = container.xmlDocumentforResource(ncxLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Ncx parsing", (Throwable)e);
            return;
        }
        XmlParser ncxDocument = object;
        String string = ncxLink.getHref();
        if (string == null) {
            return;
        }
        this.ncxp.setNcxDocumentPath(string);
        if (publication.getTableOfContents().isEmpty()) {
            object = publication.getTableOfContents();
            iterable = this.ncxp.tableOfContents(ncxDocument);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        }
        if (publication.getPageList().isEmpty()) {
            object = publication.getPageList();
            iterable = this.ncxp.pageList(ncxDocument);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        }
    }
}

