/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Fetcher;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.shared.RenditionLayout;
import org.readium.r2.streamer.Containers.Container;
import org.readium.r2.streamer.Fetcher.ContentFilters;
import org.readium.r2.streamer.Fetcher.DrmDecoder;
import org.readium.r2.streamer.Fetcher.FontDecoder;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u000f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/readium/r2/streamer/Fetcher/ContentFiltersEpub;", "Lorg/readium/r2/streamer/Fetcher/ContentFilters;", "()V", "drmDecoder", "Lorg/readium/r2/streamer/Fetcher/DrmDecoder;", "getDrmDecoder", "()Lorg/readium/r2/streamer/Fetcher/DrmDecoder;", "setDrmDecoder", "(Lorg/readium/r2/streamer/Fetcher/DrmDecoder;)V", "fontDecoder", "Lorg/readium/r2/streamer/Fetcher/FontDecoder;", "getFontDecoder", "()Lorg/readium/r2/streamer/Fetcher/FontDecoder;", "setFontDecoder", "(Lorg/readium/r2/streamer/Fetcher/FontDecoder;)V", "apply", "Ljava/io/InputStream;", "input", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/Containers/Container;", "path", "", "", "getHtmlLink", "ressourceName", "getHtmlScript", "injectFixedLayohtHtml", "stream", "baseUrl", "Ljava/net/URL;", "injectReflowableHtml", "r2-streamer_release"})
public final class ContentFiltersEpub
implements ContentFilters {
    @NotNull
    private FontDecoder fontDecoder = new FontDecoder();
    @NotNull
    private DrmDecoder drmDecoder = new DrmDecoder();

    @Override
    @NotNull
    public FontDecoder getFontDecoder() {
        return this.fontDecoder;
    }

    @Override
    public void setFontDecoder(@NotNull FontDecoder fontDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)fontDecoder, (String)"<set-?>");
        this.fontDecoder = fontDecoder;
    }

    @Override
    @NotNull
    public DrmDecoder getDrmDecoder() {
        return this.drmDecoder;
    }

    @Override
    public void setDrmDecoder(@NotNull DrmDecoder drmDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)drmDecoder, (String)"<set-?>");
        this.drmDecoder = drmDecoder;
    }

    @Override
    @NotNull
    public InputStream apply(@NotNull InputStream input, @NotNull Publication publication, @NotNull Container container, @NotNull String path) {
        ContentFiltersEpub contentFiltersEpub;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Link link = publication.linkWithHref(path);
        if (link != null) {
            URL baseUrl;
            Link link2;
            Link resourceLink = link2 = link;
            InputStream decodedInputStream = this.getDrmDecoder().decoding(input, resourceLink, container.getDrm());
            decodedInputStream = this.getFontDecoder().decoding(decodedInputStream, publication, path);
            URL uRL = publication.baseUrl();
            URL uRL2 = baseUrl = uRL != null ? PublicationKt.removeLastComponent((URL)uRL) : null;
            if ((Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"application/xhtml+xml") || Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"text/html")) && baseUrl != null) {
                decodedInputStream = publication.getMetadata().getRendition().getLayout() == RenditionLayout.reflowable && resourceLink.getProperties().getLayout() == null || Intrinsics.areEqual((Object)resourceLink.getProperties().getLayout(), (Object)"reflowable") ? this.injectReflowableHtml(decodedInputStream, baseUrl) : this.injectFixedLayohtHtml(decodedInputStream, baseUrl);
            }
            return decodedInputStream;
        }
        ContentFiltersEpub $receiver = contentFiltersEpub = this;
        return input;
    }

    @Override
    @NotNull
    public byte[] apply(@NotNull byte[] input, @NotNull Publication publication, @NotNull Container container, @NotNull String path) {
        ContentFiltersEpub contentFiltersEpub;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Link link = publication.linkWithHref(path);
        if (link != null) {
            URL baseUrl;
            Link link2;
            Link resourceLink = link2 = link;
            byte[] byArray = input;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray);
            InputStream decodedInputStream = this.getDrmDecoder().decoding(inputStream, resourceLink, container.getDrm());
            decodedInputStream = this.getFontDecoder().decoding(decodedInputStream, publication, path);
            URL uRL = publication.baseUrl();
            URL uRL2 = baseUrl = uRL != null ? PublicationKt.removeLastComponent((URL)uRL) : null;
            if ((Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"application/xhtml+xml") || Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"text/html")) && baseUrl != null) {
                decodedInputStream = publication.getMetadata().getRendition().getLayout() == RenditionLayout.reflowable && (resourceLink.getProperties().getLayout() == null || Intrinsics.areEqual((Object)resourceLink.getProperties().getLayout(), (Object)"reflowable")) ? this.injectReflowableHtml(decodedInputStream, baseUrl) : this.injectFixedLayohtHtml(decodedInputStream, baseUrl);
            }
            return ByteStreamsKt.readBytes$default((InputStream)decodedInputStream, (int)0, (int)1, null);
        }
        ContentFiltersEpub $receiver = contentFiltersEpub = this;
        return input;
    }

    private final InputStream injectReflowableHtml(InputStream stream, URL baseUrl) {
        byte[] data = ByteStreamsKt.readBytes$default((InputStream)stream, (int)0, (int)1, null);
        String resourceHtml = new String(data, Charsets.UTF_8);
        int beginHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<head>", (int)0, (boolean)false) + 6;
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        List endIncludes = new ArrayList();
        List beginIncludes = new ArrayList();
        beginIncludes.add("<meta name=\"viewport\" content=\"width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=0;\"/>");
        beginIncludes.add(this.getHtmlLink("/styles/before.css"));
        beginIncludes.add(this.getHtmlLink("/styles/default.css"));
        beginIncludes.add(this.getHtmlLink("/styles/transition.css"));
        endIncludes.add(this.getHtmlLink("/styles/after.css"));
        endIncludes.add(this.getHtmlScript("/scripts/touchHandling.js"));
        endIncludes.add(this.getHtmlScript("/scripts/utils.js"));
        for (String element : beginIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(beginHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            beginHeadIndex += element.length();
            endHeadIndex += element.length();
        }
        for (String element : endIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            endHeadIndex += element.length();
        }
        String string = new StringBuilder(resourceHtml).insert(endHeadIndex, "<style>@import url('https://fonts.googleapis.com/css?family=PT+Serif|Roboto|Source+Sans+Pro|Vollkorn');</style> ").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(resourceHt\u2026');</style> \").toString()");
        resourceHtml = string;
        Object object = resourceHtml;
        Charset charset = Charsets.UTF_8;
        String string2 = object;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        return new ByteArrayInputStream((byte[])object);
    }

    private final InputStream injectFixedLayohtHtml(InputStream stream, URL baseUrl) {
        byte[] data = ByteStreamsKt.readBytes$default((InputStream)stream, (int)0, (int)1, null);
        String resourceHtml = new String(data, Charsets.UTF_8);
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        List includes = new ArrayList();
        String url = baseUrl.toString();
        includes.add("<meta name=\"viewport\" content=\"width=1024; height=768; left=50%; top=50%; bottom=auto; right=auto; transform=translate(-50%, -50%);\"/>\n");
        includes.add(this.getHtmlScript(url + "scripts/touchHandling.js"));
        includes.add(this.getHtmlScript(url + "scripts/utils.js"));
        for (String element : includes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
        }
        Object object = resourceHtml;
        Charset charset = Charsets.UTF_8;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        return new ByteArrayInputStream((byte[])object);
    }

    @NotNull
    public final String getHtmlLink(@NotNull String ressourceName) {
        Intrinsics.checkParameterIsNotNull((Object)ressourceName, (String)"ressourceName");
        String prefix = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
        String suffix = "\"/>\n";
        return prefix + ressourceName + suffix;
    }

    @NotNull
    public final String getHtmlScript(@NotNull String ressourceName) {
        Intrinsics.checkParameterIsNotNull((Object)ressourceName, (String)"ressourceName");
        String prefix = "<script type=\"text/javascript\" src=\"";
        String suffix = "\"></script>\n";
        return prefix + ressourceName + suffix;
    }
}

