/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Server.handler;

import android.util.Log;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.streamer.Fetcher.Fetcher;
import org.readium.r2.streamer.Server.handler.ResponseStatus;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J3\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/readium/r2/streamer/Server/handler/ResourceHandler;", "Lfi/iki/elonen/router/RouterNanoHTTPD$DefaultHandler;", "()V", "fonts", "", "", "[Ljava/lang/String;", "createResponse", "Lfi/iki/elonen/NanoHTTPD$Response;", "status", "Lfi/iki/elonen/NanoHTTPD$Response$Status;", "mimeType", "message", "Ljava/io/InputStream;", "get", "uriResource", "Lfi/iki/elonen/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "getMimeType", "getResponse", "getStatus", "Lfi/iki/elonen/NanoHTTPD$Response$IStatus;", "getText", "isFontFile", "", "file", "serveResponse", "inputStream", "Companion", "r2-streamer_release"})
public final class ResourceHandler
extends RouterNanoHTTPD.DefaultHandler {
    private final String[] fonts = new String[]{".woff", ".ttf", ".obf", ".woff2", ".eot", ".otf"};
    private static final String TAG = "ResourceHandler";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String getMimeType() {
        return null;
    }

    @NotNull
    public String getText() {
        return ResponseStatus.INSTANCE.getFAILURE_RESPONSE();
    }

    @NotNull
    public NanoHTTPD.Response.IStatus getStatus() {
        return (NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK;
    }

    @NotNull
    public NanoHTTPD.Response get(@Nullable RouterNanoHTTPD.UriResource uriResource, @Nullable Map<String, String> urlParams, @Nullable NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.IHTTPSession iHTTPSession = session;
        if (iHTTPSession == null) {
            Intrinsics.throwNpe();
        }
        NanoHTTPD.Method method = iHTTPSession.getMethod();
        String uri = session.getUri();
        String string = "" + ResourceHandler.Companion.getTAG() + " Method: " + method + ", Url: " + uri;
        System.out.println((Object)string);
        try {
            String mimeType;
            RouterNanoHTTPD.UriResource uriResource2 = uriResource;
            if (uriResource2 == null) {
                Intrinsics.throwNpe();
            }
            Fetcher fetcher = (Fetcher)uriResource2.initParameter(Fetcher.class);
            String string2 = uri;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri");
            int offset = StringsKt.indexOf$default((CharSequence)string2, (String)"/", (int)0, (boolean)false, (int)4, null);
            int startIndex = StringsKt.indexOf$default((CharSequence)uri, (String)"/", (int)(offset + 1), (boolean)false, (int)4, null);
            String string3 = uri;
            int n = startIndex + 1;
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String filePath = string4;
            Link link = fetcher.getPublication().linkWithHref("/" + filePath);
            if (link == null) {
                Intrinsics.throwNpe();
            }
            Link link2 = link;
            String string5 = link2.getTypeLink();
            if (string5 == null) {
                Intrinsics.throwNpe();
            }
            return Intrinsics.areEqual((Object)(mimeType = string5), (Object)"application/xhtml+xml") ? this.serveResponse(session, fetcher.dataStream(filePath), mimeType) : this.serveResponse(session, fetcher.dataStream(filePath), mimeType);
        }
        catch (Exception e) {
            String string6 = ResourceHandler.Companion.getTAG() + " Exception " + e.toString();
            System.out.println((Object)string6);
            Log.e((String)ResourceHandler.Companion.getTAG(), (String)e.toString());
            NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR), (String)this.getMimeType(), (String)ResponseStatus.INSTANCE.getFAILURE_RESPONSE());
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"NanoHTTPD.newFixedLength\u2026eStatus.FAILURE_RESPONSE)");
            return response;
        }
    }

    private final NanoHTTPD.Response serveResponse(NanoHTTPD.IHTTPSession session, InputStream inputStream, String mimeType) {
        NanoHTTPD.Response response;
        String rangeRequest = (String)session.getHeaders().get("range");
        try {
            String etag = Integer.toHexString(inputStream.hashCode());
            long startFrom = 0L;
            long endAt = -1L;
            if (rangeRequest != null && StringsKt.startsWith$default((String)rangeRequest, (String)"bytes=", (boolean)false, (int)2, null)) {
                String string = rangeRequest;
                int n = "bytes=".length();
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                rangeRequest = string2;
                int minus = StringsKt.indexOf$default((CharSequence)rangeRequest, (char)'-', (int)0, (boolean)false, (int)6, null);
                try {
                    if (minus > 0) {
                        String string3 = rangeRequest;
                        int n2 = 0;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(n2, minus);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        startFrom = Long.parseLong(string5);
                        string3 = rangeRequest;
                        n2 = minus + 1;
                        String string6 = string3;
                        if (string6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                        endAt = Long.parseLong(string7);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long streamLength = inputStream.available();
            if (rangeRequest != null && startFrom >= 0L) {
                if (startFrom >= streamLength) {
                    response = this.createResponse(NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE, "text/plain", "");
                    response.addHeader("Content-Range", "bytes 0-0/" + streamLength);
                    response.addHeader("ETag", etag);
                } else {
                    long newLen;
                    if (endAt < 0L) {
                        endAt = streamLength - 1L;
                    }
                    if ((newLen = endAt - startFrom + 1L) < 0L) {
                        newLen = 0L;
                    }
                    long dataLen = newLen;
                    inputStream.skip(startFrom);
                    response = this.createResponse(NanoHTTPD.Response.Status.PARTIAL_CONTENT, mimeType, inputStream);
                    response.addHeader("Content-Length", "" + dataLen);
                    response.addHeader("Content-Range", "bytes " + startFrom + '-' + endAt + '/' + streamLength);
                    response.addHeader("ETag", etag);
                }
            } else if (Intrinsics.areEqual((Object)etag, (Object)((String)session.getHeaders().get("if-none-match")))) {
                response = this.createResponse(NanoHTTPD.Response.Status.NOT_MODIFIED, mimeType, "");
            } else {
                response = this.createResponse(NanoHTTPD.Response.Status.OK, mimeType, inputStream);
                response.addHeader("Content-Length", "" + streamLength);
                response.addHeader("ETag", etag);
            }
        }
        catch (IOException ioe) {
            response = this.getResponse("Forbidden: Reading file failed");
        }
        catch (NullPointerException ioe) {
            response = this.getResponse("Forbidden: Reading file failed");
        }
        return response == null ? this.getResponse("Error 404: File not found") : response;
    }

    private final NanoHTTPD.Response createResponse(NanoHTTPD.Response.Status status, String mimeType, InputStream message) {
        NanoHTTPD.Response response = NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)status), (String)mimeType, (InputStream)message);
        response.addHeader("Accept-Ranges", "bytes");
        NanoHTTPD.Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2;
    }

    private final NanoHTTPD.Response createResponse(NanoHTTPD.Response.Status status, String mimeType, String message) {
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)status), (String)mimeType, (String)message);
        response.addHeader("Accept-Ranges", "bytes");
        NanoHTTPD.Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2;
    }

    private final NanoHTTPD.Response getResponse(String message) {
        return this.createResponse(NanoHTTPD.Response.Status.OK, "text/plain", message);
    }

    private final boolean isFontFile(String file) {
        String[] stringArray = this.fonts;
        for (int i = 0; i < stringArray.length; ++i) {
            String font = stringArray[i];
            if (!StringsKt.endsWith$default((String)file, (String)font, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    static {
        TAG = TAG;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/streamer/Server/handler/ResourceHandler$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "r2-streamer_release"})
    public static final class Companion {
        private final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

