/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Server.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.MediaOverlayNode;
import org.readium.r2.shared.MediaOverlays;
import org.readium.r2.streamer.Fetcher.Fetcher;
import org.readium.r2.streamer.Server.handler.ResponseStatus;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J \u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/readium/r2/streamer/Server/handler/MediaOverlayHandler;", "Lfi/iki/elonen/router/RouterNanoHTTPD$DefaultHandler;", "()V", "get", "Lfi/iki/elonen/NanoHTTPD$Response;", "uriResource", "Lfi/iki/elonen/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "getMediaOverlay", "Lorg/readium/r2/shared/MediaOverlays;", "spines", "", "Lorg/readium/r2/shared/Link;", "searchQueryPath", "getMimeType", "getStatus", "Lfi/iki/elonen/NanoHTTPD$Response$IStatus;", "getText", "Companion", "r2-streamer_release"})
public final class MediaOverlayHandler
extends RouterNanoHTTPD.DefaultHandler {
    private static final String TAG;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return ResponseStatus.INSTANCE.getFAILURE_RESPONSE();
    }

    @NotNull
    public String getMimeType() {
        return "application/webpub+json";
    }

    @NotNull
    public NanoHTTPD.Response.IStatus getStatus() {
        return (NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK;
    }

    @NotNull
    public NanoHTTPD.Response get(@Nullable RouterNanoHTTPD.UriResource uriResource, @Nullable Map<String, String> urlParams, @Nullable NanoHTTPD.IHTTPSession session) {
        RouterNanoHTTPD.UriResource uriResource2 = uriResource;
        if (uriResource2 == null) {
            Intrinsics.throwNpe();
        }
        Fetcher fetcher = (Fetcher)uriResource2.initParameter(Fetcher.class);
        NanoHTTPD.IHTTPSession iHTTPSession = session;
        if (iHTTPSession == null) {
            Intrinsics.throwNpe();
        }
        if (iHTTPSession.getParameters().containsKey("resource")) {
            Object v = session.getParameters().get("resource");
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String searchQueryPath = (String)((List)v).get(0);
            List spines = fetcher.getPublication().getResources();
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String string = searchQueryPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"searchQueryPath");
                String json = objectMapper.writeValueAsString((Object)this.getMediaOverlay(spines, string));
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)this.getStatus(), (String)this.getMimeType(), (String)json);
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"NanoHTTPD.newFixedLength\u2026e(status, mimeType, json)");
                return response;
            }
            catch (JsonProcessingException e) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)this.getStatus(), (String)this.getMimeType(), (String)ResponseStatus.INSTANCE.getFAILURE_RESPONSE());
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"NanoHTTPD.newFixedLength\u2026eStatus.FAILURE_RESPONSE)");
                return response;
            }
        }
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)this.getStatus(), (String)this.getMimeType(), (String)ResponseStatus.INSTANCE.getFAILURE_RESPONSE());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"NanoHTTPD.newFixedLength\u2026eStatus.FAILURE_RESPONSE)");
        return response;
    }

    private final MediaOverlays getMediaOverlay(List<Link> spines, String searchQueryPath) {
        for (Link link : spines) {
            String string = link.getHref();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)searchQueryPath, (boolean)false, (int)2, null)) continue;
            return link.getMediaOverlays();
        }
        return new MediaOverlays(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        TAG = MediaOverlayNode.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/readium/r2/streamer/Server/handler/MediaOverlayHandler$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "r2-streamer_release"})
    public static final class Companion {
        public final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

