/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Server;

import android.content.res.AssetManager;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.net.URL;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.Containers.Container;
import org.readium.r2.streamer.Fetcher.Fetcher;
import org.readium.r2.streamer.Server.GlobalsKt;
import org.readium.r2.streamer.Server.Ressources;
import org.readium.r2.streamer.Server.handler.CSSHandler;
import org.readium.r2.streamer.Server.handler.JSHandler;
import org.readium.r2.streamer.Server.handler.ManifestHandler;
import org.readium.r2.streamer.Server.handler.MediaOverlayHandler;
import org.readium.r2.streamer.Server.handler.ResourceHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/readium/r2/streamer/Server/AbstractServer;", "Lfi/iki/elonen/router/RouterNanoHTTPD;", "port", "", "(I)V", "CSS_HANDLE", "", "JS_HANDLE", "MANIFEST_HANDLE", "MANIFEST_ITEM_HANDLE", "MEDIA_OVERLAY_HANDLE", "containsMediaOverlay", "", "ressources", "Lorg/readium/r2/streamer/Server/Ressources;", "addEpub", "", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/Containers/Container;", "fileName", "addLinks", "filePath", "addResource", "name", "body", "loadResources", "assets", "Landroid/content/res/AssetManager;", "r2-streamer_release"})
public abstract class AbstractServer
extends RouterNanoHTTPD {
    private final String MANIFEST_HANDLE = "/manifest";
    private final String MANIFEST_ITEM_HANDLE = "/(.*)";
    private final String MEDIA_OVERLAY_HANDLE = "/media-overlay";
    private final String CSS_HANDLE = "/styles/(.*)";
    private final String JS_HANDLE = "/scripts/(.*)";
    private boolean containsMediaOverlay;
    private final Ressources ressources = new Ressources();

    public final void addResource(@NotNull String name, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        this.ressources.add(name, body);
    }

    public final void loadResources(@NotNull AssetManager assets) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
        String string = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-base.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("base.css", string);
        String string2 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-html5patch.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("html5patch.css", string2);
        String string3 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-safeguards.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("safeguards.css", string3);
        String string4 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-highlights.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("highlights.css", string4);
        String string5 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-pagination.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("pagination.css", string5);
        String string6 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-scroll.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("scroll.css", string6);
        String string7 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-night_mode.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("night_mode.css", string7);
        String string8 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-sepia_mode.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("sepia_mode.css", string8);
        String string9 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-os_a11y.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("os_a11y.css", string9);
        String string10 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-user_settings.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("user_settings.css", string10);
        String string11 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-fs_normalize.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("fs_normalize.css", string11);
        String string12 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("after.css", string12);
        String string13 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("before.css", string13);
        String string14 = new Scanner(assets.open("ReadiumCSS/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("default.css", string14);
        String string15 = new Scanner(assets.open("ReadiumCSS/touchHandling.js"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("touchHandling.js", string15);
        String string16 = new Scanner(assets.open("ReadiumCSS/utils.js"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("utils.js", string16);
    }

    public final void addEpub(@NotNull Publication publication, @NotNull Container container, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Fetcher fetcher = new Fetcher(publication, container);
        this.addLinks(publication, fileName);
        publication.addSelfLink(fileName, new URL(GlobalsKt.getURL()));
        if (this.containsMediaOverlay) {
            this.addRoute(fileName + this.MEDIA_OVERLAY_HANDLE, MediaOverlayHandler.class, new Object[]{fetcher});
        }
        this.addRoute(fileName + this.MANIFEST_HANDLE, ManifestHandler.class, new Object[]{fetcher});
        this.addRoute(fileName + this.MANIFEST_ITEM_HANDLE, ResourceHandler.class, new Object[]{fetcher});
        this.addRoute(this.JS_HANDLE, JSHandler.class, new Object[]{this.ressources});
        this.addRoute(this.CSS_HANDLE, CSSHandler.class, new Object[]{this.ressources});
    }

    private final void addLinks(Publication publication, String filePath) {
        this.containsMediaOverlay = false;
        for (Link link : publication.getOtherLinks()) {
            if (!link.getRel().contains("media-overlay")) continue;
            this.containsMediaOverlay = true;
            String string = link.getHref();
            link.setHref(string != null ? StringsKt.replace$default((String)string, (String)"port", (String)("localhost:" + this.getListeningPort() + filePath), (boolean)false, (int)4, null) : null);
        }
    }

    public AbstractServer(int port) {
        super(port);
    }
}

