/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Parser;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Drm;
import org.readium.r2.shared.Encryption;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.RootFile;
import org.readium.r2.streamer.Containers.ContainerEpub;
import org.readium.r2.streamer.Containers.ContainerEpubDirectory;
import org.readium.r2.streamer.Containers.EpubContainer;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.EncryptionParser;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.NCXParser;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.NavigationDocumentParser;
import org.readium.r2.streamer.Parser.EpubParserSubClasses.OPFParser;
import org.readium.r2.streamer.Parser.PubBox;
import org.readium.r2.streamer.Parser.PublicationParser;
import org.readium.r2.streamer.XmlParser.Node;
import org.readium.r2.streamer.XmlParser.XmlParser;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/readium/r2/streamer/Parser/EpubParser;", "Lorg/readium/r2/streamer/Parser/PublicationParser;", "()V", "encp", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/EncryptionParser;", "ncxp", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/NCXParser;", "ndp", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/NavigationDocumentParser;", "opfParser", "Lorg/readium/r2/streamer/Parser/EpubParserSubClasses/OPFParser;", "generateContainerFrom", "Lorg/readium/r2/streamer/Containers/EpubContainer;", "path", "", "parse", "Lorg/readium/r2/streamer/Parser/PubBox;", "fileAtPath", "parseEncryption", "", "container", "publication", "Lorg/readium/r2/shared/Publication;", "drm", "Lorg/readium/r2/shared/Drm;", "parseNavigationDocument", "parseNcxDocument", "scanForDrm", "r2-streamer_release"})
public final class EpubParser
implements PublicationParser {
    private final OPFParser opfParser = new OPFParser();
    private final NavigationDocumentParser ndp = new NavigationDocumentParser();
    private final NCXParser ncxp = new NCXParser();
    private final EncryptionParser encp = new EncryptionParser();

    private final EpubContainer generateContainerFrom(String path) {
        EpubContainer epubContainer;
        boolean isDirectory = new File(path).isDirectory();
        if (!new File(path).exists()) {
            throw (Throwable)new Exception("Missing File");
        }
        boolean bl = isDirectory;
        if (bl) {
            epubContainer = new ContainerEpubDirectory(path);
        } else if (!bl) {
            epubContainer = new ContainerEpub(path);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EpubContainer container = epubContainer;
        if (!container.getSuccessCreated()) {
            throw (Throwable)new Exception("Missing File");
        }
        return container;
    }

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath) {
        byte[] e2;
        EpubContainer epubContainer;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        XmlParser aexml = new XmlParser();
        try {
            epubContainer = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            Log.e((String)"Error", (String)"Could not generate container", (Throwable)e2);
            return null;
        }
        EpubContainer container = epubContainer;
        try {
            e2 = container.data("META-INF/container.xml");
        }
        catch (Exception e3) {
            Log.e((String)"Error", (String)"Missing File : META-INF/container.xml", (Throwable)e3);
            return null;
        }
        byte[] data = e2;
        aexml.parseXml(new ByteArrayInputStream(data));
        container.getRootFile().setMimetype("application/epub+zip");
        RootFile rootFile = container.getRootFile();
        Object object = aexml.getFirst("container");
        if (object == null || (object = ((Node)object).getFirst("rootfiles")) == null || (object = ((Node)object).getFirst("rootfile")) == null || (object = ((Node)object).getProperties()) == null || (object = object.get("full-path")) == null) {
            object = "content.opf";
        }
        rootFile.setRootFilePath((String)object);
        try {
            e2 = container.data(container.getRootFile().getRootFilePath());
        }
        catch (Exception e4) {
            Log.e((String)"Error", (String)("Missing File : " + container.getRootFile().getRootFilePath()), (Throwable)e4);
            return null;
        }
        data = e2;
        aexml.parseXml(new ByteArrayInputStream(data));
        String string = aexml.root().getProperties().get("version");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        double epubVersion = Double.parseDouble(string2);
        Publication publication = this.opfParser.parseOpf(aexml, container, epubVersion);
        if (publication == null) {
            return null;
        }
        Publication publication2 = publication;
        this.parseEncryption(container, publication2, this.scanForDrm(container));
        this.parseNavigationDocument(container, publication2);
        this.parseNcxDocument(container, publication2);
        return new PubBox(publication2, container);
    }

    @Nullable
    public final Drm scanForDrm(@NotNull EpubContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        try {
            container.data("META-INF/license.lcpl");
            return new Drm();
        }
        catch (Exception e) {
            return null;
        }
    }

    private final void parseEncryption(EpubContainer container, Publication publication, Drm drm) {
        byte[] byArray;
        try {
            byArray = container.data("META-INF/encryption.xml");
        }
        catch (Exception e) {
            return;
        }
        byte[] documentData = byArray;
        XmlParser document = new XmlParser();
        byte[] e = documentData;
        XmlParser xmlParser = document;
        Object object = new ByteArrayInputStream(e);
        xmlParser.parseXml((InputStream)object);
        Object object2 = document.getFirst("encryption");
        if (object2 == null || (object2 = ((Node)object2).get("EncryptedData")) == null) {
            return;
        }
        Object encryptedDataElements = object2;
        Iterator iterator = encryptedDataElements.iterator();
        while (iterator.hasNext()) {
            Object object3;
            String keyInfoUri;
            String string;
            Node it;
            Node node;
            Node encryptedDataElement = (Node)iterator.next();
            Encryption encryption = new Encryption();
            Node node2 = encryptedDataElement.getFirst("KeyInfo");
            if (node2 != null && (node2 = node2.getFirst("RetrievalMethods")) != null) {
                it = node = node2;
                string = it.getProperties().get("URI");
            } else {
                string = keyInfoUri = null;
            }
            if (Intrinsics.areEqual(keyInfoUri, (Object)"license.lcpl#/encryption/content_key")) {
                Drm drm2 = drm;
                if (Intrinsics.areEqual((Object)(drm2 != null ? drm2.getBrand() : null), (Object)Drm.Brand.lcp)) {
                    encryption.setScheme("lcp");
                }
            }
            Object object4 = encryption;
            if (encryptedDataElement.getFirst("EncryptionMethod") != null) {
                xmlParser = object4;
                it = node;
                object = it.getProperties().get("Algorithm");
                object4 = xmlParser;
                object3 = object;
            } else {
                object3 = null;
            }
            object4.setAlgorithm(object3);
            this.encp.parseEncryptionProperties(encryptedDataElement, encryption);
            this.encp.add(encryption, publication, encryptedDataElement);
        }
    }

    private final void parseNavigationDocument(EpubContainer container, Publication publication) {
        Object object;
        Link link = publication.linkWithRel("contents");
        if (link == null) {
            return;
        }
        Link navLink = link;
        try {
            object = container.xmlDocumentforResource(navLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Navigation parsing", (Throwable)e);
            return;
        }
        XmlParser navDocument = object;
        String string = navLink.getHref();
        if (string == null) {
            return;
        }
        this.ndp.setNavigationDocumentPath(string);
        object = publication.getTableOfContents();
        Iterable iterable = this.ndp.tableOfContent(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getLandmarks();
        iterable = this.ndp.landmarks(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfAudioFiles();
        iterable = this.ndp.listOfAudiofiles(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfIllustrations();
        iterable = this.ndp.listOfIllustrations(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfTables();
        iterable = this.ndp.listOfTables(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfVideos();
        iterable = this.ndp.listOfVideos(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getPageList();
        iterable = this.ndp.pageList(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
    }

    private final void parseNcxDocument(EpubContainer container, Publication publication) {
        Iterable iterable;
        Object object;
        Object v0;
        block7: {
            Iterable $receiver$iv = publication.getResources();
            for (Object element$iv : $receiver$iv) {
                Link it = (Link)element$iv;
                if (!Intrinsics.areEqual((Object)it.getTypeLink(), (Object)"application/x-dtbncx+xml")) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        Link link = v0;
        if (link == null) {
            return;
        }
        Link ncxLink = link;
        try {
            object = container.xmlDocumentforResource(ncxLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Ncx parsing", (Throwable)e);
            return;
        }
        Object ncxDocument = object;
        String string = ncxLink.getHref();
        if (string == null) {
            return;
        }
        this.ncxp.setNcxDocumentPath(string);
        if (publication.getTableOfContents().isEmpty()) {
            object = publication.getTableOfContents();
            iterable = this.ncxp.tableOfContents((XmlParser)ncxDocument);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        }
        if (publication.getPageList().isEmpty()) {
            object = publication.getPageList();
            iterable = this.ncxp.pageList((XmlParser)ncxDocument);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        }
    }
}

