/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Fetcher;

import android.util.Log;
import com.mcxiaoke.koi.HASH;
import com.mcxiaoke.koi.ext.StringKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Properties;
import org.readium.r2.shared.Publication;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/readium/r2/streamer/Fetcher/FontDecoder;", "", "()V", "Adobe", "", "getAdobe", "()I", "Idpf", "getIdpf", "decodableAlgorithms", "", "", "getDecodableAlgorithms", "()Ljava/util/Map;", "setDecodableAlgorithms", "(Ljava/util/Map;)V", "decoders", "getDecoders", "setDecoders", "decoding", "Ljava/io/InputStream;", "input", "publication", "Lorg/readium/r2/shared/Publication;", "path", "decodingFont", "Ljava/io/ByteArrayInputStream;", "pubId", "length", "deobfuscate", "", "publicationKey", "obfuscationLength", "getHashKeyAdobe", "r2-streamer_release"})
public final class FontDecoder {
    private final int Adobe = 1024;
    private final int Idpf = 1040;
    @NotNull
    private Map<String, String> decodableAlgorithms = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"fontIdpf", (Object)"http://www.idpf.org/2008/embedding"), TuplesKt.to((Object)"fontAdobe", (Object)"http://ns.adobe.com/pdf/enc#RC")});
    @NotNull
    private Map<String, Integer> decoders = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"http://www.idpf.org/2008/embedding", (Object)this.Idpf), TuplesKt.to((Object)"http://ns.adobe.com/pdf/enc#RC", (Object)this.Adobe)});

    public final int getAdobe() {
        return this.Adobe;
    }

    public final int getIdpf() {
        return this.Idpf;
    }

    @NotNull
    public final Map<String, String> getDecodableAlgorithms() {
        return this.decodableAlgorithms;
    }

    public final void setDecodableAlgorithms(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.decodableAlgorithms = map;
    }

    @NotNull
    public final Map<String, Integer> getDecoders() {
        return this.decoders;
    }

    public final void setDecoders(@NotNull Map<String, Integer> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.decoders = map;
    }

    @NotNull
    public final InputStream decoding(@NotNull InputStream input, @NotNull Publication publication, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String publicationIdentifier = publication.getMetadata().getIdentifier();
        Link link = publication.linkWithHref(path);
        if (link == null) {
            return input;
        }
        Link link2 = link;
        Properties properties = link2.getProperties();
        if (properties == null || (properties = properties.getEncryption()) == null) {
            return input;
        }
        Properties encryption = properties;
        String string = encryption.getAlgorithm();
        if (string == null) {
            return input;
        }
        String algorithm = string;
        Map<String, Integer> map = this.decoders;
        Properties properties2 = link2.getProperties();
        String string2 = properties2 != null && (properties2 = properties2.getEncryption()) != null ? properties2.getAlgorithm() : null;
        Integer n = map.get(string2);
        if (n == null) {
            return input;
        }
        int type = n;
        if (!this.decodableAlgorithms.values().contains(algorithm)) {
            Log.e((String)"Error", (String)("" + path + " is encrypted, but can't handle it"));
            return input;
        }
        return this.decodingFont(input, publicationIdentifier, type);
    }

    @NotNull
    public final ByteArrayInputStream decodingFont(@NotNull InputStream input, @NotNull String pubId, int length) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)pubId, (String)"pubId");
        int n = length;
        byte[] publicationKey = n == this.Adobe ? this.getHashKeyAdobe(pubId) : StringKt.toHexBytes((String)HASH.INSTANCE.sha1(pubId));
        return new ByteArrayInputStream(this.deobfuscate(input, publicationKey, length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] deobfuscate(@NotNull InputStream input, @NotNull byte[] publicationKey, int obfuscationLength) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publicationKey, (String)"publicationKey");
        byte[] buffer = ByteStreamsKt.readBytes$default((InputStream)input, (int)0, (int)1, null);
        int count = buffer.length > obfuscationLength ? obfuscationLength : buffer.length;
        int n = 0;
        int n2 = count - 1;
        if (n <= n2) {
            while (true) {
                byte by;
                void i;
                byte by2 = buffer[i];
                byte by3 = publicationKey[i % publicationKey.length];
                void var11_11 = i;
                byte[] byArray = buffer;
                byArray[var11_11] = by = (byte)(by2 ^ by3);
                if (i == n2) break;
                ++i;
            }
        }
        return buffer;
    }

    @NotNull
    public final byte[] getHashKeyAdobe(@NotNull String pubId) {
        Intrinsics.checkParameterIsNotNull((Object)pubId, (String)"pubId");
        return StringKt.toHexBytes((String)StringsKt.replace$default((String)StringsKt.replace$default((String)pubId, (String)"urn:uuid:", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"", (boolean)false, (int)4, null));
    }
}

