/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Fetcher;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.Containers.Container;
import org.readium.r2.streamer.Fetcher.ContentFilters;
import org.readium.r2.streamer.Fetcher.ContentFiltersCbz;
import org.readium.r2.streamer.Fetcher.ContentFiltersEpub;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0016J\u0010\u0010\r\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lorg/readium/r2/streamer/Fetcher/Fetcher;", "", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/Containers/Container;", "(Lorg/readium/r2/shared/Publication;Lorg/readium/r2/streamer/Containers/Container;)V", "getContainer", "()Lorg/readium/r2/streamer/Containers/Container;", "setContainer", "(Lorg/readium/r2/streamer/Containers/Container;)V", "contentFilters", "Lorg/readium/r2/streamer/Fetcher/ContentFilters;", "getContentFilters", "()Lorg/readium/r2/streamer/Fetcher/ContentFilters;", "setContentFilters", "(Lorg/readium/r2/streamer/Fetcher/ContentFilters;)V", "getPublication", "()Lorg/readium/r2/shared/Publication;", "setPublication", "(Lorg/readium/r2/shared/Publication;)V", "rootFileDirectory", "", "getRootFileDirectory", "()Ljava/lang/String;", "setRootFileDirectory", "(Ljava/lang/String;)V", "data", "", "path", "dataLength", "", "dataStream", "Ljava/io/InputStream;", "mimeType", "r2-streamer_release"})
public final class Fetcher {
    @NotNull
    private Publication publication;
    @NotNull
    private Container container;
    @NotNull
    private String rootFileDirectory;
    @Nullable
    private ContentFilters contentFilters;

    @NotNull
    public final Publication getPublication() {
        return this.publication;
    }

    public final void setPublication(@NotNull Publication publication) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"<set-?>");
        this.publication = publication;
    }

    @NotNull
    public final Container getContainer() {
        return this.container;
    }

    public final void setContainer(@NotNull Container container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"<set-?>");
        this.container = container;
    }

    @NotNull
    public final String getRootFileDirectory() {
        return this.rootFileDirectory;
    }

    public final void setRootFileDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.rootFileDirectory = string;
    }

    @Nullable
    public final ContentFilters getContentFilters() {
        return this.contentFilters;
    }

    public final void setContentFilters(@Nullable ContentFilters contentFilters) {
        this.contentFilters = contentFilters;
    }

    @Nullable
    public final byte[] data(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.publication.resource(path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        byte[] data = this.container.data(path);
        if (data != null) {
            ContentFilters contentFilters = this.contentFilters;
            data = contentFilters != null ? contentFilters.apply(data, this.publication, path) : null;
        }
        return data;
    }

    @NotNull
    public final InputStream dataStream(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.publication.resource("/" + path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        Object inputStream = this.container.dataInputStream(path);
        Object object = this.contentFilters;
        if (object == null || (object = object.apply((InputStream)inputStream, this.publication, path)) == null) {
            object = inputStream;
        }
        inputStream = object;
        return inputStream;
    }

    public final long dataLength(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String relativePath = this.rootFileDirectory + path;
        if (this.publication.resource(path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        return this.container.dataLength(relativePath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ContentFilters getContentFilters(@Nullable String mimeType) {
        String string;
        String string2 = string = mimeType;
        if (string2 == null) throw (Throwable)new Exception("Missing container or MIMEtype");
        switch (string2.hashCode()) {
            case -2008589971: {
                if (!string.equals("application/epub+zip")) throw (Throwable)new Exception("Missing container or MIMEtype");
                return new ContentFiltersEpub();
            }
            case -1879081515: {
                if (!string.equals("application/oebps-package+xml")) throw (Throwable)new Exception("Missing container or MIMEtype");
                return new ContentFiltersEpub();
            }
            case -1348237409: {
                if (!string.equals("application/x-cbr")) throw (Throwable)new Exception("Missing container or MIMEtype");
                return new ContentFiltersCbz();
            }
        }
        throw (Throwable)new Exception("Missing container or MIMEtype");
    }

    public Fetcher(@NotNull Publication publication, @NotNull Container container) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.rootFileDirectory = "";
        this.container = container;
        this.publication = publication;
        String string = (String)publication.getInternalData().get("rootfile");
        if (string == null) {
            throw (Throwable)new Exception("Missing root file");
        }
        String rootFilePath = string;
        CharSequence charSequence = rootFilePath;
        if (charSequence.length() > 0 && StringsKt.contains$default((CharSequence)rootFilePath, (char)'/', (boolean)false, (int)2, null)) {
            this.rootFileDirectory = StringsKt.replaceAfterLast((String)rootFilePath, (String)"/", (String)"", (String)rootFilePath);
            this.rootFileDirectory = StringsKt.dropLast((String)this.rootFileDirectory, (int)1);
        } else {
            this.rootFileDirectory = "";
        }
        this.contentFilters = this.getContentFilters(container.getRootFile().getMimetype());
    }
}

