/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Fetcher;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Properties;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.shared.RenditionLayout;
import org.readium.r2.streamer.Fetcher.ContentFilters;
import org.readium.r2.streamer.Fetcher.FontDecoder;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/readium/r2/streamer/Fetcher/ContentFiltersEpub;", "Lorg/readium/r2/streamer/Fetcher/ContentFilters;", "()V", "fontDecoder", "Lorg/readium/r2/streamer/Fetcher/FontDecoder;", "getFontDecoder", "()Lorg/readium/r2/streamer/Fetcher/FontDecoder;", "setFontDecoder", "(Lorg/readium/r2/streamer/Fetcher/FontDecoder;)V", "apply", "Ljava/io/InputStream;", "input", "publication", "Lorg/readium/r2/shared/Publication;", "path", "", "", "getHtmlLink", "ressourceName", "getHtmlScript", "injectFixedLayohtHtml", "stream", "baseUrl", "Ljava/net/URL;", "injectReflowableHtml", "r2-streamer_release"})
public final class ContentFiltersEpub
implements ContentFilters {
    @NotNull
    private FontDecoder fontDecoder = new FontDecoder();

    @Override
    @NotNull
    public FontDecoder getFontDecoder() {
        return this.fontDecoder;
    }

    @Override
    public void setFontDecoder(@NotNull FontDecoder fontDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)fontDecoder, (String)"<set-?>");
        this.fontDecoder = fontDecoder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public InputStream apply(@NotNull InputStream input, @NotNull Publication publication, @NotNull String path) {
        URL baseUrl;
        InputStream decodedInputStream;
        block6: {
            block5: {
                Link link;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
                    Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                    decodedInputStream = this.getFontDecoder().decoding(input, publication, path);
                    link = publication.linkWithHref(path);
                    URL uRL = publication.baseUrl();
                    baseUrl = uRL != null ? PublicationKt.removeLastComponent((URL)uRL) : null;
                    Link link2 = link;
                    if (!Intrinsics.areEqual((Object)(link2 != null ? link2.getTypeLink() : null), (Object)"application/xhtml+xml")) {
                        Link link3 = link;
                        if (!Intrinsics.areEqual((Object)(link3 != null ? link3.getTypeLink() : null), (Object)"text/html")) return decodedInputStream;
                    }
                    if (baseUrl == null) return decodedInputStream;
                    if (!Intrinsics.areEqual((Object)publication.getMetadata().getRendition().getLayout(), (Object)RenditionLayout.reflowable)) break block4;
                    Properties properties = link.getProperties();
                    if ((properties != null ? properties.getLayout() : null) == null) break block5;
                }
                Properties properties = link.getProperties();
                if (!Intrinsics.areEqual((Object)(properties != null ? properties.getLayout() : null), (Object)"reflowable")) break block6;
            }
            InputStream inputStream = this.injectReflowableHtml(decodedInputStream, baseUrl);
            if (inputStream != null) return (ByteArrayInputStream)inputStream;
            throw new TypeCastException("null cannot be cast to non-null type java.io.ByteArrayInputStream");
        }
        InputStream inputStream = this.injectFixedLayohtHtml(decodedInputStream, baseUrl);
        if (inputStream != null) return (ByteArrayInputStream)inputStream;
        throw new TypeCastException("null cannot be cast to non-null type java.io.ByteArrayInputStream");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public byte[] apply(@NotNull byte[] input, @NotNull Publication publication, @NotNull String path) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                inputStream = new ByteArrayInputStream(input);
                decodedInputStream = this.getFontDecoder().decoding(inputStream, publication, path);
                link = publication.linkWithHref(path);
                v0 = publication.baseUrl();
                baseUrl = v0 != null ? PublicationKt.removeLastComponent((URL)v0) : null;
                v1 = link;
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getTypeLink() : null), (Object)"application/xhtml+xml")) break block4;
                v2 = link;
                if (!Intrinsics.areEqual((Object)(v2 != null ? v2.getTypeLink() : null), (Object)"text/html")) break block5;
            }
            if (baseUrl == null) break block5;
            if (!Intrinsics.areEqual((Object)publication.getMetadata().getRendition().getLayout(), (Object)RenditionLayout.reflowable)) ** GOTO lbl-1000
            v3 = link.getProperties();
            if ((v3 != null ? v3.getLayout() : null) == null) ** GOTO lbl-1000
            v4 = link.getProperties();
            if (Intrinsics.areEqual((Object)(v4 != null ? v4.getLayout() : null), (Object)"reflowable")) lbl-1000:
            // 2 sources

            {
                v5 = this.injectReflowableHtml(decodedInputStream, baseUrl);
                if (v5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.ByteArrayInputStream");
                }
                v6 = (ByteArrayInputStream)v5;
            } else lbl-1000:
            // 2 sources

            {
                v7 = this.injectFixedLayohtHtml(decodedInputStream, baseUrl);
                if (v7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.ByteArrayInputStream");
                }
                v6 = (ByteArrayInputStream)v7;
            }
            decodedInputStream = v6;
        }
        return ByteStreamsKt.readBytes$default((InputStream)decodedInputStream, (int)0, (int)1, null);
    }

    private final InputStream injectReflowableHtml(InputStream stream, URL baseUrl) {
        ByteArrayInputStream byteArrayInputStream;
        byte[] data = ByteStreamsKt.readBytes$default((InputStream)stream, (int)0, (int)1, null);
        String resourceHtml = new String(data, Charsets.UTF_8);
        int beginHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<head>", (int)0, (boolean)false) + 6;
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        List endIncludes = new ArrayList();
        List beginIncludes = new ArrayList();
        beginIncludes.add("<meta name=\"viewport\" content=\"width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=0;\"/>");
        beginIncludes.add(this.getHtmlLink("/styles/before.css"));
        beginIncludes.add(this.getHtmlLink("/styles/default.css"));
        endIncludes.add(this.getHtmlLink("/styles/after.css"));
        endIncludes.add(this.getHtmlScript("/scripts/touchHandling.js"));
        endIncludes.add(this.getHtmlScript("/scripts/utils.js"));
        for (String element : beginIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(beginHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            beginHeadIndex += element.length();
            endHeadIndex += element.length();
        }
        for (String element : endIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            endHeadIndex += element.length();
        }
        String string = new StringBuilder(resourceHtml).insert(endHeadIndex, "<style>@import url('https://fonts.googleapis.com/css?family=PT+Serif|Roboto|Source+Sans+Pro|Vollkorn');</style> ").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(resourceHt\u2026');</style> \").toString()");
        String string2 = resourceHtml = string;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        Charset charset = Charsets.UTF_8;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayInputStream2(byArray2);
        return byteArrayInputStream3;
    }

    private final InputStream injectFixedLayohtHtml(InputStream stream, URL baseUrl) {
        ByteArrayInputStream byteArrayInputStream;
        byte[] data = ByteStreamsKt.readBytes$default((InputStream)stream, (int)0, (int)1, null);
        String resourceHtml = new String(data, Charsets.UTF_8);
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        List includes = new ArrayList();
        String url = baseUrl.toString();
        includes.add("<meta name=\"viewport\" content=\"width=1024; height=768; left=50%; top=50%; bottom=auto; right=auto; transform=translate(-50%, -50%);\"/>\n");
        includes.add(this.getHtmlScript(url + "scripts/touchHandling.js"));
        includes.add(this.getHtmlScript(url + "scripts/utils.js"));
        for (String element : includes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
        }
        String string = resourceHtml;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayInputStream2(byArray2);
        return byteArrayInputStream3;
    }

    @NotNull
    public final String getHtmlLink(@NotNull String ressourceName) {
        Intrinsics.checkParameterIsNotNull((Object)ressourceName, (String)"ressourceName");
        String prefix = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
        String suffix = "\"/>\n";
        return prefix + ressourceName + suffix;
    }

    @NotNull
    public final String getHtmlScript(@NotNull String ressourceName) {
        Intrinsics.checkParameterIsNotNull((Object)ressourceName, (String)"ressourceName");
        String prefix = "<script type=\"text/javascript\" src=\"";
        String suffix = "\"></script>\n";
        return prefix + ressourceName + suffix;
    }
}

