/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.Containers;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.streamer.Containers.Container;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/readium/r2/streamer/Containers/ZipArchiveContainer;", "Lorg/readium/r2/streamer/Containers/Container;", "zipFile", "Ljava/util/zip/ZipFile;", "getZipFile", "()Ljava/util/zip/ZipFile;", "setZipFile", "(Ljava/util/zip/ZipFile;)V", "data", "", "relativePath", "", "dataInputStream", "Ljava/io/InputStream;", "kotlin.jvm.PlatformType", "dataLength", "", "r2-streamer_release"})
public interface ZipArchiveContainer
extends Container {
    @NotNull
    public ZipFile getZipFile();

    public void setZipFile(@NotNull ZipFile var1);

    @Override
    @NotNull
    public byte[] data(@NotNull String var1);

    @Override
    public long dataLength(@NotNull String var1);

    @Override
    public InputStream dataInputStream(@NotNull String var1);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static byte[] data(@NotNull ZipArchiveContainer $this, String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            ZipEntry zipEntry = $this.getZipFile().getEntry(relativePath);
            InputStream fis = $this.getZipFile().getInputStream(zipEntry);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            int nRead = fis.read(data, 0, data.length);
            while (nRead != -1) {
                buffer.write(data, 0, nRead);
                nRead = fis.read(data, 0, data.length);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"buffer.toByteArray()");
            return byArray;
        }

        public static long dataLength(@NotNull ZipArchiveContainer $this, String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return $this.getZipFile().size();
        }

        public static InputStream dataInputStream(@NotNull ZipArchiveContainer $this, String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return $this.getZipFile().getInputStream($this.getZipFile().getEntry(relativePath));
        }
    }
}

