/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.http;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.util.mediatype.MediaType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u001b\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003JC\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u0003J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010&\u001a\u00020\u0003R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lorg/readium/r2/shared/util/http/HttpResponse;", "", "url", "", "statusCode", "", "headers", "", "", "mediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "(Ljava/lang/String;ILjava/util/Map;Lorg/readium/r2/shared/util/mediatype/MediaType;)V", "acceptsByteRanges", "", "getAcceptsByteRanges", "()Z", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getHeaders", "()Ljava/util/Map;", "getMediaType", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "getStatusCode", "()I", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "valueForHeader", "name", "valuesForHeader", "r2-shared_release"})
public final class HttpResponse {
    @NotNull
    private final String url;
    private final int statusCode;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final MediaType mediaType;

    @Nullable
    public final String valueForHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)CollectionsKt.firstOrNull(this.valuesForHeader(name));
    }

    @NotNull
    public final List<String> valuesForHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        Object object = string2;
        boolean bl2 = false;
        String string3 = ((String)object).toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String name2 = string3;
        Map<String, List<String>> $this$filterKeys$iv = this.headers;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        object = $this$filterKeys$iv;
        bl2 = false;
        for (Map.Entry entry$iv : object.entrySet()) {
            Locale locale3;
            String it = (String)entry$iv.getKey();
            boolean bl3 = false;
            String string4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)Locale.ROOT, (String)"Locale.ROOT");
            boolean bl4 = false;
            String string5 = string4;
            boolean bl5 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale3);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
            if (!Intrinsics.areEqual((Object)string7, (Object)name2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.flatten((Iterable)((Map)result$iv).values());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getAcceptsByteRanges() {
        String string2;
        boolean bl;
        String string3;
        boolean bl2;
        Locale locale;
        String string4;
        String string5 = this.valueForHeader("Accept-Ranges");
        if (string5 != null) {
            string4 = string5;
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.ROOT");
            locale = locale2;
            bl2 = false;
            string3 = string4;
            bl = false;
            String string6 = string3;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale);
            string2 = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
        } else {
            string2 = null;
        }
        if (Intrinsics.areEqual(string2, (Object)"bytes")) return true;
        String string8 = this.valueForHeader("Content-Range");
        String string9 = string8;
        if (string8 == null) return false;
        string4 = string9;
        Locale locale3 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.ROOT");
        locale = locale3;
        bl2 = false;
        string3 = string4;
        bl = false;
        String string10 = string3;
        if (string10 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string11 = string10.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).toLowerCase(locale)");
        string9 = string11;
        if (string11 == null) return false;
        if (!StringsKt.startsWith$default((String)string9, (String)"bytes", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final Long getContentLength() {
        Object object;
        Object object2 = this.valueForHeader("Content-Length");
        if (object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null) {
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)object3).longValue();
            boolean bl3 = false;
            object = it >= 0L ? object3 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final MediaType getMediaType() {
        return this.mediaType;
    }

    public HttpResponse(@NotNull String url, int statusCode, @NotNull Map<String, ? extends List<String>> headers, @NotNull MediaType mediaType2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        this.url = url;
        this.statusCode = statusCode;
        this.headers = headers;
        this.mediaType = mediaType2;
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    public final int component2() {
        return this.statusCode;
    }

    @NotNull
    public final Map<String, List<String>> component3() {
        return this.headers;
    }

    @NotNull
    public final MediaType component4() {
        return this.mediaType;
    }

    @NotNull
    public final HttpResponse copy(@NotNull String url, int statusCode, @NotNull Map<String, ? extends List<String>> headers, @NotNull MediaType mediaType2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        return new HttpResponse(url, statusCode, headers, mediaType2);
    }

    public static /* synthetic */ HttpResponse copy$default(HttpResponse httpResponse, String string2, int n, Map map, MediaType mediaType2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = httpResponse.url;
        }
        if ((n2 & 2) != 0) {
            n = httpResponse.statusCode;
        }
        if ((n2 & 4) != 0) {
            map = httpResponse.headers;
        }
        if ((n2 & 8) != 0) {
            mediaType2 = httpResponse.mediaType;
        }
        return httpResponse.copy(string2, n, map, mediaType2);
    }

    @NotNull
    public String toString() {
        return "HttpResponse(url=" + this.url + ", statusCode=" + this.statusCode + ", headers=" + this.headers + ", mediaType=" + this.mediaType + ")";
    }

    public int hashCode() {
        String string2 = this.url;
        Map<String, List<String>> map = this.headers;
        MediaType mediaType2 = this.mediaType;
        return (((string2 != null ? string2.hashCode() : 0) * 31 + this.statusCode) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (mediaType2 != null ? ((Object)mediaType2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HttpResponse)) break block3;
                HttpResponse httpResponse = (HttpResponse)object;
                if (!Intrinsics.areEqual((Object)this.url, (Object)httpResponse.url) || this.statusCode != httpResponse.statusCode || !Intrinsics.areEqual(this.headers, httpResponse.headers) || !Intrinsics.areEqual((Object)this.mediaType, (Object)httpResponse.mediaType)) break block3;
            }
            return true;
        }
        return false;
    }
}

