/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.format;

import android.content.ContentResolver;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.extensions.ContentResolverKt;
import org.readium.r2.shared.format.Format;
import org.readium.r2.shared.format.FormatSnifferBytesContent;
import org.readium.r2.shared.format.FormatSnifferContent;
import org.readium.r2.shared.format.FormatSnifferContext;
import org.readium.r2.shared.format.FormatSnifferFileContent;
import org.readium.r2.shared.format.FormatSnifferUriContent;
import org.readium.r2.shared.format.FormatSniffers;
import org.readium.r2.shared.format.MediaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lorg/readium/r2/shared/format/Format;", "", "name", "", "mediaType", "Lorg/readium/r2/shared/format/MediaType;", "fileExtension", "(Ljava/lang/String;Lorg/readium/r2/shared/format/MediaType;Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "getMediaType", "()Lorg/readium/r2/shared/format/MediaType;", "getName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "r2-shared_release"})
public final class Format {
    @NotNull
    private final String name;
    @NotNull
    private final MediaType mediaType;
    @NotNull
    private final String fileExtension;
    @NotNull
    private static final Format BMP;
    @NotNull
    private static final Format CBZ;
    @NotNull
    private static final Format DIVINA;
    @NotNull
    private static final Format DIVINA_MANIFEST;
    @NotNull
    private static final Format EPUB;
    @NotNull
    private static final Format GIF;
    @NotNull
    private static final Format HTML;
    @NotNull
    private static final Format JPEG;
    @NotNull
    private static final Format OPDS1_FEED;
    @NotNull
    private static final Format OPDS1_ENTRY;
    @NotNull
    private static final Format OPDS2_FEED;
    @NotNull
    private static final Format OPDS2_PUBLICATION;
    @NotNull
    private static final Format OPDS_AUTHENTICATION;
    @NotNull
    private static final Format LCP_PROTECTED_AUDIOBOOK;
    @NotNull
    private static final Format LCP_PROTECTED_PDF;
    @NotNull
    private static final Format LCP_LICENSE;
    @NotNull
    private static final Format LPF;
    @NotNull
    private static final Format PDF;
    @NotNull
    private static final Format PNG;
    @NotNull
    private static final Format READIUM_AUDIOBOOK;
    @NotNull
    private static final Format READIUM_AUDIOBOOK_MANIFEST;
    @NotNull
    private static final Format READIUM_WEBPUB;
    @NotNull
    private static final Format READIUM_WEBPUB_MANIFEST;
    @NotNull
    private static final Format TIFF;
    @NotNull
    private static final Format W3C_WPUB_MANIFEST;
    @NotNull
    private static final Format WEBP;
    @NotNull
    private static final Format ZAB;
    @NotNull
    private static final List<Function2<FormatSnifferContext, Continuation<? super Format>, Object>> sniffers;
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        Object object;
        String string2 = this.mediaType.toString();
        Object object2 = other;
        if (!(object2 instanceof Format)) {
            object2 = null;
        }
        return Intrinsics.areEqual((Object)string2, (object = (Format)object2) != null && (object = ((Format)object).mediaType) != null ? ((MediaType)object).toString() : null);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final MediaType getMediaType() {
        return this.mediaType;
    }

    @NotNull
    public final String getFileExtension() {
        return this.fileExtension;
    }

    public Format(@NotNull String name, @NotNull MediaType mediaType, @NotNull String fileExtension) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        Intrinsics.checkParameterIsNotNull((Object)fileExtension, (String)"fileExtension");
        this.name = name;
        this.mediaType = mediaType;
        this.fileExtension = fileExtension;
    }

    static {
        Companion = new Companion(null);
        BMP = new Format("BMP", MediaType.Companion.getBMP(), "bmp");
        CBZ = new Format("Comic Book Archive", MediaType.Companion.getCBZ(), "cbz");
        DIVINA = new Format("Digital Visual Narratives", MediaType.Companion.getDIVINA(), "divina");
        DIVINA_MANIFEST = new Format("Digital Visual Narratives", MediaType.Companion.getDIVINA_MANIFEST(), "json");
        EPUB = new Format("EPUB", MediaType.Companion.getEPUB(), "epub");
        GIF = new Format("GIF", MediaType.Companion.getGIF(), "gif");
        HTML = new Format("HTML", MediaType.Companion.getHTML(), "html");
        JPEG = new Format("JPEG", MediaType.Companion.getJPEG(), "jpg");
        OPDS1_FEED = new Format("OPDS", MediaType.Companion.getOPDS1(), "atom");
        OPDS1_ENTRY = new Format("OPDS", MediaType.Companion.getOPDS1_ENTRY(), "atom");
        OPDS2_FEED = new Format("OPDS", MediaType.Companion.getOPDS2(), "json");
        OPDS2_PUBLICATION = new Format("OPDS", MediaType.Companion.getOPDS2_PUBLICATION(), "json");
        OPDS_AUTHENTICATION = new Format("OPDS Authentication Document", MediaType.Companion.getOPDS_AUTHENTICATION(), "json");
        LCP_PROTECTED_AUDIOBOOK = new Format("LCP Protected Audiobook", MediaType.Companion.getLCP_PROTECTED_AUDIOBOOK(), "lcpa");
        LCP_PROTECTED_PDF = new Format("LCP Protected PDF", MediaType.Companion.getLCP_PROTECTED_PDF(), "lcpdf");
        LCP_LICENSE = new Format("LCP License", MediaType.Companion.getLCP_LICENSE_DOCUMENT(), "lcpl");
        LPF = new Format("Lightweight Packaging Format", MediaType.Companion.getLPF(), "lpf");
        PDF = new Format("PDF", MediaType.Companion.getPDF(), "pdf");
        PNG = new Format("PNG", MediaType.Companion.getPNG(), "png");
        READIUM_AUDIOBOOK = new Format("Readium Audiobook", MediaType.Companion.getREADIUM_AUDIOBOOK(), "audiobook");
        READIUM_AUDIOBOOK_MANIFEST = new Format("Readium Audiobook", MediaType.Companion.getREADIUM_AUDIOBOOK_MANIFEST(), "json");
        READIUM_WEBPUB = new Format("Readium Web Publication", MediaType.Companion.getREADIUM_WEBPUB(), "webpub");
        READIUM_WEBPUB_MANIFEST = new Format("Readium Web Publication", MediaType.Companion.getREADIUM_WEBPUB_MANIFEST(), "json");
        TIFF = new Format("TIFF", MediaType.Companion.getTIFF(), "tiff");
        W3C_WPUB_MANIFEST = new Format("W3C Web Publication", MediaType.Companion.getW3C_WPUB_MANIFEST(), "json");
        WEBP = new Format("WebP", MediaType.Companion.getWEBP(), "webp");
        ZAB = new Format("Zipped Audio Book", MediaType.Companion.getZAB(), "zab");
        sniffers = CollectionsKt.toMutableList((Collection)FormatSniffers.INSTANCE.getAll());
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final MediaType component2() {
        return this.mediaType;
    }

    @NotNull
    public final String component3() {
        return this.fileExtension;
    }

    @NotNull
    public final Format copy(@NotNull String name, @NotNull MediaType mediaType, @NotNull String fileExtension) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        Intrinsics.checkParameterIsNotNull((Object)fileExtension, (String)"fileExtension");
        return new Format(name, mediaType, fileExtension);
    }

    public static /* synthetic */ Format copy$default(Format format2, String string2, MediaType mediaType, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = format2.name;
        }
        if ((n & 2) != 0) {
            mediaType = format2.mediaType;
        }
        if ((n & 4) != 0) {
            string3 = format2.fileExtension;
        }
        return format2.copy(string2, mediaType, string3);
    }

    @NotNull
    public String toString() {
        return "Format(name=" + this.name + ", mediaType=" + this.mediaType + ", fileExtension=" + this.fileExtension + ")";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\bC\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jp\u0010Q\u001a\u0004\u0018\u00010\u00042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0007\u00f8\u0001\u0000Jt\u0010Q\u001a\u0004\u0018\u00010\u00042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0007\u00f8\u0001\u0000Jr\u0010Q\u001a\u0004\u0018\u00010\u00042\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0007\u00f8\u0001\u0000Jv\u0010Q\u001a\u0004\u0018\u00010\u00042\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0007\u00f8\u0001\u0000Jj\u0010Q\u001a\u0004\u0018\u00010\u00042\u0006\u0010_\u001a\u00020`2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0007\u00f8\u0001\u0000Jn\u0010Q\u001a\u0004\u0018\u00010\u00042\u0006\u0010_\u001a\u00020`2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0007\u00f8\u0001\u0000J`\u0010Q\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0X\u00f8\u0001\u0000Jd\u0010Q\u001a\u0004\u0018\u00010\u00042\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0X\u00f8\u0001\u0000Jt\u0010Q\u001a\u0004\u0018\u00010\u00042\b\u0010a\u001a\u0004\u0018\u00010b2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X29\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010cJv\u0010d\u001a\u0004\u0018\u00010\u00042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010eJz\u0010d\u001a\u0004\u0018\u00010\u00042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010fJp\u0010g\u001a\u0004\u0018\u00010\u00042\u0006\u0010_\u001a\u00020`2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010hJt\u0010g\u001a\u0004\u0018\u00010\u00042\u0006\u0010_\u001a\u00020`2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJp\u0010g\u001a\u0004\u0018\u00010\u00042\u0006\u0010j\u001a\u00020V2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010kJt\u0010g\u001a\u0004\u0018\u00010\u00042\u0006\u0010j\u001a\u00020V2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJx\u0010m\u001a\u0004\u0018\u00010\u00042\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010nJ|\u0010m\u001a\u0004\u0018\u00010\u00042\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0X2;\b\u0002\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0XH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010oR\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0007R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0007R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0007R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0007R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0007R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0007R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0007R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0007R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0007R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0007R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0007R\u0011\u00103\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0007R\u0011\u00105\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0007R\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0007R\u0011\u00109\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0007R\u0011\u0010;\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0007R\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0007R\u001a\u0010?\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b@\u0010\u0002\u001a\u0004\bA\u0010\u0007R\u001a\u0010B\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bC\u0010\u0002\u001a\u0004\bD\u0010\u0007R\u0011\u0010E\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0007RG\u0010G\u001a5\u00121\u0012/\b\u0001\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040N\u0012\u0006\u0012\u0004\u0018\u00010\u00010I0H\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010P\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006p"}, d2={"Lorg/readium/r2/shared/format/Format$Companion;", "", "()V", "AUDIOBOOK", "Lorg/readium/r2/shared/format/Format;", "AUDIOBOOK$annotations", "getAUDIOBOOK", "()Lorg/readium/r2/shared/format/Format;", "AUDIOBOOK_MANIFEST", "AUDIOBOOK_MANIFEST$annotations", "getAUDIOBOOK_MANIFEST", "BMP", "getBMP", "CBZ", "getCBZ", "DIVINA", "getDIVINA", "DIVINA_MANIFEST", "getDIVINA_MANIFEST", "EPUB", "getEPUB", "GIF", "getGIF", "HTML", "getHTML", "JPEG", "getJPEG", "LCP_LICENSE", "getLCP_LICENSE", "LCP_PROTECTED_AUDIOBOOK", "getLCP_PROTECTED_AUDIOBOOK", "LCP_PROTECTED_PDF", "getLCP_PROTECTED_PDF", "LPF", "getLPF", "OPDS1_ENTRY", "getOPDS1_ENTRY", "OPDS1_FEED", "getOPDS1_FEED", "OPDS2_FEED", "getOPDS2_FEED", "OPDS2_PUBLICATION", "getOPDS2_PUBLICATION", "OPDS_AUTHENTICATION", "getOPDS_AUTHENTICATION", "PDF", "getPDF", "PNG", "getPNG", "READIUM_AUDIOBOOK", "getREADIUM_AUDIOBOOK", "READIUM_AUDIOBOOK_MANIFEST", "getREADIUM_AUDIOBOOK_MANIFEST", "READIUM_WEBPUB", "getREADIUM_WEBPUB", "READIUM_WEBPUB_MANIFEST", "getREADIUM_WEBPUB_MANIFEST", "TIFF", "getTIFF", "W3C_WPUB_MANIFEST", "getW3C_WPUB_MANIFEST", "WEBP", "getWEBP", "WEBPUB", "WEBPUB$annotations", "getWEBPUB", "WEBPUB_MANIFEST", "WEBPUB_MANIFEST$annotations", "getWEBPUB_MANIFEST", "ZAB", "getZAB", "sniffers", "", "Lkotlin/Function2;", "Lorg/readium/r2/shared/format/FormatSnifferContext;", "Lkotlin/ParameterName;", "name", "context", "Lkotlin/coroutines/Continuation;", "getSniffers", "()Ljava/util/List;", "of", "bytes", "Lkotlin/Function0;", "", "mediaType", "", "fileExtension", "", "mediaTypes", "fileExtensions", "uri", "Landroid/net/Uri;", "contentResolver", "Landroid/content/ContentResolver;", "file", "Ljava/io/File;", "content", "Lorg/readium/r2/shared/format/FormatSnifferContent;", "(Lorg/readium/r2/shared/format/FormatSnifferContent;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofBytes", "(Lkotlin/jvm/functions/Function0;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function0;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofFile", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofUri", "(Landroid/net/Uri;Landroid/content/ContentResolver;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Landroid/net/Uri;Landroid/content/ContentResolver;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "r2-shared_release"})
    public static final class Companion {
        @NotNull
        public final Format getBMP() {
            return BMP;
        }

        @NotNull
        public final Format getCBZ() {
            return CBZ;
        }

        @NotNull
        public final Format getDIVINA() {
            return DIVINA;
        }

        @NotNull
        public final Format getDIVINA_MANIFEST() {
            return DIVINA_MANIFEST;
        }

        @NotNull
        public final Format getEPUB() {
            return EPUB;
        }

        @NotNull
        public final Format getGIF() {
            return GIF;
        }

        @NotNull
        public final Format getHTML() {
            return HTML;
        }

        @NotNull
        public final Format getJPEG() {
            return JPEG;
        }

        @NotNull
        public final Format getOPDS1_FEED() {
            return OPDS1_FEED;
        }

        @NotNull
        public final Format getOPDS1_ENTRY() {
            return OPDS1_ENTRY;
        }

        @NotNull
        public final Format getOPDS2_FEED() {
            return OPDS2_FEED;
        }

        @NotNull
        public final Format getOPDS2_PUBLICATION() {
            return OPDS2_PUBLICATION;
        }

        @NotNull
        public final Format getOPDS_AUTHENTICATION() {
            return OPDS_AUTHENTICATION;
        }

        @NotNull
        public final Format getLCP_PROTECTED_AUDIOBOOK() {
            return LCP_PROTECTED_AUDIOBOOK;
        }

        @NotNull
        public final Format getLCP_PROTECTED_PDF() {
            return LCP_PROTECTED_PDF;
        }

        @NotNull
        public final Format getLCP_LICENSE() {
            return LCP_LICENSE;
        }

        @NotNull
        public final Format getLPF() {
            return LPF;
        }

        @NotNull
        public final Format getPDF() {
            return PDF;
        }

        @NotNull
        public final Format getPNG() {
            return PNG;
        }

        @NotNull
        public final Format getREADIUM_AUDIOBOOK() {
            return READIUM_AUDIOBOOK;
        }

        @NotNull
        public final Format getREADIUM_AUDIOBOOK_MANIFEST() {
            return READIUM_AUDIOBOOK_MANIFEST;
        }

        @NotNull
        public final Format getREADIUM_WEBPUB() {
            return READIUM_WEBPUB;
        }

        @NotNull
        public final Format getREADIUM_WEBPUB_MANIFEST() {
            return READIUM_WEBPUB_MANIFEST;
        }

        @NotNull
        public final Format getTIFF() {
            return TIFF;
        }

        @NotNull
        public final Format getW3C_WPUB_MANIFEST() {
            return W3C_WPUB_MANIFEST;
        }

        @NotNull
        public final Format getWEBP() {
            return WEBP;
        }

        @NotNull
        public final Format getZAB() {
            return ZAB;
        }

        @NotNull
        public final List<Function2<FormatSnifferContext, Continuation<? super Format>, Object>> getSniffers() {
            return sniffers;
        }

        @Nullable
        public final Format of(@Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(mediaType, fileExtension, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ String $mediaType;
                final /* synthetic */ String $fileExtension;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.of(null, CollectionsKt.listOfNotNull((Object)this.$mediaType), (List<String>)CollectionsKt.listOfNotNull((Object)this.$fileExtension), this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$mediaType = string2;
                    this.$fileExtension = string3;
                    this.$sniffers = list;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, String string2, String string3, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of(string2, string3, list);
        }

        @Nullable
        public final Format of(@NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkParameterIsNotNull(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(mediaTypes, fileExtensions, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ List $mediaTypes;
                final /* synthetic */ List $fileExtensions;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.of(null, this.$mediaTypes, (List<String>)this.$fileExtensions, this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$mediaTypes = list;
                    this.$fileExtensions = list2;
                    this.$sniffers = list3;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, List list, List list2, List list3, int n, Object object) {
            if ((n & 4) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of(list, list2, list3);
        }

        @Nullable
        public final Object ofFile(@NotNull File file, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.ofFile(file, (List<String>)CollectionsKt.listOfNotNull((Object)mediaType), (List<String>)CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, File file, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofFile(file, string2, string3, list, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull File file, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.of(new FormatSnifferFileContent(file), mediaTypes, (List<String>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FilesKt.getExtension((File)file)), (Iterable)fileExtensions), sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, File file, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofFile(file, (List<String>)list, (List<String>)list2, list3, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull String path, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.ofFile(new File(path), mediaType, fileExtension, sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, String string2, String string3, String string4, List list, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                string4 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofFile(string2, string3, string4, list, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull String path, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.ofFile(new File(path), mediaTypes, fileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, String string2, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofFile(string2, (List<String>)list, (List<String>)list2, list3, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofBytes(@NotNull Function0<byte[]> bytes2, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.ofBytes(bytes2, CollectionsKt.listOfNotNull((Object)mediaType), CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object ofBytes$default(Companion companion, Function0 function0, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofBytes((Function0<byte[]>)function0, string2, string3, list, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofBytes(@NotNull Function0<byte[]> bytes2, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.of(new FormatSnifferBytesContent(bytes2), mediaTypes, fileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object ofBytes$default(Companion companion, Function0 function0, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofBytes((Function0<byte[]>)function0, list, list2, list3, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofUri(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            return this.ofUri(uri, contentResolver, CollectionsKt.listOfNotNull((Object)mediaType), CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object ofUri$default(Companion companion, Uri uri, ContentResolver contentResolver, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofUri(uri, contentResolver, string2, string3, list, (Continuation<? super Format>)continuation);
        }

        @Nullable
        public final Object ofUri(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            CharSequence charSequence;
            List allMediaTypes = CollectionsKt.toMutableList((Collection)mediaTypes);
            List allFileExtensions = CollectionsKt.toMutableList((Collection)fileExtensions);
            CharSequence charSequence2 = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            boolean bl = false;
            CharSequence charSequence3 = charSequence2;
            boolean bl2 = false;
            if (charSequence3.length() == 0) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String string2 = (String)charSequence;
            if (string2 != null) {
                charSequence2 = string2;
                bl = false;
                boolean bl4 = false;
                CharSequence it = charSequence2;
                boolean bl5 = false;
                allFileExtensions.add(0, it);
            }
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
                CharSequence charSequence4 = contentResolver.getType(uri);
                if (charSequence4 != null) {
                    charSequence2 = charSequence4;
                    bl = false;
                    boolean bl6 = false;
                    CharSequence it = charSequence2;
                    boolean bl7 = false;
                    charSequence4 = Boxing.boxBoolean((boolean)MediaType.Companion.getBINARY().matches((String)it)) == false ? charSequence2 : null;
                    if (charSequence4 != null) {
                        charSequence2 = charSequence4;
                        bl = false;
                        bl6 = false;
                        it = charSequence2;
                        boolean bl8 = false;
                        CharSequence charSequence5 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence5, (String)"it");
                        allMediaTypes.add(0, charSequence5);
                    }
                }
                String string3 = ContentResolverKt.queryProjection(contentResolver, uri, "_display_name");
                if (string3 != null) {
                    charSequence2 = string3;
                    bl = false;
                    boolean bl9 = false;
                    CharSequence filename = charSequence2;
                    boolean bl10 = false;
                    allFileExtensions.add(0, FilesKt.getExtension((File)new File((String)filename)));
                }
            }
            FormatSnifferUriContent content = new FormatSnifferUriContent(uri, contentResolver);
            return this.of(content, allMediaTypes, (List<String>)allFileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object ofUri$default(Companion companion, Uri uri, ContentResolver contentResolver, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 0x10) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofUri(uri, contentResolver, list, list2, list3, (Continuation<? super Format>)continuation);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        final /* synthetic */ Object of(@Nullable FormatSnifferContent content, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers, @NotNull Continuation<? super Format> $completion) {
            block13: {
                if (!($completion instanceof of.3)) ** GOTO lbl-1000
                var11_6 = $completion;
                if ((var11_6.label & -2147483648) != 0) {
                    var11_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        /* synthetic */ Object result;
                        int label;
                        final /* synthetic */ Companion this$0;
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.of(null, null, null, null, (Continuation<? super Format>)this);
                        }
                        {
                            this.this$0 = companion;
                            super(continuation);
                        }
                    };
                }
                $result = $continuation.result;
                var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        context = new FormatSnifferContext(null, mediaTypes, fileExtensions, 1, null);
                        var8_11 = sniffers.iterator();
lbl14:
                        // 2 sources

                        while (var8_11.hasNext()) {
                            sniffer = (Function2)var8_11.next();
                            $continuation.L$0 = this;
                            $continuation.L$1 = content;
                            $continuation.L$2 = mediaTypes;
                            $continuation.L$3 = fileExtensions;
                            $continuation.L$4 = sniffers;
                            $continuation.L$5 = context;
                            $continuation.L$6 = sniffer;
                            $continuation.L$7 = var8_11;
                            $continuation.label = 1;
                            v0 = sniffer.invoke((Object)context, (Object)$continuation);
                            if (v0 == var12_8) {
                                return var12_8;
                            }
                            ** GOTO lbl41
                        }
                        break;
                    }
                    case 1: {
                        var8_11 = (Iterator<E>)$continuation.L$7;
                        sniffer = (Function2)$continuation.L$6;
                        context = (FormatSnifferContext)$continuation.L$5;
                        sniffers = (List)$continuation.L$4;
                        fileExtensions = (List)$continuation.L$3;
                        mediaTypes = (List)$continuation.L$2;
                        content = (FormatSnifferContent)$continuation.L$1;
                        this = (Companion)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl41:
                        // 2 sources

                        if ((format = (Format)v0) == null) ** GOTO lbl14
                        return format;
                    }
                }
                if (content == null) break block13;
                context = new FormatSnifferContext(content, mediaTypes, fileExtensions);
                var8_11 = sniffers.iterator();
lbl46:
                // 2 sources

                while (var8_11.hasNext()) {
                    sniffer = (Function2)var8_11.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = content;
                    $continuation.L$2 = mediaTypes;
                    $continuation.L$3 = fileExtensions;
                    $continuation.L$4 = sniffers;
                    $continuation.L$5 = context;
                    $continuation.L$6 = sniffer;
                    $continuation.L$7 = var8_11;
                    $continuation.label = 2;
                    v1 = sniffer.invoke((Object)context, (Object)$continuation);
                    if (v1 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl73
                }
                {
                    break;
                    case 2: {
                        var8_11 = (Iterator)$continuation.L$7;
                        sniffer = (Function2)$continuation.L$6;
                        context = (FormatSnifferContext)$continuation.L$5;
                        sniffers = (List)$continuation.L$4;
                        fileExtensions = (List)$continuation.L$3;
                        mediaTypes = (List)$continuation.L$2;
                        content = (FormatSnifferContent)$continuation.L$1;
                        this = (Companion)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl73:
                        // 2 sources

                        if ((format = (Format)v1) == null) ** GOTO lbl46
                        return format;
                    }
                }
            }
            $continuation.L$0 = this;
            $continuation.L$1 = content;
            $continuation.L$2 = mediaTypes;
            $continuation.L$3 = fileExtensions;
            $continuation.L$4 = sniffers;
            $continuation.L$5 = context;
            $continuation.label = 3;
            v2 = FormatSniffers.INSTANCE.system(context, (Continuation<? super Format>)$continuation);
            if (v2 == var12_8) {
                return var12_8;
            }
            ** GOTO lbl96
            {
                case 3: {
                    context = (FormatSnifferContext)$continuation.L$5;
                    sniffers = (List)$continuation.L$4;
                    fileExtensions = (List)$continuation.L$3;
                    mediaTypes = (List)$continuation.L$2;
                    content = (FormatSnifferContent)$continuation.L$1;
                    this = (Companion)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl96:
                    // 2 sources

                    return v2;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Deprecated(message="Renamed to [ofFile()]", replaceWith=@ReplaceWith(imports={}, expression="Format.ofFile(file, mediaType, fileExtension, sniffers)"))
        @Nullable
        public final Format of(@NotNull File file, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(file, mediaType, fileExtension, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ File $file;
                final /* synthetic */ String $mediaType;
                final /* synthetic */ String $fileExtension;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.ofFile(this.$file, (List<String>)CollectionsKt.listOfNotNull((Object)this.$mediaType), (List<String>)CollectionsKt.listOfNotNull((Object)this.$fileExtension), (List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>>)this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$file = file;
                    this.$mediaType = string2;
                    this.$fileExtension = string3;
                    this.$sniffers = list;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, File file, String string2, String string3, List list, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of(file, string2, string3, list);
        }

        @Deprecated(message="Renamed to [ofFile()]", replaceWith=@ReplaceWith(imports={}, expression="Format.ofFile(file, mediaTypes, fileExtensions, sniffers)"))
        @Nullable
        public final Format of(@NotNull File file, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkParameterIsNotNull(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(file, mediaTypes, fileExtensions, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ File $file;
                final /* synthetic */ List $mediaTypes;
                final /* synthetic */ List $fileExtensions;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.ofFile(this.$file, (List<String>)this.$mediaTypes, (List<String>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FilesKt.getExtension((File)this.$file)), (Iterable)this.$fileExtensions), (List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>>)this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$file = file;
                    this.$mediaTypes = list;
                    this.$fileExtensions = list2;
                    this.$sniffers = list3;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, File file, List list, List list2, List list3, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of(file, (List<String>)list, (List<String>)list2, list3);
        }

        @Deprecated(message="Renamed to [ofBytes()]", replaceWith=@ReplaceWith(imports={}, expression="Format.ofBytes(bytes, mediaType, fileExtension, sniffers)"))
        @Nullable
        public final Format of(@NotNull Function0<byte[]> bytes2, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull(bytes2, (String)"bytes");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(bytes2, mediaType, fileExtension, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Function0 $bytes;
                final /* synthetic */ String $mediaType;
                final /* synthetic */ String $fileExtension;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.ofBytes((Function0<byte[]>)this.$bytes, CollectionsKt.listOfNotNull((Object)this.$mediaType), CollectionsKt.listOfNotNull((Object)this.$fileExtension), (List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>>)this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$bytes = function0;
                    this.$mediaType = string2;
                    this.$fileExtension = string3;
                    this.$sniffers = list;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, Function0 function0, String string2, String string3, List list, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of((Function0<byte[]>)function0, string2, string3, list);
        }

        @Deprecated(message="Renamed to [ofBytes()]", replaceWith=@ReplaceWith(imports={}, expression="Format.ofBytes(bytes, mediaTypes, fileExtensions, sniffers)"))
        @Nullable
        public final Format of(@NotNull Function0<byte[]> bytes2, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull(bytes2, (String)"bytes");
            Intrinsics.checkParameterIsNotNull(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkParameterIsNotNull(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(bytes2, mediaTypes, fileExtensions, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Function0 $bytes;
                final /* synthetic */ List $mediaTypes;
                final /* synthetic */ List $fileExtensions;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.ofBytes((Function0<byte[]>)this.$bytes, this.$mediaTypes, this.$fileExtensions, (List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>>)this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$bytes = function0;
                    this.$mediaTypes = list;
                    this.$fileExtensions = list2;
                    this.$sniffers = list3;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, Function0 function0, List list, List list2, List list3, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of((Function0<byte[]>)function0, (List<String>)list, (List<String>)list2, list3);
        }

        @Deprecated(message="Renamed to [ofUri()]", replaceWith=@ReplaceWith(imports={}, expression="Format.ofUri(uri, contentResolver, mediaType, fileExtension, sniffers)"))
        @Nullable
        public final Format of(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @Nullable String mediaType, @Nullable String fileExtension, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Intrinsics.checkParameterIsNotNull((Object)contentResolver, (String)"contentResolver");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(uri, contentResolver, mediaType, fileExtension, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Uri $uri;
                final /* synthetic */ ContentResolver $contentResolver;
                final /* synthetic */ String $mediaType;
                final /* synthetic */ String $fileExtension;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.ofUri(this.$uri, this.$contentResolver, CollectionsKt.listOfNotNull((Object)this.$mediaType), CollectionsKt.listOfNotNull((Object)this.$fileExtension), (List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>>)this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$uri = uri;
                    this.$contentResolver = contentResolver;
                    this.$mediaType = string2;
                    this.$fileExtension = string3;
                    this.$sniffers = list;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, Uri uri, ContentResolver contentResolver, String string2, String string3, List list, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of(uri, contentResolver, string2, string3, list);
        }

        @Deprecated(message="Renamed to [ofUri()]", replaceWith=@ReplaceWith(imports={}, expression="Format.ofUri(uri, contentResolver, mediaTypes, fileExtensions, sniffers)"))
        @Nullable
        public final Format of(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>> sniffers) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Intrinsics.checkParameterIsNotNull((Object)contentResolver, (String)"contentResolver");
            Intrinsics.checkParameterIsNotNull(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkParameterIsNotNull(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkParameterIsNotNull(sniffers, (String)"sniffers");
            return (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(uri, contentResolver, mediaTypes, fileExtensions, sniffers, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Uri $uri;
                final /* synthetic */ ContentResolver $contentResolver;
                final /* synthetic */ List $mediaTypes;
                final /* synthetic */ List $fileExtensions;
                final /* synthetic */ List $sniffers;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = Format.Companion.ofUri(this.$uri, this.$contentResolver, this.$mediaTypes, this.$fileExtensions, (List<? extends Function2<? super FormatSnifferContext, ? super Continuation<? super Format>, ? extends Object>>)this.$sniffers, (Continuation<? super Format>)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$uri = uri;
                    this.$contentResolver = contentResolver;
                    this.$mediaTypes = list;
                    this.$fileExtensions = list2;
                    this.$sniffers = list3;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ Format of$default(Companion companion, Uri uri, ContentResolver contentResolver, List list, List list2, List list3, int n, Object object) {
            if ((n & 0x10) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of(uri, contentResolver, (List<String>)list, list2, list3);
        }

        @Deprecated(message="Use [READIUM_AUDIOBOOK] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_AUDIOBOOK"))
        public static /* synthetic */ void AUDIOBOOK$annotations() {
        }

        @NotNull
        public final Format getAUDIOBOOK() {
            return Companion.getREADIUM_AUDIOBOOK();
        }

        @Deprecated(message="Use [READIUM_AUDIOBOOK_MANIFEST] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_AUDIOBOOK_MANIFEST"))
        public static /* synthetic */ void AUDIOBOOK_MANIFEST$annotations() {
        }

        @NotNull
        public final Format getAUDIOBOOK_MANIFEST() {
            return Companion.getREADIUM_AUDIOBOOK_MANIFEST();
        }

        @Deprecated(message="Use [READIUM_WEBPUB] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_WEBPUB"))
        public static /* synthetic */ void WEBPUB$annotations() {
        }

        @NotNull
        public final Format getWEBPUB() {
            return Companion.getREADIUM_WEBPUB();
        }

        @Deprecated(message="Use [READIUM_WEBPUB_MANIFEST] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_WEBPUB_MANIFEST"))
        public static /* synthetic */ void WEBPUB_MANIFEST$annotations() {
        }

        @NotNull
        public final Format getWEBPUB_MANIFEST() {
            return Companion.getREADIUM_WEBPUB_MANIFEST();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

