/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared;

import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.LinkError;
import org.readium.r2.shared.Properties;
import org.readium.r2.shared.URLHelperKt;
import org.readium.r2.shared.opds.IndirectAcquisition;
import org.readium.r2.shared.opds.IndirectAcquisitionKt;
import org.readium.r2.shared.opds.Price;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0006"}, d2={"parseLink", "Lorg/readium/r2/shared/Link;", "linkDict", "Lorg/json/JSONObject;", "feedUrl", "Ljava/net/URL;", "r2-shared_release"})
public final class LinkKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Link parseLink(@NotNull JSONObject linkDict, @Nullable URL feedUrl) {
        Intrinsics.checkParameterIsNotNull((Object)linkDict, (String)"linkDict");
        Link link = new Link();
        if (linkDict.has("title")) {
            link.setTitle(linkDict.getString("title"));
        }
        if (linkDict.has("href")) {
            URL uRL = feedUrl;
            if (uRL != null) {
                URL uRL2;
                URL it = uRL2 = uRL;
                String string = linkDict.getString("href");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = feedUrl.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"feedUrl.toString()");
                link.setHref(URLHelperKt.getAbsolute(string, string2));
            } else {
                String string = linkDict.getString("href");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                link.setHref(string);
            }
        }
        if (linkDict.has("type")) {
            link.setTypeLink(linkDict.getString("type"));
        }
        if (linkDict.has("rel")) {
            JSONArray array;
            int $i$a$1$let;
            int it;
            if (linkDict.get("rel") instanceof String) {
                List<String> list = link.getRel();
                String string = linkDict.getString("rel");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkDict.getString(\"rel\")");
                list.add(string);
            } else if (linkDict.get("rel") instanceof JSONArray && (it = 0) <= ($i$a$1$let = (array = linkDict.getJSONArray("rel")).length() - 1)) {
                while (true) {
                    void i;
                    String string = array.getString((int)i);
                    List<String> list = link.getRel();
                    String string3 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"string");
                    list.add(string3);
                    if (i == $i$a$1$let) break;
                    ++i;
                }
            }
        }
        if (linkDict.has("height")) {
            link.setHeight(linkDict.getInt("height"));
        }
        if (linkDict.has("width")) {
            link.setWidth(linkDict.getInt("width"));
        }
        if (linkDict.has("bitrate")) {
            link.setBitrate(linkDict.getInt("bitrate"));
        }
        if (linkDict.has("duration")) {
            link.setDuration(linkDict.getDouble("duration"));
        }
        if (linkDict.has("properties")) {
            Properties properties = new Properties();
            JSONObject propertiesDict = linkDict.getJSONObject("properties");
            if (propertiesDict.has("numberOfItems")) {
                properties.setNumberOfItems(propertiesDict.getInt("numberOfItems"));
            }
            if (propertiesDict.has("indirectAcquisition")) {
                JSONArray jSONArray = propertiesDict.getJSONArray("indirectAcquisition");
                if (jSONArray == null) {
                    throw (Throwable)new Exception(LinkError.InvalidLink.name());
                }
                JSONArray acquisitions = jSONArray;
                int string = 0;
                int n = acquisitions.length() - 1;
                if (string <= n) {
                    while (true) {
                        void i;
                        JSONObject acquisition;
                        JSONObject jSONObject = acquisition = acquisitions.getJSONObject((int)i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"acquisition");
                        IndirectAcquisition indirectAcquisition = IndirectAcquisitionKt.parseIndirectAcquisition(jSONObject);
                        properties.getIndirectAcquisition().add(indirectAcquisition);
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            if (propertiesDict.has("price")) {
                JSONObject priceDict = propertiesDict.getJSONObject("price");
                Object object = priceDict.get("currency");
                if (!(object instanceof String)) {
                    object = null;
                }
                String currency = (String)object;
                Object object2 = priceDict.get("value");
                if (!(object2 instanceof Double)) {
                    object2 = null;
                }
                Double value = (Double)object2;
                if (priceDict == null || currency == null || value == null) {
                    throw (Throwable)new Exception(LinkError.InvalidLink.name());
                }
                Price price = new Price(currency, value);
                properties.setPrice(price);
            }
        }
        if (linkDict.has("children")) {
            JSONObject jSONObject = linkDict.getJSONObject("children");
            if (jSONObject == null) {
                throw (Throwable)new Exception(LinkError.InvalidLink.name());
            }
            JSONObject childLinkDict = jSONObject;
            Link childLink = LinkKt.parseLink$default(childLinkDict, null, 2, null);
            link.getChildren().add(childLink);
        }
        return link;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Link parseLink$default(JSONObject jSONObject, URL uRL, int n, Object object) {
        if ((n & 2) != 0) {
            uRL = null;
        }
        return LinkKt.parseLink(jSONObject, uRL);
    }
}

