/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.opds;

import com.github.kittinunf.fuel.Fuel;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import nl.komponents.kovenant.KovenantApi;
import nl.komponents.kovenant.Promise;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.opds.OPDS2ParserError;
import org.readium.r2.shared.FuelPromiseExtensionKt;
import org.readium.r2.shared.opds.Facet;
import org.readium.r2.shared.opds.Feed;
import org.readium.r2.shared.opds.Group;
import org.readium.r2.shared.opds.OpdsMetadata;
import org.readium.r2.shared.opds.ParseData;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Manifest;
import org.readium.r2.shared.publication.Publication;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/readium/r2/opds/OPDS2Parser;", "", "()V", "Companion", "r2-opds_release"})
public final class OPDS2Parser {
    private static Feed feed;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060!j\u0002`\"0 2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060!j\u0002`\"0 2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/readium/r2/opds/OPDS2Parser$Companion;", "", "()V", "feed", "Lorg/readium/r2/shared/opds/Feed;", "isFeed", "", "jsonData", "", "parse", "Lorg/readium/r2/shared/opds/ParseData;", "url", "Ljava/net/URL;", "parseFacets", "", "facets", "Lorg/json/JSONArray;", "parseFeed", "parseFeedMetadata", "opdsMetadata", "Lorg/readium/r2/shared/opds/OpdsMetadata;", "metadataDict", "Lorg/json/JSONObject;", "parseGroups", "groups", "parseLinks", "links", "parseNavigation", "navLinks", "parsePublications", "publications", "parseURL", "Lnl/komponents/kovenant/Promise;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "headers", "", "", "r2-opds_release"})
    public static final class Companion {
        @NotNull
        public final Promise<ParseData, Exception> parseURL(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.INSTANCE.get(string, null)), (Function1)((Function1)new Function1<Triple<? extends Request, ? extends Response, ? extends byte[]>, ParseData>(url){
                final /* synthetic */ URL $url;

                @NotNull
                public final ParseData invoke(@NotNull Triple<? extends Request, Response, byte[]> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Triple<? extends Request, Response, byte[]> triple = it;
                    byte[] result = (byte[])triple.component3();
                    return OPDS2Parser.Companion.parse(result, this.$url);
                }
                {
                    this.$url = uRL;
                    super(1);
                }
            }));
        }

        @NotNull
        public final Promise<ParseData, Exception> parseURL(@NotNull Map<String, String> headers, @NotNull URL url) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.INSTANCE.get(string, null).header(headers)), (Function1)((Function1)new Function1<Triple<? extends Request, ? extends Response, ? extends byte[]>, ParseData>(url){
                final /* synthetic */ URL $url;

                @NotNull
                public final ParseData invoke(@NotNull Triple<? extends Request, Response, byte[]> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Triple<? extends Request, Response, byte[]> triple = it;
                    byte[] result = (byte[])triple.component3();
                    return OPDS2Parser.Companion.parse(result, this.$url);
                }
                {
                    this.$url = uRL;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ParseData parse(@NotNull byte[] jsonData, @NotNull URL url) {
            ParseData parseData;
            Intrinsics.checkNotNullParameter((Object)jsonData, (String)"jsonData");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (this.isFeed(jsonData)) {
                parseData = new ParseData(this.parseFeed(jsonData, url), null, 2);
            } else {
                Publication publication;
                Feed feed = null;
                boolean bl = false;
                Manifest manifest = Manifest.Companion.fromJSON$default((Manifest.Companion)Manifest.Companion, (JSONObject)new JSONObject(new String(jsonData, Charsets.UTF_8)), (boolean)false, null, (int)6, null);
                if (manifest != null) {
                    void it;
                    Manifest manifest2 = manifest;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Manifest manifest3 = manifest2;
                    Feed feed2 = feed;
                    boolean bl4 = false;
                    Publication publication2 = new Publication((Manifest)it, null, null, null, null, null, null, 126, null);
                    feed = feed2;
                    publication = publication2;
                } else {
                    publication = null;
                }
                int n = 2;
                Publication publication3 = publication;
                Feed feed3 = feed;
                parseData = new ParseData(feed3, publication3, n);
            }
            return parseData;
        }

        private final boolean isFeed(byte[] jsonData) {
            boolean bl = false;
            JSONObject jSONObject = new JSONObject(new String(jsonData, Charsets.UTF_8));
            boolean bl2 = false;
            boolean bl3 = false;
            JSONObject it = jSONObject;
            boolean bl4 = false;
            return it.has("navigation") || it.has("groups") || it.has("publications") || it.has("facets");
        }

        /*
         * WARNING - void declaration
         */
        private final Feed parseFeed(byte[] jsonData, URL url) {
            Object it;
            Object object;
            int n;
            int n2;
            boolean bl = false;
            JSONObject topLevelDict = new JSONObject(new String(jsonData, Charsets.UTF_8));
            JSONObject jSONObject = topLevelDict.getJSONObject("metadata");
            if (jSONObject == null) {
                throw (Throwable)new Exception(OPDS2ParserError.MetadataNotFound.name());
            }
            JSONObject metadataDict = jSONObject;
            String string = metadataDict.getString("title");
            if (string == null) {
                throw (Throwable)new Exception(OPDS2ParserError.MissingTitle.name());
            }
            String title = string;
            OPDS2Parser.feed = new Feed(title, 2, url, null, null, null, null, null, null, null, 1016, null);
            Feed feed = feed;
            if (feed == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
            }
            this.parseFeedMetadata(feed.getMetadata(), metadataDict);
            if (topLevelDict.has("@context")) {
                if (topLevelDict.get("@context") instanceof JSONObject) {
                    Feed feed2 = feed;
                    if (feed2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                    }
                    List list = feed2.getContext();
                    String string2 = topLevelDict.getString("@context");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"topLevelDict.getString(\"@context\")");
                    list.add(string2);
                } else if (topLevelDict.get("@context") instanceof JSONArray) {
                    JSONArray array = topLevelDict.getJSONArray("@context");
                    n2 = 0;
                    n = array.length();
                    while (n2 < n) {
                        void i;
                        String string3 = array.getString((int)i);
                        Feed feed3 = feed;
                        if (feed3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                        }
                        List list = feed3.getContext();
                        String string4 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"string");
                        list.add(string4);
                        ++i;
                    }
                }
            }
            if (topLevelDict.has("links")) {
                object = topLevelDict.get("links");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl2 = false;
                Object object2 = it;
                if (!(object2 instanceof JSONArray)) {
                    object2 = null;
                }
                JSONArray jSONArray = (JSONArray)object2;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray links = jSONArray;
                Feed feed4 = feed;
                if (feed4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseLinks(feed4, links);
            }
            if (topLevelDict.has("facets")) {
                object = topLevelDict.get("facets");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl3 = false;
                Object object3 = it;
                if (!(object3 instanceof JSONArray)) {
                    object3 = null;
                }
                JSONArray jSONArray = (JSONArray)object3;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray facets = jSONArray;
                Feed feed5 = feed;
                if (feed5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseFacets(feed5, facets);
            }
            if (topLevelDict.has("publications")) {
                object = topLevelDict.get("publications");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl4 = false;
                Object object4 = it;
                if (!(object4 instanceof JSONArray)) {
                    object4 = null;
                }
                JSONArray jSONArray = (JSONArray)object4;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray publications = jSONArray;
                Feed feed6 = feed;
                if (feed6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parsePublications(feed6, publications);
            }
            if (topLevelDict.has("navigation")) {
                object = topLevelDict.get("navigation");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl5 = false;
                Object object5 = it;
                if (!(object5 instanceof JSONArray)) {
                    object5 = null;
                }
                JSONArray jSONArray = (JSONArray)object5;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray navigation = jSONArray;
                Feed feed7 = feed;
                if (feed7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseNavigation(feed7, navigation);
            }
            if (topLevelDict.has("groups")) {
                object = topLevelDict.get("groups");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl6 = false;
                Object object6 = it;
                if (!(object6 instanceof JSONArray)) {
                    object6 = null;
                }
                JSONArray jSONArray = (JSONArray)object6;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray groups = jSONArray;
                Feed feed8 = feed;
                if (feed8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseGroups(feed8, groups);
            }
            Feed feed9 = feed;
            if (feed9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
            }
            return feed9;
        }

        private final void parseFeedMetadata(OpdsMetadata opdsMetadata, JSONObject metadataDict) {
            boolean bl;
            String string;
            Object it;
            boolean bl2;
            boolean bl3;
            Object object;
            if (metadataDict.has("title")) {
                object = metadataDict.get("title");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl4 = false;
                opdsMetadata.setTitle(it.toString());
            }
            if (metadataDict.has("numberOfItems")) {
                object = metadataDict.get("numberOfItems");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl5 = false;
                string = it.toString();
                bl = false;
                opdsMetadata.setNumberOfItems(Integer.valueOf(Integer.parseInt(string)));
            }
            if (metadataDict.has("itemsPerPage")) {
                object = metadataDict.get("itemsPerPage");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl6 = false;
                string = it.toString();
                bl = false;
                opdsMetadata.setItemsPerPage(Integer.valueOf(Integer.parseInt(string)));
            }
            if (metadataDict.has("modified")) {
                object = metadataDict.get("modified");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl7 = false;
                opdsMetadata.setModified(new DateTime((Object)it.toString()).toDate());
            }
            if (metadataDict.has("@type")) {
                object = metadataDict.get("@type");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl8 = false;
                opdsMetadata.setRdfType(it.toString());
            }
            if (metadataDict.has("currentPage")) {
                object = metadataDict.get("currentPage");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl9 = false;
                string = it.toString();
                bl = false;
                opdsMetadata.setCurrentPage(Integer.valueOf(Integer.parseInt(string)));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseFacets(Feed feed, JSONArray facets) {
            int n = 0;
            int n2 = facets.length();
            while (n < n2) {
                String title;
                JSONObject metadata;
                void i;
                JSONObject facetDict = facets.getJSONObject((int)i);
                if (facetDict.getJSONObject("metadata") == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidFacet.name());
                }
                Object object = metadata.get("title");
                if (!(object instanceof String)) {
                    object = null;
                }
                if ((String)object == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidFacet.name());
                }
                Facet facet = new Facet(title, null, null, 6, null);
                this.parseFeedMetadata(facet.getMetadata(), metadata);
                if (facetDict.has("links")) {
                    JSONArray links;
                    if (facetDict.getJSONArray("links") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidFacet.name());
                    }
                    int n3 = 0;
                    int n4 = links.length();
                    while (n3 < n4) {
                        void k;
                        JSONObject linkDict = links.getJSONObject((int)k);
                        if (Link.Companion.fromJSON$default((Link.Companion)Link.Companion, (JSONObject)linkDict, null, null, (int)6, null) != null) {
                            Link link;
                            boolean bl = false;
                            boolean bl2 = false;
                            Link it = link;
                            boolean bl3 = false;
                            facet.getLinks().add(it);
                        }
                        ++k;
                    }
                }
                feed.getFacets().add(facet);
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseLinks(Feed feed, JSONArray links) {
            int n = 0;
            int n2 = links.length();
            while (n < n2) {
                void i;
                JSONObject linkDict = links.getJSONObject((int)i);
                if (Link.Companion.fromJSON$default((Link.Companion)Link.Companion, (JSONObject)linkDict, null, null, (int)6, null) != null) {
                    Link link;
                    boolean bl = false;
                    boolean bl2 = false;
                    Link it = link;
                    boolean bl3 = false;
                    feed.getLinks().add(it);
                }
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parsePublications(Feed feed, JSONArray publications) {
            int n = 0;
            int n2 = publications.length();
            while (n < n2) {
                void i;
                JSONObject pubDict = publications.getJSONObject((int)i);
                if (Manifest.Companion.fromJSON$default((Manifest.Companion)Manifest.Companion, (JSONObject)pubDict, (boolean)false, null, (int)6, null) != null) {
                    Manifest manifest;
                    boolean bl = false;
                    boolean bl2 = false;
                    Manifest manifest2 = manifest;
                    boolean bl3 = false;
                    feed.getPublications().add(new Publication(manifest2, null, null, null, null, null, null, 126, null));
                }
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseNavigation(Feed feed, JSONArray navLinks) {
            int n = 0;
            int n2 = navLinks.length();
            while (n < n2) {
                void i;
                JSONObject navDict = navLinks.getJSONObject((int)i);
                if (Link.Companion.fromJSON$default((Link.Companion)Link.Companion, (JSONObject)navDict, null, null, (int)6, null) != null) {
                    Link link;
                    boolean bl = false;
                    boolean bl2 = false;
                    Link link2 = link;
                    boolean bl3 = false;
                    feed.getNavigation().add(link2);
                }
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseGroups(Feed feed, JSONArray groups) {
            int n = 0;
            int n2 = groups.length();
            while (n < n2) {
                Link link;
                Link link2;
                boolean bl;
                boolean bl2;
                JSONObject linkDict;
                int j;
                int n3;
                JSONArray links;
                String title;
                JSONObject metadata;
                void i;
                JSONObject groupDict = groups.getJSONObject((int)i);
                if (groupDict.getJSONObject("metadata") == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                }
                if (metadata.getString("title") == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                }
                Group group = new Group(title);
                this.parseFeedMetadata(group.getMetadata(), metadata);
                if (groupDict.has("links")) {
                    if (groupDict.getJSONArray("links") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                    }
                    int n4 = 0;
                    n3 = links.length();
                    while (n4 < n3) {
                        linkDict = links.getJSONObject(j);
                        if (Link.Companion.fromJSON$default((Link.Companion)Link.Companion, (JSONObject)linkDict, null, null, (int)6, null) != null) {
                            bl2 = false;
                            bl = false;
                            link = link2;
                            boolean bl3 = false;
                            group.getLinks().add(link);
                        }
                        ++j;
                    }
                }
                if (groupDict.has("navigation")) {
                    if (groupDict.getJSONArray("navigation") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                    }
                    n3 = links.length();
                    for (j = 0; j < n3; ++j) {
                        linkDict = links.getJSONObject(j);
                        if (Link.Companion.fromJSON$default((Link.Companion)Link.Companion, (JSONObject)linkDict, null, null, (int)6, null) == null) continue;
                        bl2 = false;
                        bl = false;
                        link = link2;
                        boolean bl4 = false;
                        group.getNavigation().add(link);
                    }
                }
                if (groupDict.has("publications")) {
                    JSONArray publications;
                    if (groupDict.getJSONArray("publications") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                    }
                    n3 = publications.length();
                    for (j = 0; j < n3; ++j) {
                        JSONObject pubDict = publications.getJSONObject(j);
                        if (Manifest.Companion.fromJSON$default((Manifest.Companion)Manifest.Companion, (JSONObject)pubDict, (boolean)false, null, (int)6, null) == null) continue;
                        bl2 = false;
                        bl = false;
                        Link manifest = link2;
                        boolean bl5 = false;
                        group.getPublications().add(new Publication((Manifest)manifest, null, null, null, null, null, null, 126, null));
                    }
                }
                feed.getGroups().add(group);
                ++i;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

