/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.opds;

import com.github.kittinunf.fuel.Fuel;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import nl.komponents.kovenant.KovenantApi;
import nl.komponents.kovenant.Promise;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.opds.OPDS2ParserError;
import org.readium.r2.shared.FuelPromiseExtensionKt;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.LinkKt;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.shared.opds.Facet;
import org.readium.r2.shared.opds.Feed;
import org.readium.r2.shared.opds.Group;
import org.readium.r2.shared.opds.OpdsMetadata;
import org.readium.r2.shared.opds.ParseData;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/readium/r2/opds/OPDS2Parser;", "", "()V", "Companion", "r2-opds_release"})
public final class OPDS2Parser {
    private static Feed feed;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060!j\u0002`\"0 2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060!j\u0002`\"0 2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/readium/r2/opds/OPDS2Parser$Companion;", "", "()V", "feed", "Lorg/readium/r2/shared/opds/Feed;", "isFeed", "", "jsonData", "", "parse", "Lorg/readium/r2/shared/opds/ParseData;", "url", "Ljava/net/URL;", "parseFacets", "", "facets", "Lorg/json/JSONArray;", "parseFeed", "parseFeedMetadata", "opdsMetadata", "Lorg/readium/r2/shared/opds/OpdsMetadata;", "metadataDict", "Lorg/json/JSONObject;", "parseGroups", "groups", "parseLinks", "links", "parseNavigation", "navLinks", "parsePublications", "publications", "parseURL", "Lnl/komponents/kovenant/Promise;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "headers", "", "", "r2-opds_release"})
    public static final class Companion {
        @NotNull
        public final Promise<ParseData, Exception> parseURL(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.Companion.get(string, null)), (Function1)((Function1)new Function1<Triple<? extends Request, ? extends Response, ? extends byte[]>, ParseData>(url){
                final /* synthetic */ URL $url;

                @NotNull
                public final ParseData invoke(@NotNull Triple<Request, Response, byte[]> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Triple<Request, Response, byte[]> triple = it;
                    byte[] result = (byte[])triple.component3();
                    return OPDS2Parser.Companion.parse(result, this.$url);
                }
                {
                    this.$url = uRL;
                    super(1);
                }
            }));
        }

        @NotNull
        public final Promise<ParseData, Exception> parseURL(@NotNull Map<String, String> headers, @NotNull URL url) {
            Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.Companion.get(string, null).header(headers)), (Function1)((Function1)new Function1<Triple<? extends Request, ? extends Response, ? extends byte[]>, ParseData>(url){
                final /* synthetic */ URL $url;

                @NotNull
                public final ParseData invoke(@NotNull Triple<Request, Response, byte[]> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Triple<Request, Response, byte[]> triple = it;
                    byte[] result = (byte[])triple.component3();
                    return OPDS2Parser.Companion.parse(result, this.$url);
                }
                {
                    this.$url = uRL;
                    super(1);
                }
            }));
        }

        @NotNull
        public final ParseData parse(@NotNull byte[] jsonData, @NotNull URL url) {
            ParseData parseData;
            Intrinsics.checkParameterIsNotNull((Object)jsonData, (String)"jsonData");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            if (this.isFeed(jsonData)) {
                parseData = new ParseData(this.parseFeed(jsonData, url), null, 2);
            } else {
                String string;
                Feed feed = null;
                boolean bl = false;
                String string2 = string = new String(jsonData, Charsets.UTF_8);
                int n = 2;
                Publication publication = PublicationKt.parsePublication((JSONObject)new JSONObject(string2));
                Feed feed2 = feed;
                parseData = new ParseData(feed2, publication, n);
            }
            return parseData;
        }

        private final boolean isFeed(byte[] jsonData) {
            String string;
            boolean bl = false;
            String string2 = string = new String(jsonData, Charsets.UTF_8);
            JSONObject jSONObject = new JSONObject(string2);
            boolean bl2 = false;
            boolean bl3 = false;
            JSONObject it = jSONObject;
            boolean bl4 = false;
            return it.has("navigation") || it.has("groups") || it.has("publications") || it.has("facets");
        }

        /*
         * WARNING - void declaration
         */
        private final Feed parseFeed(byte[] jsonData, URL url) {
            Object it;
            Object object;
            int n;
            int n2;
            String string;
            boolean bl = false;
            String string2 = string = new String(jsonData, Charsets.UTF_8);
            JSONObject topLevelDict = new JSONObject(string2);
            JSONObject jSONObject = topLevelDict.getJSONObject("metadata");
            if (jSONObject == null) {
                throw (Throwable)new Exception(OPDS2ParserError.MetadataNotFound.name());
            }
            JSONObject metadataDict = jSONObject;
            String string3 = metadataDict.getString("title");
            if (string3 == null) {
                throw (Throwable)new Exception(OPDS2ParserError.MissingTitle.name());
            }
            String title = string3;
            OPDS2Parser.feed = new Feed(title, 2, url);
            Feed feed = feed;
            if (feed == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
            }
            this.parseFeedMetadata(feed.getMetadata(), metadataDict);
            if (topLevelDict.has("@context")) {
                if (topLevelDict.get("@context") instanceof JSONObject) {
                    Feed feed2 = feed;
                    if (feed2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                    }
                    List list = feed2.getContext();
                    String string4 = topLevelDict.getString("@context");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"topLevelDict.getString(\"@context\")");
                    list.add(string4);
                } else if (topLevelDict.get("@context") instanceof JSONArray) {
                    JSONArray array = topLevelDict.getJSONArray("@context");
                    n2 = 0;
                    n = array.length();
                    while (n2 < n) {
                        void i;
                        String string5 = array.getString((int)i);
                        Feed feed3 = feed;
                        if (feed3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                        }
                        List list = feed3.getContext();
                        String string6 = string5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"string");
                        list.add(string6);
                        ++i;
                    }
                }
            }
            if (topLevelDict.has("links")) {
                object = topLevelDict.get("links");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl2 = false;
                Object object2 = it;
                if (!(object2 instanceof JSONArray)) {
                    object2 = null;
                }
                JSONArray jSONArray = (JSONArray)object2;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray links = jSONArray;
                Feed feed4 = feed;
                if (feed4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseLinks(feed4, links);
            }
            if (topLevelDict.has("facets")) {
                object = topLevelDict.get("facets");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl3 = false;
                Object object3 = it;
                if (!(object3 instanceof JSONArray)) {
                    object3 = null;
                }
                JSONArray jSONArray = (JSONArray)object3;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray facets = jSONArray;
                Feed feed5 = feed;
                if (feed5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseFacets(feed5, facets);
            }
            if (topLevelDict.has("publications")) {
                object = topLevelDict.get("publications");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl4 = false;
                Object object4 = it;
                if (!(object4 instanceof JSONArray)) {
                    object4 = null;
                }
                JSONArray jSONArray = (JSONArray)object4;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray publications = jSONArray;
                Feed feed6 = feed;
                if (feed6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parsePublications(feed6, publications);
            }
            if (topLevelDict.has("navigation")) {
                object = topLevelDict.get("navigation");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl5 = false;
                Object object5 = it;
                if (!(object5 instanceof JSONArray)) {
                    object5 = null;
                }
                JSONArray jSONArray = (JSONArray)object5;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray navigation = jSONArray;
                Feed feed7 = feed;
                if (feed7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseNavigation(feed7, navigation);
            }
            if (topLevelDict.has("groups")) {
                object = topLevelDict.get("groups");
                n2 = 0;
                n = 0;
                it = object;
                boolean bl6 = false;
                Object object6 = it;
                if (!(object6 instanceof JSONArray)) {
                    object6 = null;
                }
                JSONArray jSONArray = (JSONArray)object6;
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidLink.name());
                }
                JSONArray groups = jSONArray;
                Feed feed8 = feed;
                if (feed8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
                }
                Companion.parseGroups(feed8, groups);
            }
            Feed feed9 = feed;
            if (feed9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"feed");
            }
            return feed9;
        }

        private final void parseFeedMetadata(OpdsMetadata opdsMetadata, JSONObject metadataDict) {
            int n;
            boolean bl;
            OpdsMetadata opdsMetadata2;
            String string;
            Object it;
            boolean bl2;
            boolean bl3;
            Object object;
            if (metadataDict.has("title")) {
                object = metadataDict.get("title");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl4 = false;
                opdsMetadata.setTitle(it.toString());
            }
            if (metadataDict.has("numberOfItems")) {
                object = metadataDict.get("numberOfItems");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl5 = false;
                string = it.toString();
                opdsMetadata2 = opdsMetadata;
                bl = false;
                n = Integer.parseInt(string);
                opdsMetadata2.setNumberOfItems(Integer.valueOf(n));
            }
            if (metadataDict.has("itemsPerPage")) {
                object = metadataDict.get("itemsPerPage");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl6 = false;
                string = it.toString();
                opdsMetadata2 = opdsMetadata;
                bl = false;
                n = Integer.parseInt(string);
                opdsMetadata2.setItemsPerPage(Integer.valueOf(n));
            }
            if (metadataDict.has("modified")) {
                object = metadataDict.get("modified");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl7 = false;
                opdsMetadata.setModified(new DateTime((Object)it.toString()).toDate());
            }
            if (metadataDict.has("@type")) {
                object = metadataDict.get("@type");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl8 = false;
                opdsMetadata.setRdfType(it.toString());
            }
            if (metadataDict.has("currentPage")) {
                object = metadataDict.get("currentPage");
                bl3 = false;
                bl2 = false;
                it = object;
                boolean bl9 = false;
                string = it.toString();
                opdsMetadata2 = opdsMetadata;
                bl = false;
                n = Integer.parseInt(string);
                opdsMetadata2.setCurrentPage(Integer.valueOf(n));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseFacets(Feed feed, JSONArray facets) {
            int n = 0;
            int n2 = facets.length();
            while (n < n2) {
                String title;
                JSONObject metadata;
                void i;
                JSONObject facetDict = facets.getJSONObject((int)i);
                if (facetDict.getJSONObject("metadata") == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidFacet.name());
                }
                Object object = metadata.get("title");
                if (!(object instanceof String)) {
                    object = null;
                }
                if ((String)object == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidFacet.name());
                }
                Facet facet = new Facet(title);
                this.parseFeedMetadata(facet.getMetadata(), metadata);
                if (facetDict.has("links")) {
                    JSONArray links;
                    if (facetDict.getJSONArray("links") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidFacet.name());
                    }
                    int n3 = 0;
                    int n4 = links.length();
                    while (n3 < n4) {
                        void k;
                        JSONObject linkDict;
                        JSONObject jSONObject = linkDict = links.getJSONObject((int)k);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                        Link link = LinkKt.parseLink$default((JSONObject)jSONObject, null, (int)2, null);
                        facet.getLinks().add(link);
                        ++k;
                    }
                }
                feed.getFacets().add(facet);
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseLinks(Feed feed, JSONArray links) {
            int n = 0;
            int n2 = links.length();
            while (n < n2) {
                void i;
                JSONObject linkDict;
                JSONObject jSONObject = linkDict = links.getJSONObject((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                Link link = LinkKt.parseLink((JSONObject)jSONObject, (URL)feed.getHref());
                feed.getLinks().add(link);
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parsePublications(Feed feed, JSONArray publications) {
            int n = 0;
            int n2 = publications.length();
            while (n < n2) {
                void i;
                JSONObject pubDict;
                JSONObject jSONObject = pubDict = publications.getJSONObject((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"pubDict");
                Publication pub = PublicationKt.parsePublication((JSONObject)jSONObject);
                feed.getPublications().add(pub);
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseNavigation(Feed feed, JSONArray navLinks) {
            int n = 0;
            int n2 = navLinks.length();
            while (n < n2) {
                void i;
                JSONObject navDict;
                JSONObject jSONObject = navDict = navLinks.getJSONObject((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"navDict");
                Link link = LinkKt.parseLink$default((JSONObject)jSONObject, null, (int)2, null);
                feed.getNavigation().add(link);
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseGroups(Feed feed, JSONArray groups) {
            int n = 0;
            int n2 = groups.length();
            while (n < n2) {
                Link link;
                int j;
                JSONObject linkDict;
                int n3;
                JSONArray links;
                String title;
                JSONObject metadata;
                void i;
                JSONObject groupDict = groups.getJSONObject((int)i);
                if (groupDict.getJSONObject("metadata") == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                }
                if (metadata.getString("title") == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                }
                Group group = new Group(title);
                this.parseFeedMetadata(group.getMetadata(), metadata);
                if (groupDict.has("links")) {
                    if (groupDict.getJSONArray("links") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                    }
                    int n4 = 0;
                    n3 = links.length();
                    while (n4 < n3) {
                        JSONObject jSONObject = linkDict = links.getJSONObject(j);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                        link = LinkKt.parseLink$default((JSONObject)jSONObject, null, (int)2, null);
                        group.getLinks().add(link);
                        ++j;
                    }
                }
                if (groupDict.has("navigation")) {
                    if (groupDict.getJSONArray("navigation") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                    }
                    n3 = links.length();
                    for (j = 0; j < n3; ++j) {
                        JSONObject jSONObject = linkDict = links.getJSONObject(j);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                        link = LinkKt.parseLink$default((JSONObject)jSONObject, null, (int)2, null);
                        group.getNavigation().add(link);
                    }
                }
                if (groupDict.has("publications")) {
                    JSONArray publications;
                    if (groupDict.getJSONArray("publications") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.InvalidGroup.name());
                    }
                    n3 = publications.length();
                    for (j = 0; j < n3; ++j) {
                        JSONObject pubDict;
                        JSONObject jSONObject = pubDict = publications.getJSONObject(j);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"pubDict");
                        Publication pub = PublicationKt.parsePublication((JSONObject)jSONObject);
                        group.getPublications().add(pub);
                    }
                }
                feed.getGroups().add(group);
                ++i;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

