/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.opds;

import com.github.kittinunf.fuel.Fuel;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import nl.komponents.kovenant.KovenantApi;
import nl.komponents.kovenant.Promise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.opds.OPDS2ParserError;
import org.readium.r2.opds.URLHelperKt;
import org.readium.r2.shared.Contributor;
import org.readium.r2.shared.FuelPromiseExtensionKt;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.MultilangString;
import org.readium.r2.shared.Properties;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.Subject;
import org.readium.r2.shared.metadata.BelongsTo;
import org.readium.r2.shared.opds.Facet;
import org.readium.r2.shared.opds.Feed;
import org.readium.r2.shared.opds.Group;
import org.readium.r2.shared.opds.IndirectAcquisition;
import org.readium.r2.shared.opds.OpdsMetadata;
import org.readium.r2.shared.opds.Price;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/readium/r2/opds/OPDS2Parser;", "", "()V", "Companion", "r2-opds_release"})
public final class OPDS2Parser {
    @Nullable
    private static URL feedUrl;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u001d\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b+J\u001d\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b.J\u001d\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b3J\u001d\u00104\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u00105\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020<2\u0006\u00102\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b@J\u001e\u0010A\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060Cj\u0002`D0B2\u0006\u0010\r\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006E"}, d2={"Lorg/readium/r2/opds/OPDS2Parser$Companion;", "", "()V", "feedUrl", "Ljava/net/URL;", "getFeedUrl", "()Ljava/net/URL;", "setFeedUrl", "(Ljava/net/URL;)V", "parse", "Lorg/readium/r2/shared/opds/Feed;", "jsonData", "", "url", "parseCollection", "Lorg/readium/r2/shared/Collection;", "collectionDict", "Lorg/json/JSONObject;", "parseCollection$r2_opds_release", "parseContributor", "Lorg/readium/r2/shared/Contributor;", "cDict", "parseContributor$r2_opds_release", "parseContributors", "", "contributors", "parseContributors$r2_opds_release", "parseFacets", "", "feed", "facets", "Lorg/json/JSONArray;", "parseFacets$r2_opds_release", "parseGroups", "groups", "parseGroups$r2_opds_release", "parseIndirectAcquisition", "Lorg/readium/r2/shared/opds/IndirectAcquisition;", "indirectAcquisitionDict", "parseIndirectAcquisition$r2_opds_release", "parseLink", "Lorg/readium/r2/shared/Link;", "linkDict", "parseLink$r2_opds_release", "parseLinks", "links", "parseLinks$r2_opds_release", "parseMetadata", "opdsMetadata", "Lorg/readium/r2/shared/opds/OpdsMetadata;", "metadataDict", "parseMetadata$r2_opds_release", "parseNavigation", "navLinks", "parseNavigation$r2_opds_release", "parsePublication", "Lorg/readium/r2/shared/Publication;", "pubDict", "parsePublication$r2_opds_release", "parsePublicationMetadata", "Lorg/readium/r2/shared/Metadata;", "parsePublicationMetadata$r2_opds_release", "parsePublications", "publications", "parsePublications$r2_opds_release", "parseURL", "Lnl/komponents/kovenant/Promise;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "r2-opds_release"})
    public static final class Companion {
        @Nullable
        public final URL getFeedUrl() {
            return feedUrl;
        }

        public final void setFeedUrl(@Nullable URL uRL) {
            feedUrl = uRL;
        }

        @NotNull
        public final Promise<Feed, Exception> parseURL(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.Companion.get(string, null)), (Function1)((Function1)new Function1<Triple<? extends Request, ? extends Response, ? extends byte[]>, Feed>(url){
                final /* synthetic */ URL $url;

                @NotNull
                public final Feed invoke(@NotNull Triple<Request, Response, byte[]> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Triple<Request, Response, byte[]> triple = it;
                    Request request = (Request)triple.component1();
                    Response response = (Response)triple.component2();
                    byte[] result = (byte[])triple.component3();
                    return OPDS2Parser.Companion.parse(result, this.$url);
                }
                {
                    this.$url = uRL;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Feed parse(@NotNull byte[] jsonData, @NotNull URL url) {
            Feed feed;
            block26: {
                Object object;
                JSONObject jSONObject;
                Intrinsics.checkParameterIsNotNull((Object)jsonData, (String)"jsonData");
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                this.setFeedUrl(url);
                JSONObject jSONObject2 = jSONObject;
                JSONObject jSONObject3 = jSONObject;
                String string = new String(jsonData, Charsets.UTF_8);
                jSONObject2(string);
                JSONObject topLevelDict = jSONObject3;
                JSONObject jSONObject4 = topLevelDict.getJSONObject("metadata");
                if (jSONObject4 == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.metadataNotFound.name());
                }
                JSONObject metadataDict = jSONObject4;
                String string2 = metadataDict.getString("title");
                if (string2 == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.missingTitle.name());
                }
                String title = string2;
                feed = new Feed(title);
                this.parseMetadata$r2_opds_release(feed.getMetadata(), metadataDict);
                if (topLevelDict.has("@context")) {
                    JSONArray array;
                    int n;
                    int n2;
                    if (topLevelDict.get("@context") instanceof JSONObject) {
                        List list = feed.getContext();
                        String string3 = topLevelDict.getString("@context");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"topLevelDict.getString(\"@context\")");
                        list.add(string3);
                    } else if (topLevelDict.get("@context") instanceof JSONArray && (n2 = 0) <= (n = (array = topLevelDict.getJSONArray("@context")).length() - 1)) {
                        while (true) {
                            void i;
                            String string4 = array.getString((int)i);
                            List list = feed.getContext();
                            String string5 = string4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"string");
                            list.add(string5);
                            if (i == n) break;
                            ++i;
                        }
                    }
                }
                if (topLevelDict.has("links")) {
                    Object object2 = topLevelDict.get("links");
                    if (object2 != null) {
                        object = object2;
                        Object it = object;
                        Object object3 = it;
                        if (!(object3 instanceof JSONArray)) {
                            object3 = null;
                        }
                        JSONArray jSONArray = (JSONArray)object3;
                        if (jSONArray == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                        }
                        JSONArray links = jSONArray;
                        Companion.parseLinks$r2_opds_release(feed, links);
                    }
                }
                if (topLevelDict.has("facets")) {
                    Object object4 = topLevelDict.get("facets");
                    if (object4 != null) {
                        object = object4;
                        Object it = object;
                        Object object5 = it;
                        if (!(object5 instanceof JSONArray)) {
                            object5 = null;
                        }
                        JSONArray jSONArray = (JSONArray)object5;
                        if (jSONArray == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                        }
                        JSONArray facets = jSONArray;
                        Companion.parseFacets$r2_opds_release(feed, facets);
                    }
                }
                if (topLevelDict.has("publications")) {
                    Object object6 = topLevelDict.get("publications");
                    if (object6 != null) {
                        object = object6;
                        Object it = object;
                        Object object7 = it;
                        if (!(object7 instanceof JSONArray)) {
                            object7 = null;
                        }
                        JSONArray jSONArray = (JSONArray)object7;
                        if (jSONArray == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                        }
                        JSONArray publications = jSONArray;
                        Companion.parsePublications$r2_opds_release(feed, publications);
                    }
                }
                if (topLevelDict.has("navigation")) {
                    Object object8 = topLevelDict.get("navigation");
                    if (object8 != null) {
                        object = object8;
                        Object it = object;
                        Object object9 = it;
                        if (!(object9 instanceof JSONArray)) {
                            object9 = null;
                        }
                        JSONArray jSONArray = (JSONArray)object9;
                        if (jSONArray == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                        }
                        JSONArray navigation = jSONArray;
                        Companion.parseNavigation$r2_opds_release(feed, navigation);
                    }
                }
                if (!topLevelDict.has("groups")) break block26;
                Object object10 = topLevelDict.get("groups");
                if (object10 != null) {
                    object = object10;
                    Object it = object;
                    Object object11 = it;
                    if (!(object11 instanceof JSONArray)) {
                        object11 = null;
                    }
                    JSONArray jSONArray = (JSONArray)object11;
                    if (jSONArray == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                    }
                    JSONArray groups = jSONArray;
                    Companion.parseGroups$r2_opds_release(feed, groups);
                }
            }
            return feed;
        }

        public final void parseMetadata$r2_opds_release(@NotNull OpdsMetadata opdsMetadata, @NotNull JSONObject metadataDict) {
            block11: {
                int n;
                OpdsMetadata opdsMetadata2;
                String $i$a$1$let;
                Object it;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)opdsMetadata, (String)"opdsMetadata");
                Intrinsics.checkParameterIsNotNull((Object)metadataDict, (String)"metadataDict");
                if (metadataDict.has("title")) {
                    Object object2 = metadataDict.get("title");
                    if (object2 != null) {
                        it = object = object2;
                        opdsMetadata.setTitle(it.toString());
                    }
                }
                if (metadataDict.has("numberOfItems")) {
                    Object object3 = metadataDict.get("numberOfItems");
                    if (object3 != null) {
                        it = object = object3;
                        $i$a$1$let = it.toString();
                        opdsMetadata2 = opdsMetadata;
                        n = Integer.parseInt($i$a$1$let);
                        opdsMetadata2.setNumberOfItems(Integer.valueOf(n));
                    }
                }
                if (metadataDict.has("itemsPerPage")) {
                    Object object4 = metadataDict.get("itemsPerPage");
                    if (object4 != null) {
                        it = object = object4;
                        $i$a$1$let = it.toString();
                        opdsMetadata2 = opdsMetadata;
                        n = Integer.parseInt($i$a$1$let);
                        opdsMetadata2.setItemsPerPage(Integer.valueOf(n));
                    }
                }
                if (metadataDict.has("modified")) {
                    Object object5 = metadataDict.get("modified");
                    if (object5 != null) {
                        it = object = object5;
                        opdsMetadata.setModified(new DateTime((Object)it.toString()).toDate());
                    }
                }
                if (metadataDict.has("@type")) {
                    Object object6 = metadataDict.get("@type");
                    if (object6 != null) {
                        it = object = object6;
                        opdsMetadata.setRdfType(it.toString());
                    }
                }
                if (!metadataDict.has("currentPage")) break block11;
                Object object7 = metadataDict.get("currentPage");
                if (object7 != null) {
                    it = object = object7;
                    String string = it.toString();
                    opdsMetadata2 = opdsMetadata;
                    n = Integer.parseInt(string);
                    opdsMetadata2.setCurrentPage(Integer.valueOf(n));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Link parseLink$r2_opds_release(@NotNull JSONObject linkDict) {
            Intrinsics.checkParameterIsNotNull((Object)linkDict, (String)"linkDict");
            Link link = new Link();
            if (linkDict.has("title")) {
                link.setTitle(linkDict.getString("title"));
            }
            if (linkDict.has("href")) {
                String string = linkDict.getString("href");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                link.setHref(URLHelperKt.getAbsolute(string, String.valueOf(this.getFeedUrl())));
            }
            if (linkDict.has("type")) {
                link.setTypeLink(linkDict.getString("type"));
            }
            if (linkDict.has("rel")) {
                JSONArray array;
                int n;
                int n2;
                if (linkDict.get("rel") instanceof String) {
                    List list = link.getRel();
                    String string = linkDict.getString("rel");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkDict.getString(\"rel\")");
                    list.add(string);
                } else if (linkDict.get("rel") instanceof JSONArray && (n2 = 0) <= (n = (array = linkDict.getJSONArray("rel")).length() - 1)) {
                    while (true) {
                        void i;
                        String string = array.getString((int)i);
                        List list = link.getRel();
                        String string2 = string;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
                        list.add(string2);
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            if (linkDict.has("height")) {
                link.setHeight(linkDict.getInt("height"));
            }
            if (linkDict.has("width")) {
                link.setWidth(linkDict.getInt("width"));
            }
            if (linkDict.has("bitrate")) {
                link.setBitrate(Integer.valueOf(linkDict.getInt("bitrate")));
            }
            if (linkDict.has("duration")) {
                link.setDuration(Double.valueOf(linkDict.getDouble("duration")));
            }
            if (linkDict.has("properties")) {
                Properties properties = new Properties();
                JSONObject propertiesDict = linkDict.getJSONObject("properties");
                if (propertiesDict.has("numberOfItems")) {
                    properties.setNumberOfItems(Integer.valueOf(propertiesDict.getInt("numberOfItems")));
                }
                if (propertiesDict.has("indirectAcquisition")) {
                    JSONArray jSONArray = propertiesDict.getJSONArray("indirectAcquisition");
                    if (jSONArray == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                    }
                    JSONArray acquisitions = jSONArray;
                    int string = 0;
                    int n = acquisitions.length() - 1;
                    if (string <= n) {
                        while (true) {
                            void i;
                            JSONObject acquisition;
                            JSONObject jSONObject = acquisition = acquisitions.getJSONObject((int)i);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"acquisition");
                            IndirectAcquisition indirectAcquisition = this.parseIndirectAcquisition$r2_opds_release(jSONObject);
                            properties.getIndirectAcquisition().add(indirectAcquisition);
                            if (i == n) break;
                            ++i;
                        }
                    }
                }
                if (propertiesDict.has("price")) {
                    JSONObject priceDict = propertiesDict.getJSONObject("price");
                    Object object = priceDict.get("currency");
                    if (!(object instanceof String)) {
                        object = null;
                    }
                    String currency = (String)object;
                    Object object2 = priceDict.get("value");
                    if (!(object2 instanceof Double)) {
                        object2 = null;
                    }
                    Double value = (Double)object2;
                    if (priceDict == null || currency == null || value == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                    }
                    Price price = new Price(currency, value.doubleValue());
                    properties.setPrice(price);
                }
            }
            if (linkDict.has("children")) {
                JSONObject jSONObject = linkDict.getJSONObject("children");
                if (jSONObject == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.invalidLink.name());
                }
                JSONObject childLinkDict = jSONObject;
                Link childLink = this.parseLink$r2_opds_release(childLinkDict);
                link.getChildren().add(childLink);
            }
            return link;
        }

        @NotNull
        public final IndirectAcquisition parseIndirectAcquisition$r2_opds_release(@NotNull JSONObject indirectAcquisitionDict) {
            JSONObject childDict;
            Intrinsics.checkParameterIsNotNull((Object)indirectAcquisitionDict, (String)"indirectAcquisitionDict");
            Object object = indirectAcquisitionDict.get("type");
            if (!(object instanceof String)) {
                object = null;
            }
            String string = (String)object;
            if (string == null) {
                throw (Throwable)new Exception(OPDS2ParserError.invalidIndirectAcquisition.name());
            }
            String indirectAcquisitionType = string;
            IndirectAcquisition indirectAcquisition = new IndirectAcquisition(indirectAcquisitionType);
            JSONObject jSONObject = childDict = indirectAcquisitionDict.getJSONObject("child");
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"childDict");
            IndirectAcquisition child = this.parseIndirectAcquisition$r2_opds_release(jSONObject);
            indirectAcquisition.getChild().add(child);
            return indirectAcquisition;
        }

        /*
         * WARNING - void declaration
         */
        public final void parseFacets$r2_opds_release(@NotNull Feed feed, @NotNull JSONArray facets) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)facets, (String)"facets");
            int n = 0;
            int n2 = facets.length() - 1;
            if (n <= n2) {
                while (true) {
                    String title;
                    JSONObject metadata;
                    void i;
                    JSONObject facetDict;
                    if ((facetDict = facets.getJSONObject((int)i)).getJSONObject("metadata") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidFacet.name());
                    }
                    Object object = metadata.get("title");
                    if (!(object instanceof String)) {
                        object = null;
                    }
                    if ((String)object == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidFacet.name());
                    }
                    Facet facet = new Facet(title);
                    this.parseMetadata$r2_opds_release(facet.getMetadata(), metadata);
                    if (facetDict.has("links")) {
                        JSONArray links;
                        if (facetDict.getJSONArray("links") == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidFacet.name());
                        }
                        int n3 = 0;
                        int n4 = links.length() - 1;
                        if (n3 <= n4) {
                            while (true) {
                                void k;
                                JSONObject linkDict;
                                JSONObject jSONObject = linkDict = links.getJSONObject((int)k);
                                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                                Link link = this.parseLink$r2_opds_release(jSONObject);
                                facet.getLinks().add(link);
                                if (k == n4) break;
                                ++k;
                            }
                        }
                    }
                    feed.getFacets().add(facet);
                    if (i == n2) break;
                    ++i;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void parseLinks$r2_opds_release(@NotNull Feed feed, @NotNull JSONArray links) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)links, (String)"links");
            int n = 0;
            int n2 = links.length() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    JSONObject linkDict;
                    JSONObject jSONObject = linkDict = links.getJSONObject((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                    Link link = this.parseLink$r2_opds_release(jSONObject);
                    feed.getLinks().add(link);
                    if (i == n2) break;
                    ++i;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void parsePublications$r2_opds_release(@NotNull Feed feed, @NotNull JSONArray publications) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)publications, (String)"publications");
            int n = 0;
            int n2 = publications.length() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    JSONObject pubDict;
                    JSONObject jSONObject = pubDict = publications.getJSONObject((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"pubDict");
                    Publication pub = this.parsePublication$r2_opds_release(jSONObject);
                    feed.getPublications().add(pub);
                    if (i == n2) break;
                    ++i;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void parseNavigation$r2_opds_release(@NotNull Feed feed, @NotNull JSONArray navLinks) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)navLinks, (String)"navLinks");
            int n = 0;
            int n2 = navLinks.length() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    JSONObject navDict;
                    JSONObject jSONObject = navDict = navLinks.getJSONObject((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"navDict");
                    Link link = this.parseLink$r2_opds_release(jSONObject);
                    feed.getNavigation().add(link);
                    if (i == n2) break;
                    ++i;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void parseGroups$r2_opds_release(@NotNull Feed feed, @NotNull JSONArray groups) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)groups, (String)"groups");
            int n = 0;
            int n2 = groups.length() - 1;
            if (n <= n2) {
                while (true) {
                    Link link;
                    int j;
                    JSONObject linkDict;
                    int n3;
                    JSONArray links;
                    String title;
                    JSONObject metadata;
                    void i;
                    JSONObject groupDict;
                    if ((groupDict = groups.getJSONObject((int)i)).getJSONObject("metadata") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidGroup.name());
                    }
                    if (metadata.getString("title") == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidGroup.name());
                    }
                    Group group = new Group(title);
                    this.parseMetadata$r2_opds_release(group.getMetadata(), metadata);
                    if (groupDict.has("links")) {
                        if (groupDict.getJSONArray("links") == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidGroup.name());
                        }
                        int n4 = 0;
                        n3 = links.length() - 1;
                        if (n4 <= n3) {
                            while (true) {
                                JSONObject jSONObject = linkDict = links.getJSONObject(j);
                                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                                link = this.parseLink$r2_opds_release(jSONObject);
                                group.getLinks().add(link);
                                if (j == n3) break;
                                ++j;
                            }
                        }
                    }
                    if (groupDict.has("navigation")) {
                        if (groupDict.getJSONArray("navigation") == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidGroup.name());
                        }
                        j = 0;
                        n3 = links.length() - 1;
                        if (j <= n3) {
                            while (true) {
                                JSONObject jSONObject = linkDict = links.getJSONObject(j);
                                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                                link = this.parseLink$r2_opds_release(jSONObject);
                                group.getNavigation().add(link);
                                if (j == n3) break;
                                ++j;
                            }
                        }
                    }
                    if (groupDict.has("publications")) {
                        JSONArray publications;
                        if (groupDict.getJSONArray("publications") == null) {
                            throw (Throwable)new Exception(OPDS2ParserError.invalidGroup.name());
                        }
                        j = 0;
                        n3 = publications.length() - 1;
                        if (j <= n3) {
                            while (true) {
                                JSONObject pubDict;
                                JSONObject jSONObject = pubDict = publications.getJSONObject(j);
                                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"pubDict");
                                Publication pub = this.parsePublication$r2_opds_release(jSONObject);
                                group.getPublications().add(pub);
                                if (j == n3) break;
                                ++j;
                            }
                        }
                    }
                    feed.getGroups().add(group);
                    if (i == n2) break;
                    ++i;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Publication parsePublication$r2_opds_release(@NotNull JSONObject pubDict) {
            Link link;
            JSONObject linkDict;
            int n;
            JSONArray links;
            Object it;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)pubDict, (String)"pubDict");
            Publication p = new Publication();
            if (pubDict.has("numberOfItems")) {
                Object object2 = pubDict.get("numberOfItems");
                if (object2 != null) {
                    object = object2;
                    it = object;
                    Object object3 = it;
                    if (!(object3 instanceof JSONObject)) {
                        object3 = null;
                    }
                    JSONObject jSONObject = (JSONObject)object3;
                    if (jSONObject == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidPublication.name());
                    }
                    JSONObject metadataDict = jSONObject;
                    org.readium.r2.shared.Metadata metadata = Companion.parsePublicationMetadata$r2_opds_release(metadataDict);
                    p.setMetadata(metadata);
                }
            }
            if (pubDict.has("links")) {
                Object object4 = pubDict.get("links");
                if (object4 != null) {
                    object = object4;
                    it = object;
                    Object object5 = it;
                    if (!(object5 instanceof JSONArray)) {
                        object5 = null;
                    }
                    JSONArray jSONArray = (JSONArray)object5;
                    if (jSONArray == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidPublication.name());
                    }
                    links = jSONArray;
                    int metadata = 0;
                    n = links.length() - 1;
                    if (metadata <= n) {
                        while (true) {
                            void i;
                            JSONObject jSONObject = linkDict = links.getJSONObject((int)i);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                            link = Companion.parseLink$r2_opds_release(jSONObject);
                            p.getLinks().add(link);
                            if (i == n) break;
                            ++i;
                        }
                    }
                }
            }
            if (pubDict.has("images")) {
                Object object6 = pubDict.get("images");
                if (object6 != null) {
                    object = object6;
                    it = object;
                    Object object7 = it;
                    if (!(object7 instanceof JSONArray)) {
                        object7 = null;
                    }
                    JSONArray jSONArray = (JSONArray)object7;
                    if (jSONArray == null) {
                        throw (Throwable)new Exception(OPDS2ParserError.invalidPublication.name());
                    }
                    links = jSONArray;
                    int i = 0;
                    n = links.length() - 1;
                    if (i <= n) {
                        while (true) {
                            JSONObject jSONObject = linkDict = links.getJSONObject(i);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                            link = Companion.parseLink$r2_opds_release(jSONObject);
                            p.getImages().add(link);
                            if (i == n) break;
                            ++i;
                        }
                    }
                }
            }
            return p;
        }

        @NotNull
        public final Contributor parseContributor$r2_opds_release(@NotNull JSONObject cDict) {
            Intrinsics.checkParameterIsNotNull((Object)cDict, (String)"cDict");
            Contributor c = new Contributor();
            if (cDict.has("name")) {
                if (cDict.get("name") instanceof String) {
                    c.getMultilangName().setSingleString(cDict.getString("name"));
                } else if (cDict.get("name") instanceof JSONObject) {
                    JSONObject array;
                    JSONObject jSONObject = array = cDict.getJSONObject("name");
                    if (jSONObject == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                    }
                    c.getMultilangName().setMultiString(TypeIntrinsics.asMutableMap((Object)jSONObject));
                }
            }
            if (cDict.has("identifier")) {
                c.setIdentifier(cDict.getString("identifier"));
            }
            if (cDict.has("sort_as")) {
                c.setSortAs(cDict.getString("sort_as"));
            }
            if (cDict.has("role")) {
                List list = c.getRoles();
                String string = cDict.getString("role");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cDict.getString(\"role\")");
                list.add(string);
            }
            if (cDict.has("links")) {
                JSONObject linkDict = cDict.getJSONObject("links");
                List list = c.getLinks();
                JSONObject jSONObject = linkDict;
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"linkDict");
                list.add(this.parseLink$r2_opds_release(jSONObject));
            }
            return c;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Contributor> parseContributors$r2_opds_release(@NotNull Object contributors) {
            int n;
            int c3;
            Intrinsics.checkParameterIsNotNull((Object)contributors, (String)"contributors");
            List result = new ArrayList();
            if (contributors instanceof String) {
                Contributor c2 = new Contributor();
                c2.getMultilangName().setSingleString((String)contributors);
                result.add(c2);
            } else if (contributors instanceof JSONObject) {
                Contributor c3 = this.parseContributor$r2_opds_release((JSONObject)contributors);
                result.add(c3);
            } else if (contributors instanceof JSONArray && (c3 = 0) <= (n = ((JSONArray)contributors).length() - 1)) {
                while (true) {
                    void i;
                    JSONObject obj;
                    JSONObject jSONObject = obj = ((JSONArray)contributors).getJSONObject((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"obj");
                    Contributor c4 = this.parseContributor$r2_opds_release(jSONObject);
                    result.add(c4);
                    if (i == n) break;
                    ++i;
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final org.readium.r2.shared.Collection parseCollection$r2_opds_release(@NotNull JSONObject collectionDict) {
            Intrinsics.checkParameterIsNotNull((Object)collectionDict, (String)"collectionDict");
            Object object = collectionDict.get("name");
            if (!(object instanceof String)) {
                object = null;
            }
            String string = (String)object;
            if (string == null) {
                throw (Throwable)new Exception(OPDS2ParserError.invalidCollection.name());
            }
            String name = string;
            org.readium.r2.shared.Collection c = new org.readium.r2.shared.Collection(name);
            if (collectionDict.has("sort_as")) {
                c.setSortAs(collectionDict.getString("sort_as"));
            }
            if (collectionDict.has("identifier")) {
                c.setIdentifier(collectionDict.getString("identifier"));
            }
            if (collectionDict.has("position")) {
                c.setPosition(Double.valueOf(collectionDict.getDouble("position")));
            }
            if (collectionDict.has("links")) {
                JSONArray jSONArray = collectionDict.getJSONArray("links");
                if (jSONArray == null) {
                    throw (Throwable)new Exception(OPDS2ParserError.invalidCollection.name());
                }
                JSONArray links = jSONArray;
                int n = 0;
                int n2 = links.length() - 1;
                if (n <= n2) {
                    while (true) {
                        void i;
                        JSONObject link = links.getJSONObject((int)i);
                        List list = c.getLinks();
                        JSONObject jSONObject = link;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"link");
                        list.add(this.parseLink$r2_opds_release(jSONObject));
                        if (i == n2) break;
                        ++i;
                    }
                }
            }
            return c;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final org.readium.r2.shared.Metadata parsePublicationMetadata$r2_opds_release(@NotNull JSONObject metadataDict) {
            void i;
            JSONArray subjDict;
            int n;
            int n2;
            Intrinsics.checkParameterIsNotNull((Object)metadataDict, (String)"metadataDict");
            org.readium.r2.shared.Metadata m = new org.readium.r2.shared.Metadata();
            if (metadataDict.has("title")) {
                m.setMultilangTitle(new MultilangString());
                MultilangString multilangString = m.getMultilangTitle();
                if (multilangString != null) {
                    multilangString.setSingleString(metadataDict.getString("title"));
                }
            }
            if (metadataDict.has("identifier")) {
                String string = metadataDict.getString("identifier");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metadataDict.getString(\"identifier\")");
                m.setIdentifier(string);
            }
            if (metadataDict.has("@type")) {
                m.setRdfType(metadataDict.getString("@type"));
            } else if (metadataDict.has("type")) {
                m.setRdfType(metadataDict.getString("type"));
            }
            if (metadataDict.has("modified")) {
                m.setModified(new DateTime((Object)metadataDict.getString("modified")).toDate());
            }
            if (metadataDict.has("author")) {
                List list = m.getAuthors();
                Object object = metadataDict.get("author");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"author\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("translator")) {
                List list = m.getTranslators();
                Object object = metadataDict.get("translator");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"translator\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("editor")) {
                List list = m.getEditors();
                Object object = metadataDict.get("editor");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"editor\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("artist")) {
                List list = m.getArtists();
                Object object = metadataDict.get("artist");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"artist\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("illustrator")) {
                List list = m.getIllustrators();
                Object object = metadataDict.get("illustrator");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"illustrator\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("letterer")) {
                List list = m.getLetterers();
                Object object = metadataDict.get("letterer");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"letterer\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("penciler")) {
                List list = m.getPencilers();
                Object object = metadataDict.get("penciler");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"penciler\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("colorist")) {
                List list = m.getColorists();
                Object object = metadataDict.get("colorist");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"colorist\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("inker")) {
                List list = m.getInkers();
                Object object = metadataDict.get("inker");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"inker\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("narrator")) {
                List list = m.getNarrators();
                Object object = metadataDict.get("narrator");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"narrator\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("contributor")) {
                List list = m.getContributors();
                Object object = metadataDict.get("contributor");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"contributor\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("publisher")) {
                List list = m.getPublishers();
                Object object = metadataDict.get("publisher");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"publisher\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("imprint")) {
                List list = m.getImprints();
                Object object = metadataDict.get("imprint");
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"imprint\")");
                list.addAll((Collection)this.parseContributors$r2_opds_release(object));
            }
            if (metadataDict.has("published")) {
                m.setPublicationDate(metadataDict.getString("published"));
            }
            if (metadataDict.has("description")) {
                m.setDescription(metadataDict.getString("description"));
            }
            if (metadataDict.has("source")) {
                m.setSource(metadataDict.getString("source"));
            }
            if (metadataDict.has("rights")) {
                m.setRights(metadataDict.getString("rights"));
            }
            if (metadataDict.has("subject") && (n2 = 0) <= (n = (subjDict = metadataDict.getJSONArray("subject")).length() - 1)) {
                while (true) {
                    JSONObject sub = subjDict.getJSONObject((int)i);
                    Subject subject = new Subject();
                    if (sub.has("name")) {
                        subject.setName(sub.getString("name"));
                    }
                    if (sub.has("sort_as")) {
                        subject.setSortAs(sub.getString("sort_as"));
                    }
                    if (sub.has("scheme")) {
                        subject.setScheme(sub.getString("scheme"));
                    }
                    if (sub.has("code")) {
                        subject.setCode(sub.getString("code"));
                    }
                    m.getSubjects().add(subject);
                    if (i == n) break;
                    ++i;
                }
            }
            if (metadataDict.has("belongs_to")) {
                JSONObject belongsDict = metadataDict.getJSONObject("belongs_to");
                BelongsTo belongs = new BelongsTo();
                if (belongsDict.has("series")) {
                    JSONArray array;
                    int n3;
                    int sub;
                    if (belongsDict.get("series") instanceof JSONObject) {
                        Object object = m.getBelongsTo();
                        if (object != null && (object = object.getSeries()) != null) {
                            String string = belongsDict.getString("series");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"belongsDict.getString(\"series\")");
                            object.add(new org.readium.r2.shared.Collection(string));
                        }
                    } else if (belongsDict.get("series") instanceof JSONArray && (sub = 0) <= (n3 = (array = belongsDict.getJSONArray("series")).length() - 1)) {
                        while (true) {
                            void i2;
                            String string = array.getString((int)i2);
                            Object object = m.getBelongsTo();
                            if (object != null && (object = object.getSeries()) != null) {
                                String string2 = string;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
                                object.add(new org.readium.r2.shared.Collection(string2));
                            }
                            if (i2 == n3) break;
                            ++i2;
                        }
                    }
                }
                if (belongsDict.has("collection")) {
                    JSONArray array;
                    int n4;
                    int i2;
                    if (belongsDict.get("collection") instanceof String) {
                        Object object = m.getBelongsTo();
                        if (object != null && (object = object.getCollection()) != null) {
                            String string = belongsDict.getString("collection");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"belongsDict.getString(\"collection\")");
                            object.add(new org.readium.r2.shared.Collection(string));
                        }
                    } else if (belongsDict.get("collection") instanceof JSONObject) {
                        List list = belongs.getSeries();
                        JSONObject jSONObject = belongsDict.getJSONObject("collection");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"belongsDict.getJSONObject(\"collection\")");
                        list.add(this.parseCollection$r2_opds_release(jSONObject));
                    } else if (belongsDict.get("collection") instanceof JSONArray && (i2 = 0) <= (n4 = (array = belongsDict.getJSONArray("collection")).length() - 1)) {
                        while (true) {
                            JSONObject obj = array.getJSONObject(i2);
                            List list = belongs.getSeries();
                            JSONObject jSONObject = obj;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"obj");
                            list.add(this.parseCollection$r2_opds_release(jSONObject));
                            if (i2 == n4) break;
                            ++i2;
                        }
                    }
                }
                m.setBelongsTo(belongs);
            }
            if (metadataDict.has("duration")) {
                m.setDuration(Integer.valueOf(metadataDict.getInt("duration")));
            }
            if (metadataDict.has("language")) {
                JSONArray array;
                int belongs;
                if (metadataDict.get("language") instanceof JSONObject) {
                    List list = m.getLanguages();
                    String string = metadataDict.getString("language");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metadataDict.getString(\"language\")");
                    list.add(string);
                } else if (metadataDict.get("language") instanceof JSONArray && (belongs = 0) <= (n = (array = metadataDict.getJSONArray("language")).length() - 1)) {
                    while (true) {
                        String string = array.getString((int)i);
                        List list = m.getLanguages();
                        String string3 = string;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"string");
                        list.add(string3);
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            return m;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

