/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.opds;

import com.github.kittinunf.fuel.Fuel;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.komponents.kovenant.KovenantApi;
import nl.komponents.kovenant.Promise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.readium.r2.opds.MimeTypeParameters;
import org.readium.r2.opds.OPDSParser;
import org.readium.r2.opds.OPDSParserError;
import org.readium.r2.shared.Contributor;
import org.readium.r2.shared.FuelPromiseExtensionKt;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Metadata;
import org.readium.r2.shared.MultilangString;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.Subject;
import org.readium.r2.shared.XmlParser.Node;
import org.readium.r2.shared.XmlParser.XmlParser;
import org.readium.r2.shared.opds.Facet;
import org.readium.r2.shared.opds.Feed;
import org.readium.r2.shared.opds.Group;
import org.readium.r2.shared.opds.IndirectAcquisition;
import org.readium.r2.shared.opds.OpdsMetadata;
import org.readium.r2.shared.opds.Price;

@kotlin.Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/readium/r2/opds/OPDSParser;", "", "()V", "Companion", "r2-opds_release"})
public final class OPDSParser {
    public static final Companion Companion = new Companion(null);

    @kotlin.Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ%\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000eJ%\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0012J \u0010\u0013\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00142\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0000\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nJ\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00142\u0006\u0010'\u001a\u00020(\u00a8\u0006)"}, d2={"Lorg/readium/r2/opds/OPDSParser$Companion;", "", "()V", "addFacet", "", "feed", "Lorg/readium/r2/shared/opds/Feed;", "link", "Lorg/readium/r2/shared/Link;", "title", "", "addFacet$r2_opds_release", "addNavigationInGroup", "collectionLink", "addNavigationInGroup$r2_opds_release", "addPublicationInGroup", "publication", "Lorg/readium/r2/shared/Publication;", "addPublicationInGroup$r2_opds_release", "fetchOpenSearchTemplate", "Lnl/komponents/kovenant/Promise;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "parse", "xmlData", "", "parseEntry", "entry", "Lorg/readium/r2/shared/XmlParser/Node;", "parseEntry$r2_opds_release", "parseIndirectAcquisition", "", "Lorg/readium/r2/shared/opds/IndirectAcquisition;", "children", "parseIndirectAcquisition$r2_opds_release", "parseMimeType", "Lorg/readium/r2/opds/MimeTypeParameters;", "mimeTypeString", "parseURL", "url", "Ljava/net/URL;", "r2-opds_release"})
    public static final class Companion {
        @NotNull
        public final Promise<Feed, Exception> parseURL(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.Companion.get(string, null)), (Function1)parseURL.1.INSTANCE);
        }

        @NotNull
        public final Feed parse(@NotNull byte[] xmlData) {
            Node it;
            Object object;
            String itemsPerPage;
            Object object2;
            String it2;
            String totalResults;
            String it3;
            String tmpDate;
            Intrinsics.checkParameterIsNotNull((Object)xmlData, (String)"xmlData");
            XmlParser document = new XmlParser();
            byte[] byArray = xmlData;
            XmlParser xmlParser = document;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            xmlParser.parseXml((InputStream)byteArrayInputStream);
            Node root = document.root();
            Object object3 = root.getFirst("title");
            if (object3 == null || (object3 = object3.getText()) == null) {
                throw (Throwable)new Exception(OPDSParserError.missingTitle.name());
            }
            Object title = object3;
            Feed feed = new Feed(((String)title).toString());
            Node node = root.getFirst("updated");
            String string = tmpDate = node != null ? node.getText() : null;
            if (string != null) {
                String string2;
                it3 = string2 = string;
                Date date = new DateTime((Object)it3).toDate();
                feed.getMetadata().setModified(date);
            }
            Node node2 = root.getFirst("TotalResults");
            String string3 = totalResults = node2 != null ? node2.getText() : null;
            if (string3 != null) {
                it2 = it3 = string3;
                String $i$a$1$let = totalResults.toString();
                object2 = feed.getMetadata();
                int n = Integer.parseInt($i$a$1$let);
                object2.setNumberOfItems(Integer.valueOf(n));
            }
            Node node3 = root.getFirst("ItemsPerPage");
            String string4 = itemsPerPage = node3 != null ? node3.getText() : null;
            if (string4 != null) {
                String it4 = it2 = string4;
                object2 = itemsPerPage.toString();
                OpdsMetadata opdsMetadata = feed.getMetadata();
                int $i$a$2$let = Integer.parseInt((String)object2);
                opdsMetadata.setItemsPerPage(Integer.valueOf($i$a$2$let));
            }
            List list = root.get("entry");
            if (list == null) {
                return feed;
            }
            List entries = list;
            for (Node entry : entries) {
                String facetElementCountStr;
                boolean isNavigation = true;
                Link collectionLink = new Link();
                List links = entry.get("link");
                if (links != null) {
                    List list2;
                    List it5 = list2;
                    object = links.iterator();
                    while (object.hasNext()) {
                        Node link = (Node)object.next();
                        String rel = (String)link.getAttributes().get("rel");
                        if (rel != null) {
                            String string5;
                            String it6 = string5;
                            if (StringsKt.contains$default((CharSequence)rel, (CharSequence)"http://opds-spec.org/acquisition", (boolean)false, (int)2, null)) {
                                isNavigation = false;
                            }
                            if (!Intrinsics.areEqual((Object)rel, (Object)"collection") && !Intrinsics.areEqual((Object)rel, (Object)"http://opds-spec.org/group")) continue;
                            collectionLink.getRel().add("collection");
                            collectionLink.setHref((String)link.getAttributes().get("href"));
                            collectionLink.setTitle((String)link.getAttributes().get("title"));
                        }
                    }
                }
                if (!isNavigation) {
                    Publication publication = this.parseEntry$r2_opds_release(entry);
                    if (collectionLink.getHref() != null) {
                        this.addPublicationInGroup$r2_opds_release(feed, publication, collectionLink);
                        continue;
                    }
                    feed.getPublications().add(publication);
                    continue;
                }
                Link newLink = new Link();
                Node entryTitle = entry.getFirst("title");
                if (entryTitle != null) {
                    it = object;
                    newLink.setTitle(entryTitle.getText());
                }
                Node link = entry.getFirst("link");
                if (link == null) continue;
                Node it7 = it;
                String rel = (String)link.getAttributes().get("rel");
                if (rel != null) {
                    newLink.getRel().add(rel);
                }
                if ((facetElementCountStr = (String)link.getAttributes().get("thr:count")) != null) {
                    String string6;
                    String it8;
                    String string7 = it8 = string6;
                    int facetElementCount = Integer.parseInt(string7);
                    newLink.getProperties().setNumberOfItems(Integer.valueOf(facetElementCount));
                }
                newLink.setTypeLink((String)link.getAttributes().get("type"));
                newLink.setHref((String)link.getAttributes().get("href"));
                if (collectionLink.getHref() != null) {
                    Companion.addNavigationInGroup$r2_opds_release(feed, newLink, collectionLink);
                    continue;
                }
                feed.getNavigation().add(newLink);
            }
            List links = root.get("link");
            if (links != null) {
                for (Node link : links) {
                    String facetGroupName;
                    Link newLink = new Link();
                    newLink.setHref((String)link.getAttributes().get("href"));
                    newLink.setTitle((String)link.getAttributes().get("title"));
                    newLink.setTypeLink((String)link.getAttributes().get("type"));
                    String rel = (String)link.getAttributes().get("rel");
                    if (rel != null) {
                        newLink.getRel().add(rel);
                    }
                    if ((facetGroupName = (String)link.getAttributes().get("opds:facetGroup")) != null && newLink.getRel().contains("http://opds-spec.org/facet")) {
                        String facetElementCountStr = (String)link.getAttributes().get("thr:count");
                        if (facetElementCountStr != null) {
                            Node node4 = it = object;
                            int facetElementCount = Integer.parseInt((String)node4);
                            newLink.getProperties().setNumberOfItems(Integer.valueOf(facetElementCount));
                        }
                        this.addFacet$r2_opds_release(feed, newLink, facetGroupName);
                        continue;
                    }
                    feed.getLinks().add(newLink);
                }
            }
            return feed;
        }

        @NotNull
        public final Publication parseEntry(@NotNull byte[] xmlData) {
            Intrinsics.checkParameterIsNotNull((Object)xmlData, (String)"xmlData");
            XmlParser document = new XmlParser();
            byte[] byArray = xmlData;
            XmlParser xmlParser = document;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            xmlParser.parseXml((InputStream)byteArrayInputStream);
            Node root = document.root();
            return this.parseEntry$r2_opds_release(root);
        }

        @NotNull
        public final MimeTypeParameters parseMimeType(@NotNull String mimeTypeString) {
            Intrinsics.checkParameterIsNotNull((Object)mimeTypeString, (String)"mimeTypeString");
            List substrings = StringsKt.split$default((CharSequence)mimeTypeString, (String[])new String[]{";"}, (boolean)false, (int)0, (int)6, null);
            CharSequence charSequence = (CharSequence)substrings.get(0);
            String string = "\\s";
            string = new Regex(string);
            String string2 = "";
            String type = string.replace(charSequence, string2);
            Map params = new LinkedHashMap();
            for (String defn : CollectionsKt.drop((Iterable)substrings, (int)0)) {
                List halves = StringsKt.split$default((CharSequence)defn, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                CharSequence charSequence2 = (CharSequence)halves.get(0);
                Object object = "\\s";
                object = new Regex((String)object);
                String string3 = "";
                String paramName = object.replace(charSequence2, string3);
                object = (CharSequence)halves.get(1);
                string3 = "\\s";
                string3 = new Regex(string3);
                String string4 = "";
                String paramValue = string3.replace((CharSequence)object, string4);
                object = params;
                string3 = paramValue;
                object.put(paramName, string3);
            }
            return new MimeTypeParameters(type, params);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Promise<String, Exception> fetchOpenSearchTemplate(@NotNull Feed feed) {
            void selfMimeType;
            Object it;
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            URL openSearchURL = null;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Object object = feed.getLinks().iterator();
            while (object.hasNext()) {
                String it2;
                String string;
                Link link = (Link)object.next();
                if (Intrinsics.areEqual((Object)((String)link.getRel().get(0)), (Object)"self")) {
                    if (link.getTypeLink() != null) {
                        it2 = string;
                        selfMimeType.element = it2;
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)((String)link.getRel().get(0)), (Object)"search")) continue;
                if (link.getHref() == null) continue;
                it2 = string;
                openSearchURL = new URL(it2);
            }
            URL uRL = openSearchURL;
            Object unwrappedURL = uRL != null ? (it = (object = uRL)) : null;
            return KovenantApi.then((Promise)FuelPromiseExtensionKt.promise((Request)Fuel.Companion.get(String.valueOf(unwrappedURL), null)), (Function1)new Function1((Ref.ObjectRef)selfMimeType){
                final /* synthetic */ Ref.ObjectRef $selfMimeType;

                @Nullable
                public final Void invoke(@NotNull Triple<Request, Response, byte[]> it) {
                    block4: {
                        String string;
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        Triple<Request, Response, byte[]> triple = it;
                        Request request = (Request)triple.component1();
                        Response response = (Response)triple.component2();
                        byte[] result = (byte[])triple.component3();
                        XmlParser document = new XmlParser();
                        byte[] byArray = result;
                        XmlParser xmlParser = document;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        xmlParser.parseXml((InputStream)byteArrayInputStream);
                        List urls = document.root().get("Url");
                        Node typeAndProfileMatch = null;
                        Node typeMatch = null;
                        String string2 = (String)this.$selfMimeType.element;
                        if (string2 == null) break block4;
                        String it2 = string = string2;
                        MimeTypeParameters selfMimeParams = OPDSParser.Companion.parseMimeType(it2);
                        List list = urls;
                        if (list != null) {
                            Node node;
                            List list2;
                            List it3 = list2 = list;
                            for (Node url : urls) {
                                String urlMimeType = (String)url.getAttributes().get("type");
                                if (urlMimeType == null) continue;
                                MimeTypeParameters otherMimeParams = OPDSParser.Companion.parseMimeType(urlMimeType);
                                if (!Intrinsics.areEqual((Object)selfMimeParams.getType(), (Object)otherMimeParams.getType())) continue;
                                if (typeMatch == null) {
                                    typeMatch = url;
                                }
                                if (!Intrinsics.areEqual((Object)selfMimeParams.getParameters().get("profile"), (Object)otherMimeParams.getParameters().get("profile"))) continue;
                                typeAndProfileMatch = url;
                                break;
                            }
                            if ((node = typeAndProfileMatch) == null && (node = typeMatch) == null) {
                                node = (Node)urls.get(0);
                            }
                            Node match = node;
                            String template = (String)match.getAttributes().get("template");
                        }
                    }
                    return null;
                }
                {
                    this.$selfMimeType = objectRef;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Publication parseEntry$r2_opds_release(@NotNull Node entry) {
            Unit unit;
            List links;
            Unit unit2;
            Node content;
            Unit unit3;
            Object it;
            List authors;
            Unit unit4;
            Object it2;
            List categories;
            Boolean bl;
            Object it3;
            List publisher;
            Unit unit5;
            String it4;
            Object it5;
            List rights;
            Unit unit6;
            Object it6;
            Node published;
            Unit unit7;
            Node tmpDate;
            Unit unit8;
            Object object;
            Object it7;
            Object object2;
            Iterable destination$iv$iv;
            Object it8;
            List languages;
            Object it9;
            Object $receiver;
            Unit unit9;
            Node identifier;
            Unit unit10;
            Object it10;
            Node entryTitle;
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            Publication publication = new Publication();
            Metadata metadata = new Metadata();
            publication.setMetadata(metadata);
            Node node = entryTitle = entry.getFirst("title");
            if (node != null) {
                Node node2;
                it10 = node2 = node;
                if (metadata.getMultilangTitle() == null) {
                    metadata.setMultilangTitle(new MultilangString());
                }
                MultilangString multilangString = metadata.getMultilangTitle();
                if (multilangString != null) {
                    multilangString.setSingleString(entryTitle.getText());
                }
                unit10 = Unit.INSTANCE;
            } else {
                unit10 = null;
            }
            Node node3 = identifier = entry.getFirst("identifier");
            if (node3 != null) {
                Node it11 = it10 = node3;
                metadata.setIdentifier(String.valueOf(it11.getText()));
                unit9 = Unit.INSTANCE;
            } else {
                it10 = this;
                $receiver = (Companion)it10;
                Node node4 = identifier = entry.getFirst("id");
                if (node4 != null) {
                    Node $i$a$2$let;
                    it9 = $i$a$2$let = node4;
                    metadata.setIdentifier(String.valueOf(it9.getText()));
                    unit9 = Unit.INSTANCE;
                } else {
                    unit9 = null;
                }
            }
            List list = languages = entry.get("dcterms:language");
            if (list != null) {
                Object object3;
                void $receiver$iv$iv;
                void $receiver$iv;
                it8 = $receiver = list;
                it9 = languages;
                Metadata $i$a$1$let = metadata;
                void $i$a$3$run = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    object2 = (Node)item$iv$iv;
                    object3 = destination$iv$iv;
                    object = String.valueOf(it7.getText());
                    object3.add(object);
                }
                object3 = (List)destination$iv$iv;
                $i$a$1$let.setLanguages(CollectionsKt.toMutableList((Collection)((Collection)object3)));
                unit8 = Unit.INSTANCE;
            } else {
                unit8 = null;
            }
            Node node5 = tmpDate = entry.getFirst("updated");
            if (node5 != null) {
                it8 = node5;
                it9 = it8;
                Date date = new DateTime((Object)tmpDate.getText()).toDate();
                metadata.setModified(date);
                unit7 = Unit.INSTANCE;
            } else {
                unit7 = null;
            }
            Node node6 = published = entry.getFirst("published");
            if (node6 != null) {
                it6 = it9 = node6;
                metadata.setPublicationDate(published.getText());
                unit6 = Unit.INSTANCE;
            } else {
                unit6 = null;
            }
            List list2 = rights = entry.get("rights");
            if (list2 != null) {
                Collection<String> $i$f$mapTo;
                void $receiver$iv$iv;
                void $receiver$iv;
                Object item$iv$iv;
                it5 = it6 = list2;
                destination$iv$iv = rights;
                Metadata metadata2 = metadata;
                item$iv$iv = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv) {
                    Node $i$a$1$map = (Node)item$iv$iv2;
                    $i$f$mapTo = destination$iv$iv2;
                    String $i$f$map = it4.getText();
                    $i$f$mapTo.add($i$f$map);
                }
                $i$f$mapTo = (List)destination$iv$iv2;
                metadata2.setRights(CollectionsKt.joinToString$default((Iterable)$i$f$mapTo, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                unit5 = Unit.INSTANCE;
            } else {
                unit5 = null;
            }
            List list3 = publisher = entry.get("dcterms:publisher");
            if (list3 != null) {
                it3 = it5 = list3;
                Contributor contributor = new Contributor();
                contributor.getMultilangName().setSingleString(publisher.toString());
                bl = metadata.getPublishers().add(contributor);
            } else {
                bl = null;
            }
            List list4 = categories = entry.get("category");
            if (list4 != null) {
                it2 = it3 = list4;
                for (Object category : categories) {
                    Subject subject = new Subject();
                    subject.setCode((String)category.getAttributes().get("term"));
                    subject.setName((String)category.getAttributes().get("label"));
                    subject.setScheme((String)category.getAttributes().get("scheme"));
                    metadata.getSubjects().add(subject);
                }
                unit4 = Unit.INSTANCE;
            } else {
                unit4 = null;
            }
            List list5 = authors = entry.get("author");
            if (list5 != null) {
                it = it2 = list5;
                for (Node author : authors) {
                    Contributor contributor = new Contributor();
                    List uri = author.get("uri");
                    if (uri != null) {
                        Link link = new Link();
                        link.setHref(uri.toString());
                        contributor.getLinks().add(link);
                    }
                    contributor.getMultilangName().setSingleString(String.valueOf(author.get("name")));
                    metadata.getAuthors().add(contributor);
                }
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
            Node node7 = content = entry.getFirst("content");
            if (node7 != null) {
                it7 = it = node7;
                metadata.setDescription(content.getText());
                unit2 = Unit.INSTANCE;
            } else {
                Node summary;
                it = this;
                Companion $receiver2 = (Companion)it;
                Node node8 = summary = entry.getFirst("summary");
                if (node8 != null) {
                    object = node8;
                    it4 = object;
                    metadata.setDescription(summary.getText());
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
            }
            List list6 = links = entry.get("link");
            if (list6 != null) {
                Object it12 = object2 = list6;
                for (Node link : links) {
                    Object object4;
                    Unit unit11;
                    Node it13;
                    Object object5;
                    Unit unit12;
                    Boolean bl2;
                    String it14;
                    Link newLink = new Link();
                    newLink.setHref((String)link.getAttributes().get("href"));
                    newLink.setTitle((String)link.getAttributes().get("title"));
                    newLink.setTypeLink((String)link.getAttributes().get("type"));
                    String rel = (String)link.getAttributes().get("rel");
                    if (rel != null) {
                        String $i$a$1$map;
                        it14 = $i$a$1$map;
                        bl2 = newLink.getRel().add(rel);
                    } else {
                        bl2 = null;
                    }
                    List indirectAcquisitions = link.get("opds:indirectAcquisition");
                    if (indirectAcquisitions != null) {
                        Object it15 = it14;
                        if (!indirectAcquisitions.isEmpty()) {
                            newLink.getProperties().setIndirectAcquisition(Companion.parseIndirectAcquisition$r2_opds_release(CollectionsKt.toMutableList((Collection)indirectAcquisitions)));
                        }
                        unit12 = Unit.INSTANCE;
                    } else {
                        unit12 = null;
                    }
                    Node price = link.getFirst("opds:price");
                    Double priceDouble = null;
                    String currency = null;
                    if (price != null) {
                        it13 = object5;
                        String string = String.valueOf(price.getText());
                        double d = Double.parseDouble(string);
                        priceDouble = d;
                        currency = (String)price.getAttributes().get("currencyCode");
                        if (currency == null) {
                            currency = (String)price.getAttributes().get("currencycode");
                        }
                        String string2 = currency;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Price newPrice = new Price(string2, priceDouble.doubleValue());
                        newLink.getProperties().setPrice(newPrice);
                        unit11 = Unit.INSTANCE;
                    } else {
                        unit11 = null;
                    }
                    if (rel != null) {
                        it13 = object5;
                        if (!Intrinsics.areEqual((Object)rel, (Object)"collection") && !Intrinsics.areEqual((Object)rel, (Object)"http://opds-spec.org/group")) {
                            object4 = Intrinsics.areEqual((Object)rel, (Object)"http://opds-spec.org/image") || Intrinsics.areEqual((Object)rel, (Object)"http://opds-spec.org/image-thumbnail") ? publication.getImages().add(newLink) : publication.getLinks().add(newLink);
                            continue;
                        }
                        object4 = Unit.INSTANCE;
                        continue;
                    }
                    object4 = null;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return publication;
        }

        public final void addFacet$r2_opds_release(@NotNull Feed feed, @NotNull Link link, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            for (Facet facet : feed.getFacets()) {
                if (!Intrinsics.areEqual((Object)facet.getMetadata().getTitle(), (Object)title)) continue;
                facet.getLinks().add(link);
                return;
            }
            Facet newFacet = new Facet(title);
            newFacet.getLinks().add(link);
            feed.getFacets().add(newFacet);
        }

        public final void addPublicationInGroup$r2_opds_release(@NotNull Feed feed, @NotNull Publication publication, @NotNull Link collectionLink) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
            Intrinsics.checkParameterIsNotNull((Object)collectionLink, (String)"collectionLink");
            for (Group group : feed.getGroups()) {
                for (Link l : group.getLinks()) {
                    if (!Intrinsics.areEqual((Object)l.getHref(), (Object)collectionLink.getHref())) continue;
                    group.getPublications().add(publication);
                    return;
                }
            }
            String title = collectionLink.getTitle();
            if (title != null) {
                Group newGroup = new Group(title);
                Link selfLink = new Link();
                selfLink.setHref(collectionLink.getHref());
                selfLink.setTitle(collectionLink.getTitle());
                selfLink.getRel().add("self");
                newGroup.getLinks().add(selfLink);
                newGroup.getPublications().add(publication);
                feed.getGroups().add(newGroup);
            }
        }

        public final void addNavigationInGroup$r2_opds_release(@NotNull Feed feed, @NotNull Link link, @NotNull Link collectionLink) {
            Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
            Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
            Intrinsics.checkParameterIsNotNull((Object)collectionLink, (String)"collectionLink");
            for (Group group : feed.getGroups()) {
                for (Link l : group.getLinks()) {
                    if (!Intrinsics.areEqual((Object)l.getHref(), (Object)collectionLink.getHref())) continue;
                    group.getNavigation().add(link);
                    return;
                }
            }
            String title = collectionLink.getTitle();
            if (title != null) {
                Group newGroup = new Group(title);
                Link selfLink = new Link();
                selfLink.setHref(collectionLink.getHref());
                selfLink.setTitle(collectionLink.getTitle());
                selfLink.getRel().add("self");
                newGroup.getLinks().add(selfLink);
                newGroup.getNavigation().add(link);
                feed.getGroups().add(newGroup);
            }
        }

        @NotNull
        public final List<IndirectAcquisition> parseIndirectAcquisition$r2_opds_release(@NotNull List<Node> children) {
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            List ret = new ArrayList();
            for (Node child : children) {
                List list;
                List it;
                Collection collection;
                List grandChildren;
                String typeAcquisition = (String)child.getAttributes().get("type");
                if (typeAcquisition == null) continue;
                IndirectAcquisition newIndAcq = new IndirectAcquisition(typeAcquisition);
                List list2 = child.get("opds:indirectAcquisition");
                List list3 = grandChildren = list2 != null ? CollectionsKt.toMutableList((Collection)list2) : null;
                if (grandChildren != null && !(collection = (Collection)(it = list)).isEmpty()) {
                    newIndAcq.setChild(Companion.parseIndirectAcquisition$r2_opds_release(grandChildren));
                }
                ret.add(newIndAcq);
            }
            return ret;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

