/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.parser.xml.ElementNode;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.util.Href;
import org.readium.r2.streamer.parser.epub.DEFAULT_VOCAB;
import org.readium.r2.streamer.parser.epub.PropertyDataTypeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002JF\u0010\r\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/streamer/parser/epub/NavigationDocumentParser;", "", "()V", "parse", "", "", "", "Lorg/readium/r2/shared/publication/Link;", "document", "Lorg/readium/r2/shared/parser/xml/ElementNode;", "filePath", "parseLiElement", "element", "parseNavElement", "Lkotlin/Pair;", "nav", "prefixMap", "parseOlElement", "streamer_release"})
public final class NavigationDocumentParser {
    @NotNull
    public static final NavigationDocumentParser INSTANCE = new NavigationDocumentParser();

    private NavigationDocumentParser() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<Link>> parse(@NotNull ElementNode document, @NotNull String filePath) {
        void $this$mapKeysTo$iv$iv;
        Map navMap;
        Map $this$flatMapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Map<String, String> map;
        Map<String, String> map2;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = document.getAttrNs("prefix", "http://www.idpf.org/2007/ops");
        if (string == null) {
            map2 = null;
        } else {
            String it = string;
            boolean bl = false;
            map2 = map = PropertyDataTypeKt.parsePrefixes(it);
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        Map<String, String> docPrefixes = map;
        Map prefixMap = MapsKt.plus(PropertyDataTypeKt.getCONTENT_RESERVED_PREFIXES(), docPrefixes);
        ElementNode elementNode = document.getFirst("body", "http://www.w3.org/1999/xhtml");
        if (elementNode == null) {
            return MapsKt.emptyMap();
        }
        ElementNode body = elementNode;
        Iterable $this$mapNotNull$iv = body.collect("nav", "http://www.w3.org/1999/xhtml");
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Pair<List<String>, List<Link>>> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<List<String>, List<Link>> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ElementNode it = (ElementNode)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.parseNavElement(it, filePath, prefixMap) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List navs = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = navs;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.iterator();
        while ($i$f$forEach22.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv = $i$f$forEach22.next();
            Pair nav = (Pair)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)nav.getFirst();
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void type;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(new Pair((Object)type, nav.getSecond()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Map $this$mapKeys$iv = navMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        boolean $i$f$mapKeys = false;
        $this$flatMapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry $this$map$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv2;
            boolean bl = false;
            String suffix = StringsKt.removePrefix((String)((String)it.getKey()), (CharSequence)"http://idpf.org/epub/vocab/structure/#");
            Object[] objectArray = new String[]{"toc", "page-list", "landmarks", "lot", "loi", "loa", "lov"};
            Map.Entry $i$f$mapTo = (Map.Entry)element$iv$iv$iv;
            String string3 = CollectionsKt.listOf((Object[])objectArray).contains(suffix) ? suffix : (String)it.getKey();
            Object object2 = object;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            object2.put(string3, v);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, List<Link>> parseNavElement(ElementNode nav, String filePath, Map<String, String> prefixMap) {
        Collection collection;
        List<Link> list;
        void $this$mapNotNullTo$iv$iv;
        String string = nav.getAttrNs("type", "http://www.idpf.org/2007/ops");
        if (string == null) {
            return null;
        }
        String typeAttr = string;
        Iterable $this$mapNotNull$iv = PropertyDataTypeKt.parseProperties(typeAttr);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PropertyDataTypeKt.resolveProperty(it, prefixMap, DEFAULT_VOCAB.TYPE) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List types = (List)destination$iv$iv;
        ElementNode elementNode = nav.getFirst("ol", "http://www.w3.org/1999/xhtml");
        if (elementNode == null) {
            list = null;
        } else {
            ElementNode it = elementNode;
            boolean bl = false;
            list = INSTANCE.parseOlElement(it, filePath);
        }
        List<Link> links = list;
        return !((Collection)types).isEmpty() && !((collection = (Collection)links) == null || collection.isEmpty()) ? new Pair((Object)types, links) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Link> parseOlElement(ElementNode element, String filePath) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = element.get("li", "http://www.w3.org/1999/xhtml");
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Link it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ElementNode it = (ElementNode)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.parseLiElement(it, filePath) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Link parseLiElement(ElementNode element, String filePath) {
        List<Link> children;
        List<Link> list;
        List<Link> list2;
        CharSequence charSequence;
        String string;
        ElementNode elementNode = (ElementNode)CollectionsKt.firstOrNull((List)element.getAll());
        if (elementNode == null) {
            return null;
        }
        ElementNode first = elementNode;
        if (Intrinsics.areEqual((Object)first.getName(), (Object)"ol")) {
            string = "";
        } else {
            CharSequence charSequence2 = first.collectText();
            Regex regex = new Regex("\\s+");
            charSequence = " ";
            string = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence2, charSequence))).toString();
        }
        String title = string;
        String rawHref = first.getAttr("href");
        String href = Intrinsics.areEqual((Object)first.getName(), (Object)"a") && !((charSequence = (CharSequence)rawHref) == null || StringsKt.isBlank((CharSequence)charSequence)) ? new Href(rawHref, filePath).getString() : "#";
        ElementNode elementNode2 = element.getFirst("ol", "http://www.w3.org/1999/xhtml");
        if (elementNode2 == null) {
            list2 = null;
        } else {
            ElementNode it = elementNode2;
            boolean bl = false;
            list2 = list = INSTANCE.parseOlElement(it, filePath);
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return (children = list).isEmpty() && (Intrinsics.areEqual((Object)href, (Object)"#") || Intrinsics.areEqual((Object)title, (Object)"")) ? (Link)null : new Link(href, null, false, title, null, null, null, null, null, null, null, null, children, 4086, null);
    }
}

