/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import com.mcxiaoke.koi.HASH;
import com.mcxiaoke.koi.ext.StringKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.fetcher.TransformingResource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Properties;
import org.readium.r2.shared.publication.encryption.PropertiesKt;
import org.readium.r2.shared.util.Try;
import org.readium.r2.streamer.parser.epub.EpubDeobfuscator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubDeobfuscator;", "", "pubId", "", "(Ljava/lang/String;)V", "algorithm2length", "", "", "deobfuscate", "", "bytes", "", "obfuscationKey", "obfuscationLength", "getHashKeyAdobe", "transform", "Lorg/readium/r2/shared/fetcher/Resource;", "resource", "DeobfuscatingResource", "streamer_release"})
public final class EpubDeobfuscator {
    @NotNull
    private final String pubId;
    @NotNull
    private final Map<String, Integer> algorithm2length;

    public EpubDeobfuscator(@NotNull String pubId) {
        Intrinsics.checkNotNullParameter((Object)pubId, (String)"pubId");
        this.pubId = pubId;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"http://www.idpf.org/2008/embedding", (Object)1040), TuplesKt.to((Object)"http://ns.adobe.com/pdf/enc#RC", (Object)1024)};
        this.algorithm2length = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Resource transform(@NotNull Resource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return (Resource)new DeobfuscatingResource(resource);
    }

    private final void deobfuscate(byte[] bytes, byte[] obfuscationKey, int obfuscationLength) {
        int n;
        IntRange toDeobfuscate = RangesKt.until((int)0, (int)obfuscationLength);
        int n2 = toDeobfuscate.getFirst();
        if (n2 <= (n = toDeobfuscate.getLast())) {
            int i;
            do {
                i = n2++;
                bytes[i] = (byte)(bytes[i] ^ obfuscationKey[i % obfuscationKey.length]);
            } while (i != n);
        }
    }

    private final byte[] getHashKeyAdobe(String pubId) {
        return StringKt.toHexBytes((String)StringsKt.replace$default((String)StringsKt.replace$default((String)pubId, (String)"urn:uuid:", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"", (boolean)false, (int)4, null));
    }

    public static final /* synthetic */ Map access$getAlgorithm2length$p(EpubDeobfuscator $this) {
        return $this.algorithm2length;
    }

    public static final /* synthetic */ byte[] access$getHashKeyAdobe(EpubDeobfuscator $this, String pubId) {
        return $this.getHashKeyAdobe(pubId);
    }

    public static final /* synthetic */ String access$getPubId$p(EpubDeobfuscator $this) {
        return $this.pubId;
    }

    public static final /* synthetic */ void access$deobfuscate(EpubDeobfuscator $this, byte[] bytes, byte[] obfuscationKey, int obfuscationLength) {
        $this.deobfuscate(bytes, obfuscationKey, obfuscationLength);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JE\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\u0007`\t2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\u0007`\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubDeobfuscator$DeobfuscatingResource;", "Lorg/readium/r2/shared/fetcher/TransformingResource;", "resource", "Lorg/readium/r2/shared/fetcher/Resource;", "(Lorg/readium/r2/streamer/parser/epub/EpubDeobfuscator;Lorg/readium/r2/shared/fetcher/Resource;)V", "transform", "Lorg/readium/r2/shared/util/Try;", "", "Lorg/readium/r2/shared/fetcher/Resource$Exception;", "Lorg/readium/r2/shared/fetcher/ResourceTry;", "data", "(Lorg/readium/r2/shared/util/Try;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "streamer_release"})
    public final class DeobfuscatingResource
    extends TransformingResource {
        public DeobfuscatingResource(Resource resource) {
            Intrinsics.checkNotNullParameter((Object)EpubDeobfuscator.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            super(resource, true);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object transform(@NotNull Try<byte[], ? extends Resource.Exception> var1_1, @NotNull Continuation<? super Try<byte[], ? extends Resource.Exception>> var2_2) {
            block9: {
                if (!(var2_2 instanceof transform.1)) ** GOTO lbl-1000
                var13_3 = var2_2;
                if ((var13_3.label & -2147483648) != 0) {
                    var13_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var2_2){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ DeobfuscatingResource this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.transform(null, (Continuation<? super Try<byte[], ? extends Resource.Exception>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_6 = data;
                        var4_7 = EpubDeobfuscator.this;
                        $i$f$map = false;
                        if (!this_$iv.isSuccess()) break;
                        var6_10 = (byte[])this_$iv.getOrThrow();
                        var11_11 = Try.Companion;
                        $i$a$-map-EpubDeobfuscator$DeobfuscatingResource$transform$2 = false;
                        $continuation.L$0 = var4_7;
                        $continuation.L$1 = bytes;
                        $continuation.L$2 = var11_11;
                        $continuation.label = 1;
                        v0 = this.getResource().link((Continuation)$continuation);
                        if (v0 == var14_5) {
                            return var14_5;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        $i$f$map = false;
                        $i$a$-map-EpubDeobfuscator$DeobfuscatingResource$transform$2 = false;
                        var11_11 = (Try.Companion)$continuation.L$2;
                        bytes = (byte[])$continuation.L$1;
                        var4_7 = (EpubDeobfuscator)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl35:
                        // 2 sources

                        v1 = PropertiesKt.getEncryption((Properties)((Link)v0).getProperties());
                        algorithm = v1 == null ? null : v1.getAlgorithm();
                        var10_15 = (Integer)EpubDeobfuscator.access$getAlgorithm2length$p(var4_7).get(algorithm);
                        if (var10_15 == null) {
                            v2 = bytes;
                        } else {
                            obfuscationLength = var10_15;
                            obfuscationKey = Intrinsics.areEqual((Object)algorithm, (Object)"http://ns.adobe.com/pdf/enc#RC") != false ? EpubDeobfuscator.access$getHashKeyAdobe(var4_7, EpubDeobfuscator.access$getPubId$p(var4_7)) : StringKt.toHexBytes((String)HASH.INSTANCE.sha1(EpubDeobfuscator.access$getPubId$p(var4_7)));
                            EpubDeobfuscator.access$deobfuscate(var4_7, bytes, obfuscationKey, obfuscationLength);
                            v2 = bytes;
                        }
                        v3 = var11_11.success((Object)v2);
                        break block9;
                    }
                }
                v4 = this_$iv.exceptionOrNull();
                Intrinsics.checkNotNull((Object)v4);
                v3 = Try.Companion.failure(v4);
            }
            return v3;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

