/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Scanner;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.Injectable;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.server.Assets;
import org.readium.r2.streamer.server.Files;
import org.readium.r2.streamer.server.Resources;
import org.readium.r2.streamer.server.ServingFetcher;
import org.readium.r2.streamer.server.handler.AssetHandler;
import org.readium.r2.streamer.server.handler.FileHandler;
import org.readium.r2.streamer.server.handler.ManifestHandler;
import org.readium.r2.streamer.server.handler.MediaOverlayHandler;
import org.readium.r2.streamer.server.handler.PublicationResourceHandler;
import org.readium.r2.streamer.server.handler.ResourceHandler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0007J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0007J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J.\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010*\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0002J.\u0010+\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\b\b\u0002\u0010-\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001e\u00100\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\nJ\u001e\u00101\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010.\u001a\u00020/J\u0018\u00102\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u000203H\u0007J\u0010\u00105\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u000203H\u0007J5\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\n2\n\u00108\u001a\u0006\u0012\u0002\b\u0003092\u0012\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020<0;\"\u00020<H\u0002\u00a2\u0006\u0002\u0010=J\u0014\u0010>\u001a\u00020\u001b*\u00020%2\u0006\u0010?\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/readium/r2/streamer/server/AbstractServer;", "Lorg/nanohttpd/router/RouterNanoHTTPD;", "port", "", "context", "Landroid/content/Context;", "enableReadiumNavigatorSupport", "", "(ILandroid/content/Context;Z)V", "ASSETS_HANDLE", "", "CSS_HANDLE", "FONT_HANDLE", "JSON_MANIFEST_HANDLE", "JS_HANDLE", "MANIFEST_HANDLE", "MANIFEST_ITEM_HANDLE", "MEDIA_OVERLAY_HANDLE", "assets", "Lorg/readium/r2/streamer/server/Assets;", "containsMediaOverlay", "customResources", "Lorg/readium/r2/streamer/server/Resources;", "fonts", "Lorg/readium/r2/streamer/server/Files;", "resources", "addEpub", "", "publication", "Lorg/readium/r2/shared/publication/Publication;", "fileName", "userPropertiesPath", "container", "Lorg/readium/r2/streamer/container/Container;", "addFont", "name", "inputStream", "Ljava/io/InputStream;", "addPublication", "Ljava/net/URL;", "userPropertiesFile", "Ljava/io/File;", "filename", "addResource", "body", "custom", "injectable", "Lorg/readium/r2/shared/Injectable;", "loadCustomFont", "loadCustomResource", "loadR2FontResources", "Landroid/content/res/AssetManager;", "loadR2ScriptResources", "loadReadiumCSSResources", "setRoute", "url", "handler", "Ljava/lang/Class;", "initParameter", "", "", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Object;)V", "toFile", "path", "streamer_release"})
public abstract class AbstractServer
extends RouterNanoHTTPD {
    private int port;
    @NotNull
    private final Context context;
    private final boolean enableReadiumNavigatorSupport;
    @NotNull
    private final String MANIFEST_HANDLE;
    @NotNull
    private final String JSON_MANIFEST_HANDLE;
    @NotNull
    private final String MANIFEST_ITEM_HANDLE;
    @NotNull
    private final String MEDIA_OVERLAY_HANDLE;
    @NotNull
    private final String CSS_HANDLE;
    @NotNull
    private final String JS_HANDLE;
    @NotNull
    private final String FONT_HANDLE;
    @NotNull
    private final String ASSETS_HANDLE;
    private boolean containsMediaOverlay;
    @NotNull
    private final Resources resources;
    @NotNull
    private final Resources customResources;
    @NotNull
    private final Assets assets;
    @NotNull
    private final Files fonts;

    public AbstractServer(int port, @NotNull Context context, boolean enableReadiumNavigatorSupport) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("127.0.0.1", port);
        this.port = port;
        this.context = context;
        this.enableReadiumNavigatorSupport = enableReadiumNavigatorSupport;
        this.MANIFEST_HANDLE = "/manifest";
        this.JSON_MANIFEST_HANDLE = "/manifest.json";
        this.MANIFEST_ITEM_HANDLE = "/(.*)";
        this.MEDIA_OVERLAY_HANDLE = "/media-overlay";
        this.CSS_HANDLE = '/' + Injectable.Style.getRawValue() + "/(.*)";
        this.JS_HANDLE = '/' + Injectable.Script.getRawValue() + "/(.*)";
        this.FONT_HANDLE = '/' + Injectable.Font.getRawValue() + "/(.*)";
        this.ASSETS_HANDLE = "/assets/(.*)";
        this.resources = new Resources();
        this.customResources = new Resources();
        AssetManager assetManager = this.context.getAssets();
        Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"context.assets");
        this.assets = new Assets(assetManager, "/assets/", null, 4, null);
        this.fonts = new Files("" + '/' + Injectable.Style + '/', null, 2, null);
        this.assets.add("readium-css", "readium/readium-css");
        this.assets.add("scripts", "readium/scripts");
        this.assets.add("fonts", "readium/fonts");
    }

    public /* synthetic */ AbstractServer(int n, Context context, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(n, context, bl);
    }

    private final void addResource(String name, String body, boolean custom, Injectable injectable) {
        if (custom) {
            this.customResources.add(name, body, injectable);
        }
        Resources.add$default(this.resources, name, body, null, 4, null);
    }

    static /* synthetic */ void addResource$default(AbstractServer abstractServer, String string, String string2, boolean bl, Injectable injectable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addResource");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            injectable = null;
        }
        abstractServer.addResource(string, string2, bl, injectable);
    }

    private final void addFont(String name, InputStream inputStream, Context context) {
        File dir = new File(context.getFilesDir().getPath() + '/' + Injectable.Font.getRawValue() + '/');
        dir.mkdirs();
        this.toFile(inputStream, context.getFilesDir().getPath() + '/' + Injectable.Font.getRawValue() + '/' + name);
        File file = new File(context.getFilesDir().getPath() + '/' + Injectable.Font.getRawValue() + '/' + name);
        this.fonts.set(name, file);
    }

    public final void loadCustomResource(@NotNull InputStream inputStream, @NotNull String fileName, @NotNull Injectable injectable) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)injectable, (String)"injectable");
        try {
            String string = new Scanner(inputStream, "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Scanner(inputStream, \"ut\u2026seDelimiter(\"\\\\A\").next()");
            this.addResource(fileName, string, true, injectable);
        }
        catch (IOException e) {
        }
    }

    public final void loadCustomFont(@NotNull InputStream inputStream, @NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            this.addFont(fileName, inputStream, context);
        }
        catch (IOException e) {
        }
    }

    @Nullable
    public final URL addPublication(@NotNull Publication publication, @Nullable File userPropertiesFile) {
        Intrinsics.checkNotNullParameter((Object)publication, (String)"publication");
        File file = userPropertiesFile;
        return this.addPublication(publication, null, Intrinsics.stringPlus((String)"/", (Object)UUID.randomUUID()), file == null ? null : file.getPath());
    }

    public static /* synthetic */ URL addPublication$default(AbstractServer abstractServer, Publication publication, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addPublication");
        }
        if ((n & 2) != 0) {
            file = null;
        }
        return abstractServer.addPublication(publication, file);
    }

    private final URL addPublication(Publication publication, Container container, String filename, String userPropertiesPath) {
        Object[] objectArray;
        boolean bl;
        Container container2 = container;
        if (container2 == null) {
            bl = false;
        } else {
            RootFile rootFile = container2.getRootFile();
            if (rootFile == null) {
                bl = false;
            } else {
                String string = rootFile.getRootFilePath();
                if (string == null) {
                    bl = false;
                } else {
                    objectArray = (Object[])string;
                    boolean bl2 = false;
                    bl = objectArray.length() == 0;
                }
            }
        }
        if (bl) {
            return null;
        }
        URL baseUrl = new URL(Publication.Companion.localBaseUrlOf(filename, this.port));
        ServingFetcher fetcher = new ServingFetcher(publication, this.enableReadiumNavigatorSupport, userPropertiesPath, this.customResources);
        try {
            objectArray = URLDecoder.decode(baseUrl.getPath(), "UTF-8");
        }
        catch (Exception e) {
            objectArray = baseUrl.getPath();
        }
        Object[] basePath = objectArray;
        if (this.containsMediaOverlay) {
            objectArray = new Object[]{fetcher};
            this.setRoute(Intrinsics.stringPlus((String)basePath, (Object)this.MEDIA_OVERLAY_HANDLE), MediaOverlayHandler.class, objectArray);
        }
        objectArray = new Object[]{fetcher};
        this.setRoute(Intrinsics.stringPlus((String)basePath, (Object)this.JSON_MANIFEST_HANDLE), ManifestHandler.class, objectArray);
        objectArray = new Object[]{fetcher};
        this.setRoute(Intrinsics.stringPlus((String)basePath, (Object)this.MANIFEST_HANDLE), ManifestHandler.class, objectArray);
        objectArray = new Object[]{fetcher};
        this.setRoute(Intrinsics.stringPlus((String)basePath, (Object)this.MANIFEST_ITEM_HANDLE), PublicationResourceHandler.class, objectArray);
        objectArray = new Object[]{this.assets};
        this.setRoute(this.ASSETS_HANDLE, AssetHandler.class, objectArray);
        objectArray = new Object[]{this.resources};
        this.setRoute(this.JS_HANDLE, ResourceHandler.class, objectArray);
        objectArray = new Object[]{this.resources};
        this.setRoute(this.CSS_HANDLE, ResourceHandler.class, objectArray);
        objectArray = new Object[]{this.fonts};
        this.setRoute(this.FONT_HANDLE, FileHandler.class, objectArray);
        return baseUrl;
    }

    @Deprecated(message="Use the easier-to-use addPublication()", replaceWith=@ReplaceWith(expression="this.addPublication(publication, userPropertiesFile = File(userPropertiesPath))", imports={}), level=DeprecationLevel.ERROR)
    public final void addEpub(@NotNull Publication publication, @NotNull String fileName, @Nullable String userPropertiesPath) {
        Intrinsics.checkNotNullParameter((Object)publication, (String)"publication");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.addPublication(publication, null, fileName, userPropertiesPath);
    }

    @Deprecated(message="Use the easier-to-use addPublication()", replaceWith=@ReplaceWith(expression="this.addPublication(publication, userPropertiesFile = File(userPropertiesPath))", imports={}), level=DeprecationLevel.ERROR)
    public final void addEpub(@NotNull Publication publication, @Nullable Container container, @NotNull String fileName, @Nullable String userPropertiesPath) {
        Intrinsics.checkNotNullParameter((Object)publication, (String)"publication");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.addPublication(publication, container, fileName, userPropertiesPath);
    }

    private final void setRoute(String url, Class<?> handler, Object ... initParameter) {
        try {
            this.removeRoute(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addRoute(url, handler, Arrays.copyOf(initParameter, initParameter.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void toFile(InputStream $this$toFile, String path) {
        Closeable closeable = $this$toFile;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl3 = false;
            Object object = new File(path);
            boolean bl4 = false;
            object = new FileOutputStream((File)object);
            bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl6 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Deprecated(message="This is not needed anymore")
    public final void loadReadiumCSSResources(@NotNull AssetManager assets) {
        Intrinsics.checkNotNullParameter((Object)assets, (String)"assets");
    }

    @Deprecated(message="This is not needed anymore")
    public final void loadR2ScriptResources(@NotNull AssetManager assets) {
        Intrinsics.checkNotNullParameter((Object)assets, (String)"assets");
    }

    @Deprecated(message="This is not needed anymore")
    public final void loadR2FontResources(@NotNull AssetManager assets, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)assets, (String)"assets");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }
}

