/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.tokenizer;

import android.icu.text.BreakIterator;
import androidx.annotation.RequiresApi;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.ExperimentalReadiumApi;
import org.readium.r2.shared.util.Language;
import org.readium.r2.shared.util.tokenizer.TextTokenizerKt;
import org.readium.r2.shared.util.tokenizer.TextUnit;
import org.readium.r2.shared.util.tokenizer.Tokenizer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004B\u0017\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/readium/r2/shared/util/tokenizer/IcuTextTokenizer;", "Lorg/readium/r2/shared/util/tokenizer/Tokenizer;", "", "Lkotlin/ranges/IntRange;", "Lorg/readium/r2/shared/util/tokenizer/TextTokenizer;", "language", "Lorg/readium/r2/shared/util/Language;", "unit", "Lorg/readium/r2/shared/util/tokenizer/TextUnit;", "(Lorg/readium/r2/shared/util/Language;Lorg/readium/r2/shared/util/tokenizer/TextUnit;)V", "iterator", "Landroid/icu/text/BreakIterator;", "tokenize", "", "data", "readium-shared_release"})
@ExperimentalReadiumApi
@RequiresApi(value=24)
public final class IcuTextTokenizer
implements Tokenizer<String, IntRange> {
    @NotNull
    private final BreakIterator iterator;

    public IcuTextTokenizer(@Nullable Language language2, @NotNull TextUnit unit) {
        BreakIterator breakIterator;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Object object = language2;
        if (object == null || (object = ((Language)object).getLocale()) == null) {
            object = Locale.ROOT;
        }
        Object loc = object;
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                BreakIterator breakIterator2 = BreakIterator.getWordInstance((Locale)loc);
                breakIterator = breakIterator2;
                Intrinsics.checkNotNullExpressionValue((Object)breakIterator2, (String)"getWordInstance(loc)");
                break;
            }
            case 2: {
                BreakIterator breakIterator3 = BreakIterator.getSentenceInstance((Locale)loc);
                breakIterator = breakIterator3;
                Intrinsics.checkNotNullExpressionValue((Object)breakIterator3, (String)"getSentenceInstance(loc)");
                break;
            }
            case 3: {
                throw new IllegalArgumentException("IcuTextTokenizer does not handle TextContentUnit.Paragraph");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.iterator = breakIterator;
    }

    @Override
    @NotNull
    public List<IntRange> tokenize(@NotNull String data) {
        List list;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.iterator.setText(data);
        int start = 0;
        start = this.iterator.first();
        int end2 = 0;
        end2 = this.iterator.next();
        List $this$tokenize_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (end2 != -1) {
            IntRange intRange = TextTokenizerKt.access$sanitizeRange(data, start, end2);
            if (intRange != null) {
                IntRange it = intRange;
                boolean bl2 = false;
                $this$tokenize_u24lambda_u241.add(it);
            }
            start = end2;
            end2 = this.iterator.next();
        }
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextUnit.values().length];
            try {
                nArray[TextUnit.Word.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextUnit.Sentence.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextUnit.Paragraph.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

