/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.publication.services.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.ExperimentalReadiumApi;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.services.content.Content;
import org.readium.r2.shared.publication.services.content.ContentTokenizer;
import org.readium.r2.shared.util.Language;
import org.readium.r2.shared.util.tokenizer.DefaultTextContentTokenizer;
import org.readium.r2.shared.util.tokenizer.TextUnit;
import org.readium.r2.shared.util.tokenizer.Tokenizer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012$\u0010\t\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e0\n\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/readium/r2/shared/publication/services/content/TextContentTokenizer;", "Lorg/readium/r2/shared/publication/services/content/ContentTokenizer;", "defaultLanguage", "Lorg/readium/r2/shared/util/Language;", "unit", "Lorg/readium/r2/shared/util/tokenizer/TextUnit;", "(Lorg/readium/r2/shared/util/Language;Lorg/readium/r2/shared/util/tokenizer/TextUnit;)V", "contextSnippetLength", "", "textTokenizerFactory", "Lkotlin/Function1;", "Lorg/readium/r2/shared/util/tokenizer/Tokenizer;", "", "Lkotlin/ranges/IntRange;", "Lorg/readium/r2/shared/util/tokenizer/TextTokenizer;", "(Lorg/readium/r2/shared/util/Language;ILkotlin/jvm/functions/Function1;)V", "extractTextContextIn", "Lorg/readium/r2/shared/publication/Locator$Text;", "string", "range", "tokenize", "", "Lorg/readium/r2/shared/publication/services/content/Content$Element;", "data", "Lorg/readium/r2/shared/publication/services/content/Content$TextElement$Segment;", "segment", "readium-shared_release"})
@ExperimentalReadiumApi
public final class TextContentTokenizer
implements ContentTokenizer {
    @Nullable
    private final Language defaultLanguage;
    private final int contextSnippetLength;
    @NotNull
    private final Function1<Language, Tokenizer<String, IntRange>> textTokenizerFactory;

    public TextContentTokenizer(@Nullable Language defaultLanguage, int contextSnippetLength, @NotNull Function1<? super Language, ? extends Tokenizer<String, IntRange>> textTokenizerFactory) {
        Intrinsics.checkNotNullParameter(textTokenizerFactory, (String)"textTokenizerFactory");
        this.defaultLanguage = defaultLanguage;
        this.contextSnippetLength = contextSnippetLength;
        this.textTokenizerFactory = textTokenizerFactory;
    }

    public /* synthetic */ TextContentTokenizer(Language language2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(language2, n, (Function1<? super Language, ? extends Tokenizer<String, IntRange>>)function1);
    }

    public TextContentTokenizer(@Nullable Language defaultLanguage, final @NotNull TextUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this(defaultLanguage, 0, (Function1)new Function1<Language, Tokenizer<String, IntRange>>(){

            @NotNull
            public final Tokenizer<String, IntRange> invoke(@Nullable Language language2) {
                return new DefaultTextContentTokenizer(unit, language2);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Content.Element> tokenize(@NotNull Content.Element data) {
        Content.Element element;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data instanceof Content.TextElement) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = ((Content.TextElement)data).getSegments();
            Content.TextElement.Role role = null;
            Locator locator = null;
            Content.TextElement textElement = (Content.TextElement)data;
            boolean $i$f$flatMap = false;
            void var4_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Content.TextElement.Segment it = (Content.TextElement.Segment)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.tokenize(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            element = Content.TextElement.copy$default(textElement, locator, role, list, null, 11, null);
        } else {
            element = data;
        }
        return CollectionsKt.listOf((Object)element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private final List<Content.TextElement.Segment> tokenize(Content.TextElement.Segment segment) {
        void $this$mapTo$iv$iv;
        Language language2 = segment.getLanguage();
        if (language2 == null) {
            language2 = this.defaultLanguage;
        }
        Iterable $this$map$iv = ((Tokenizer)this.textTokenizerFactory.invoke((Object)language2)).tokenize(segment.getText());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range;
            IntRange intRange = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Content.TextElement.Segment.copy$default(segment, Locator.copy$default(segment.getLocator(), null, null, null, null, this.extractTextContextIn(segment.getText(), (IntRange)range), 15, null), StringsKt.substring((String)segment.getText(), (IntRange)range), null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    private final Locator.Text extractTextContextIn(String string2, IntRange range) {
        String string3;
        String string4;
        String string5 = string2.substring(range.getLast(), RangesKt.coerceAtMost((int)(range.getLast() + this.contextSnippetLength), (int)string2.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String after = string5;
        String string6 = string2.substring(RangesKt.coerceAtLeast((int)(range.getFirst() - this.contextSnippetLength), (int)0), range.getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String before = string6;
        String it = string4 = after;
        boolean bl = false;
        String string7 = ((CharSequence)it).length() > 0 ? string4 : null;
        String it2 = string3 = before;
        boolean bl2 = false;
        string4 = ((CharSequence)it2).length() > 0 ? string3 : null;
        string3 = StringsKt.substring((String)string2, (IntRange)range);
        return new Locator.Text(string4, string3, string7);
    }
}

