/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.http;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.util.http.HttpRequest;
import org.readium.r2.shared.util.mediatype.MediaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u001a\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u001b\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\tH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003JM\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010*\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u0005J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010+\u001a\u00020\u0005R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lorg/readium/r2/shared/util/http/HttpResponse;", "", "request", "Lorg/readium/r2/shared/util/http/HttpRequest;", "url", "", "statusCode", "", "headers", "", "", "mediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "(Lorg/readium/r2/shared/util/http/HttpRequest;Ljava/lang/String;ILjava/util/Map;Lorg/readium/r2/shared/util/mediatype/MediaType;)V", "acceptsByteRanges", "", "getAcceptsByteRanges", "()Z", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getHeaders", "()Ljava/util/Map;", "getMediaType", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "getRequest", "()Lorg/readium/r2/shared/util/http/HttpRequest;", "getStatusCode", "()I", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "valueForHeader", "name", "valuesForHeader", "shared_release"})
public final class HttpResponse {
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final String url;
    private final int statusCode;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final MediaType mediaType;

    public HttpResponse(@NotNull HttpRequest request2, @NotNull String url, int statusCode, @NotNull Map<String, ? extends List<String>> headers, @NotNull MediaType mediaType2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        this.request = request2;
        this.url = url;
        this.statusCode = statusCode;
        this.headers = headers;
        this.mediaType = mediaType2;
    }

    @NotNull
    public final HttpRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final MediaType getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public final String valueForHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)CollectionsKt.firstOrNull(this.valuesForHeader(name));
    }

    @NotNull
    public final List<String> valuesForHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = name.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String name2 = string2;
        Map<String, List<String>> $this$filterKeys$iv = this.headers;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, List<String>> result$iv = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
            String string3 = it.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            if (!Intrinsics.areEqual((Object)string3, (Object)name2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.flatten((Iterable)((Map)result$iv).values());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getAcceptsByteRanges() {
        Object object;
        String string2;
        String string3 = this.valueForHeader("Accept-Ranges");
        if (string3 == null) {
            string2 = null;
        } else {
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            object = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toLowerCase(locale)");
            string2 = object;
        }
        if (Intrinsics.areEqual(string2, (Object)"bytes")) return true;
        string3 = this.valueForHeader("Content-Range");
        if (string3 == null) {
            return false;
        }
        object = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
        String string4 = string3.toLowerCase((Locale)object);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        String string5 = string4;
        if (!StringsKt.startsWith$default((String)string5, (String)"bytes", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final Long getContentLength() {
        Long l;
        String string2 = this.valueForHeader("Content-Length");
        if (string2 == null) {
            l = null;
        } else {
            Long l2 = StringsKt.toLongOrNull((String)string2);
            if (l2 == null) {
                l = null;
            } else {
                Long l3 = l2;
                long it = ((Number)l3).longValue();
                boolean bl = false;
                l = it >= 0L ? l3 : null;
            }
        }
        return l;
    }

    @NotNull
    public final HttpRequest component1() {
        return this.request;
    }

    @NotNull
    public final String component2() {
        return this.url;
    }

    public final int component3() {
        return this.statusCode;
    }

    @NotNull
    public final Map<String, List<String>> component4() {
        return this.headers;
    }

    @NotNull
    public final MediaType component5() {
        return this.mediaType;
    }

    @NotNull
    public final HttpResponse copy(@NotNull HttpRequest request2, @NotNull String url, int statusCode, @NotNull Map<String, ? extends List<String>> headers, @NotNull MediaType mediaType2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        return new HttpResponse(request2, url, statusCode, headers, mediaType2);
    }

    public static /* synthetic */ HttpResponse copy$default(HttpResponse httpResponse, HttpRequest httpRequest, String string2, int n, Map map, MediaType mediaType2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            httpRequest = httpResponse.request;
        }
        if ((n2 & 2) != 0) {
            string2 = httpResponse.url;
        }
        if ((n2 & 4) != 0) {
            n = httpResponse.statusCode;
        }
        if ((n2 & 8) != 0) {
            map = httpResponse.headers;
        }
        if ((n2 & 0x10) != 0) {
            mediaType2 = httpResponse.mediaType;
        }
        return httpResponse.copy(httpRequest, string2, n, map, mediaType2);
    }

    @NotNull
    public String toString() {
        return "HttpResponse(request=" + this.request + ", url=" + this.url + ", statusCode=" + this.statusCode + ", headers=" + this.headers + ", mediaType=" + this.mediaType + ')';
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + Integer.hashCode(this.statusCode);
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.mediaType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpResponse)) {
            return false;
        }
        HttpResponse httpResponse = (HttpResponse)other;
        if (!Intrinsics.areEqual((Object)this.request, (Object)httpResponse.request)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)httpResponse.url)) {
            return false;
        }
        if (this.statusCode != httpResponse.statusCode) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpResponse.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mediaType, (Object)httpResponse.mediaType);
    }
}

