/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.extensions;

import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.readium.r2.shared.extensions.HashAlgorithm;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0001\u001a\u0018\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\n*\u00020\u0001H\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0001H\u0000\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0000\u00a8\u0006\u0010"}, d2={"addPrefix", "", "prefix", "", "hash", "algorithm", "Lorg/readium/r2/shared/extensions/HashAlgorithm;", "iso8601ToDate", "Ljava/util/Date;", "queryParameters", "", "toJsonOrNull", "Lorg/json/JSONObject;", "toUrlOrNull", "Ljava/net/URL;", "context", "shared_release"})
public final class StringKt {
    @Nullable
    public static final Date iso8601ToDate(@NotNull String $this$iso8601ToDate) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$iso8601ToDate, (String)"<this>");
        try {
            DateTimeZone defaultTZ = DateTimeZone.getDefault();
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
            Date date2 = new DateTime((Object)$this$iso8601ToDate).toDateTime(DateTimeZone.UTC).toDate();
            DateTimeZone.setDefault((DateTimeZone)defaultTZ);
            date = date2;
        }
        catch (Exception e) {
            date = null;
        }
        return date;
    }

    @NotNull
    public static final String addPrefix(@NotNull String $this$addPrefix, @NotNull CharSequence prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$addPrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (StringsKt.startsWith$default((CharSequence)$this$addPrefix, (CharSequence)prefix, (boolean)false, (int)2, null)) {
            return $this$addPrefix;
        }
        return prefix + $this$addPrefix;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String hash(@NotNull String $this$hash, @NotNull HashAlgorithm algorithm) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm.getKey());
        String string = $this$hash;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(algorithm.ke\u2026igest(this.toByteArray())");
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void it;
            void var10_10 = element$iv;
            String str = accumulator$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{(byte)it};
            String string2 = String.format("%02x", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            accumulator$iv = Intrinsics.stringPlus((String)str, (Object)string2);
        }
        return accumulator$iv;
    }

    @Nullable
    public static final URL toUrlOrNull(@NotNull String $this$toUrlOrNull, @Nullable URL context) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)$this$toUrlOrNull, (String)"<this>");
        try {
            uRL = new URL(context, $this$toUrlOrNull);
        }
        catch (Exception e) {
            uRL = null;
        }
        return uRL;
    }

    public static /* synthetic */ URL toUrlOrNull$default(String string, URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            uRL = null;
        }
        return StringKt.toUrlOrNull(string, uRL);
    }

    @Nullable
    public static final JSONObject toJsonOrNull(@NotNull String $this$toJsonOrNull) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)$this$toJsonOrNull, (String)"<this>");
        try {
            jSONObject = new JSONObject($this$toJsonOrNull);
        }
        catch (JSONException e) {
            jSONObject = null;
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> queryParameters(@NotNull String $this$queryParameters) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Object object2;
        String[] $this$takeWhile$iv;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$queryParameters, (String)"<this>");
            String string = URLDecoder.decode($this$queryParameters, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(this, \"UTF-8\")");
            $this$takeWhile$iv = StringsKt.substringAfter$default((String)string, (String)"?", null, (int)2, null);
            boolean $i$f$takeWhile = false;
            int n = 0;
            int n2 = $this$takeWhile$iv.length();
            while (n < n2) {
                int index$iv = n++;
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                int n3 = 0;
                if (it22 != '#') continue;
                String[] it22 = $this$takeWhile$iv;
                n3 = 0;
                object2 = it22.substring(n3, index$iv);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = object2;
                break block3;
            }
            object = $this$takeWhile$iv;
        }
        $this$takeWhile$iv = new String[]{"&"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])$this$takeWhile$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv$iv$iv.iterator();
        while (object2.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Object object3 = new String[]{"="};
            Object it2 = object3 = StringsKt.split$default((CharSequence)it, (String[])object3, (boolean)false, (int)0, (int)6, null);
            boolean bl3 = false;
            if ((it2.size() == 2 ? object3 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair(it.get(0), it.get(1));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }
}

