/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.ext.com.google.common.cache.Cache;
import org.apache.jena.ext.com.google.common.cache.CacheBuilder;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;

public class HDTSparql {
    @Parameter(description="<HDT file> <SPARQL query>")
    public List<String> parameters = Lists.newArrayList();
    @Parameter(names={"--stream"}, description="Output CONSTRUCT/DESCRIBE query results directly as they are generated")
    public boolean streamMode = false;
    public String fileHDT;
    public String sparqlQuery;
    private final int DUP_WINDOW = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        try (HDT hdt = HDTManager.mapIndexedHDT((String)this.fileHDT, null);){
            HDTGraph graph = new HDTGraph(hdt);
            Model model = ModelFactory.createModelForGraph((Graph)graph);
            Query query = QueryFactory.create((String)this.sparqlQuery);
            try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);){
                if (query.isSelectType()) {
                    ResultSet results = qe.execSelect();
                    ResultSetFormatter.outputAsCSV((OutputStream)System.out, (ResultSet)results);
                } else if (query.isDescribeType()) {
                    if (this.streamMode) {
                        Iterator results = qe.execDescribeTriples();
                        this.streamResults(results);
                    } else {
                        Model result = qe.execDescribe();
                        result.write((OutputStream)System.out, "N-TRIPLES", null);
                    }
                } else if (query.isConstructType()) {
                    if (this.streamMode) {
                        Iterator results = qe.execConstructTriples();
                        this.streamResults(results);
                    } else {
                        Model result = qe.execConstruct();
                        result.write((OutputStream)System.out, "N-TRIPLES", null);
                    }
                } else if (query.isAskType()) {
                    boolean b = qe.execAsk();
                    System.out.println(b);
                }
            }
        }
    }

    private void streamResults(Iterator<Triple> results) {
        StreamRDF writer = StreamRDFWriter.getWriterStream((OutputStream)System.out, (Lang)Lang.NTRIPLES);
        Cache seenTriples = CacheBuilder.newBuilder().maximumSize(1000L).build();
        writer.start();
        while (results.hasNext()) {
            Triple triple = results.next();
            if (seenTriples.getIfPresent((Object)triple) != null) continue;
            seenTriples.put((Object)triple, (Object)true);
            writer.triple(triple);
        }
        writer.finish();
    }

    public static void main(String[] args) throws Throwable {
        HDTSparql hdtSparql = new HDTSparql();
        JCommander com = new JCommander((Object)hdtSparql, args);
        com.setProgramName("hdtsparql");
        if (hdtSparql.parameters.size() != 2) {
            com.usage();
            System.exit(1);
        }
        hdtSparql.fileHDT = hdtSparql.parameters.get(0);
        hdtSparql.sparqlQuery = hdtSparql.parameters.get(1);
        hdtSparql.execute();
    }
}

