/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.bindings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBase;
import org.rdfhdt.hdtjena.bindings.BindingHDTId;
import org.rdfhdt.hdtjena.bindings.HDTId;

public class BindingHDTNode
extends BindingBase {
    private final BindingHDTId idBinding;
    private List<Var> vars;

    public BindingHDTNode(BindingHDTId idBinding) {
        super(idBinding.getParentBinding());
        this.idBinding = idBinding;
    }

    protected int size1() {
        return this.idBinding.size();
    }

    protected Iterator<Var> vars1() {
        if (this.vars == null) {
            this.vars = this.calcVars();
        }
        return this.vars.iterator();
    }

    private List<Var> calcVars() {
        ArrayList<Var> vars = new ArrayList<Var>(4);
        Binding b = this.idBinding.getParentBinding();
        Iterator iterator = this.idBinding.iterator();
        while (iterator.hasNext()) {
            Var v = (Var)iterator.next();
            if (b != null && b.contains(v)) continue;
            vars.add(v);
        }
        return vars;
    }

    protected boolean isEmpty1() {
        return this.size1() == 0;
    }

    public boolean contains1(Var var) {
        return this.idBinding.containsKey(var);
    }

    public BindingHDTId getBindingId() {
        return this.idBinding;
    }

    public HDTId getHDTId(Var var) {
        HDTId id = (HDTId)this.idBinding.get(var);
        if (id != null) {
            return id;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BindingHDTNode) {
            return ((BindingHDTNode)this.parent).getHDTId(var);
        }
        return null;
    }

    public Node get1(Var var) {
        try {
            HDTId id = (HDTId)this.idBinding.get(var);
            if (id == null) {
                return null;
            }
            return id.getNode();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void format(StringBuffer sbuff, Var var) {
        HDTId id = (HDTId)this.idBinding.get(var);
        Object extra = "";
        if (id != null) {
            extra = "/" + id;
        }
        Node node = this.get(var);
        sbuff.append("( ?").append(var.getVarName()).append((String)extra).append(" = ").append(node).append(" )");
    }
}

