/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.rdfhdt.hdt.cache.DictionaryCache;
import org.rdfhdt.hdt.cache.DictionaryCacheArray;
import org.rdfhdt.hdt.cache.DictionaryCacheLRI;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.rdf.parsers.JenaNodeCreator;
import org.rdfhdt.hdt.rdf.parsers.JenaNodeFormatter;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdtjena.DummyMap;
import org.rdfhdt.hdtjena.bindings.HDTId;

public class NodeDictionary {
    private final Dictionary dictionary;
    private final DictionaryCache<Node>[] cacheIDtoNode = new DictionaryCache[TripleComponentRole.values().length];
    Map<String, Long>[] cacheNodeToId = new Map[TripleComponentRole.values().length];

    public NodeDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
        int idToNodeSize = 20000;
        this.cacheIDtoNode[0] = dictionary.getNsubjects() > 20000L ? new DictionaryCacheLRI(20000) : new DictionaryCacheArray((int)dictionary.getNsubjects());
        this.cacheIDtoNode[1] = dictionary.getNpredicates() > 20000L ? new DictionaryCacheLRI(20000) : new DictionaryCacheArray((int)dictionary.getNpredicates());
        this.cacheIDtoNode[2] = dictionary.getNobjects() > 20000L ? new DictionaryCacheLRI(20000) : new DictionaryCacheArray((int)dictionary.getNobjects());
        this.cacheNodeToId[0] = DummyMap.getInstance();
        this.cacheNodeToId[1] = DummyMap.getInstance();
        this.cacheNodeToId[2] = DummyMap.getInstance();
    }

    public Node getNode(HDTId hdtid) {
        return this.getNode(hdtid.getValue(), hdtid.getRole());
    }

    public Node getNode(long l, TripleComponentRole role) {
        Node node = (Node)this.cacheIDtoNode[role.ordinal()].get((long)((int)l));
        if (node == null) {
            CharSequence str = this.dictionary.idToString(l, role);
            char firstChar = str.charAt(0);
            node = firstChar == '_' ? JenaNodeCreator.createAnon((String)str.toString()) : (firstChar == '\"' ? JenaNodeCreator.createLiteral((String)str.toString()) : JenaNodeCreator.createURI((String)str.toString()));
            this.cacheIDtoNode[role.ordinal()].put((long)((int)l), (Object)node);
        }
        return node;
    }

    public long getIntID(Node node, TripleComponentRole role) {
        return this.getIntID(NodeDictionary.nodeToStr(node), role);
    }

    public long getIntID(Node node, PrefixMapping map, TripleComponentRole role) {
        return this.getIntID(NodeDictionary.nodeToStr(node, map), role);
    }

    public long getIntID(String str, TripleComponentRole role) {
        Long intValue = this.cacheNodeToId[role.ordinal()].get(str);
        if (intValue != null) {
            return intValue.intValue();
        }
        long val = this.dictionary.stringToId((CharSequence)str, role);
        if (val > 0L) {
            this.cacheNodeToId[role.ordinal()].put(str, val);
        }
        return val;
    }

    public static String nodeToStr(Node node, PrefixMapping map) {
        if (node.isURI()) {
            return map.expandPrefix(node.getURI());
        }
        return NodeDictionary.nodeToStr(node);
    }

    public static String nodeToStr(Node node) {
        if (node == null || node.isVariable()) {
            return "";
        }
        return JenaNodeFormatter.format((Node)node);
    }

    public TripleID getTripleID(Triple triple, PrefixMapping map) {
        return new TripleID(this.getIntID(NodeDictionary.nodeToStr(triple.getSubject(), map), TripleComponentRole.SUBJECT), this.getIntID(NodeDictionary.nodeToStr(triple.getPredicate(), map), TripleComponentRole.PREDICATE), this.getIntID(NodeDictionary.nodeToStr(triple.getObject(), map), TripleComponentRole.OBJECT));
    }

    public TripleID getTriplePatID(Triple jenaTriple) {
        long subject = 0L;
        long predicate = 0L;
        long object = 0L;
        if (jenaTriple.getMatchSubject() != null) {
            subject = this.getIntID(jenaTriple.getMatchSubject(), TripleComponentRole.SUBJECT);
        }
        if (jenaTriple.getMatchPredicate() != null) {
            predicate = this.getIntID(jenaTriple.getMatchPredicate(), TripleComponentRole.PREDICATE);
        }
        if (jenaTriple.getMatchObject() != null) {
            object = this.getIntID(jenaTriple.getMatchObject(), TripleComponentRole.OBJECT);
        }
        return new TripleID(subject, predicate, object);
    }

    public static PrefixMapping getMapping(ExecutionContext ctx) {
        Query query = (Query)ctx.getContext().get(ARQConstants.sysCurrentQuery);
        return query.getPrefixMapping();
    }

    public static final Var asVar(Node node) {
        if (Var.isVar((Node)node)) {
            return Var.alloc((Node)node);
        }
        return null;
    }

    public static long translate(NodeDictionary dictionary, HDTId id, TripleComponentRole role) {
        if (id.getValue() == -1L) {
            return -1L;
        }
        if (dictionary == id.getDictionary()) {
            if (role == id.getRole()) {
                return id.getValue();
            }
            if (NodeDictionary.isSO(role) && NodeDictionary.isSO(id.getRole())) {
                return id.getValue() <= dictionary.dictionary.getNshared() ? id.getValue() : -1L;
            }
        }
        NodeDictionary dict2 = id.getDictionary();
        CharSequence str = dict2.dictionary.idToString(id.getValue(), id.getRole());
        return dictionary.getIntID(str.toString(), role);
    }

    private static boolean isSO(TripleComponentRole role) {
        return role == TripleComponentRole.SUBJECT || role == TripleComponentRole.OBJECT;
    }
}

