/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import org.apache.jena.graph.Node;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.iterator.SuppliableIteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.NodeDictionary;

public class HDTStatistics {
    private final NodeDictionary nodeDictionary;
    private final HDT hdt;

    public HDTStatistics(HDTGraph graph) {
        this.nodeDictionary = graph.getNodeDictionary();
        this.hdt = graph.getHDT();
    }

    public long getNumberOfMatches(Node subject, Node predicate, Node object) {
        try {
            BitmapTriples triples = (BitmapTriples)this.hdt.getTriples();
            if (subject.isVariable() && predicate.isVariable() && object.isVariable()) {
                return triples.getNumberOfElements();
            }
            long s = this.nodeDictionary.getIntID(subject, TripleComponentRole.SUBJECT);
            long p = this.nodeDictionary.getIntID(predicate, TripleComponentRole.PREDICATE);
            long o = this.nodeDictionary.getIntID(object, TripleComponentRole.OBJECT);
            if (s < 0L || p < 0L || o < 0L) {
                return 0L;
            }
            if (p > 0L && s == 0L && o == 0L && triples instanceof BitmapTriples) {
                Sequence predCount = triples.getPredicateCount();
                if (predCount != null) {
                    return predCount.get(p - 1L);
                }
                long pred = this.hdt.getDictionary().getNpredicates();
                if (pred > 0L) {
                    return triples.getNumberOfElements() / pred;
                }
                return triples.getNumberOfElements();
            }
            if (s == 0L && o != 0L && triples.getIndexZ() == null) {
                return triples.getNumberOfElements();
            }
            SuppliableIteratorTripleID it = triples.search(new TripleID(s, p, o));
            return it.estimatedNumResults();
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }
}

