/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTVersion;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.util.StopWatch;

public class HDTCat
implements ProgressListener {
    public String hdtInput1;
    public String hdtInput2;
    public String hdtOutput;
    @Parameter(description="<input HDT1> <input HDT2> <output HDT>")
    public List<String> parameters = Lists.newArrayList();
    @Parameter(names={"-options"}, description="HDT Conversion options (override those of config file)")
    public String options;
    @Parameter(names={"-config"}, description="Conversion config file")
    public String configFile;
    @Parameter(names={"-index"}, description="Generate also external indices to solve all queries")
    public boolean generateIndex;
    @Parameter(names={"-version"}, description="Prints the HDT version number")
    public static boolean showVersion;
    @Parameter(names={"-quiet"}, description="Do not show progress of the conversion")
    public boolean quiet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ParserException, IOException {
        HDTSpecification spec = this.configFile != null ? new HDTSpecification(this.configFile) : new HDTSpecification();
        if (this.options != null) {
            spec.setOptions(this.options);
        }
        File file = new File(this.hdtOutput);
        File theDir = new File(file.getAbsolutePath() + "_tmp");
        theDir.mkdirs();
        String location = theDir.getAbsolutePath() + "/";
        try (HDT hdt = HDTManager.catHDT((String)location, (String)this.hdtInput1, (String)this.hdtInput2, (HDTOptions)spec, (ProgressListener)this);){
            if (!this.quiet) {
                System.out.println("Total Triples: " + hdt.getTriples().getNumberOfElements());
                System.out.println("Different subjects: " + hdt.getDictionary().getNsubjects());
                System.out.println("Different predicates: " + hdt.getDictionary().getNpredicates());
                System.out.println("Different objects: " + hdt.getDictionary().getNobjects());
                System.out.println("Common Subject/Object:" + hdt.getDictionary().getNshared());
            }
            StopWatch sw = new StopWatch();
            hdt.saveToHDT(this.hdtOutput, (ProgressListener)this);
            System.out.println("HDT saved to file in: " + sw.stopAndShow());
            Files.delete(Paths.get(location + "dictionary", new String[0]));
            Files.delete(Paths.get(location + "triples", new String[0]));
            theDir.delete();
            sw.reset();
            if (this.generateIndex) {
                hdt = HDTManager.indexedHDT((HDT)hdt, (ProgressListener)this);
                System.out.println("Index generated and saved in: " + sw.stopAndShow());
            }
        }
    }

    public void notifyProgress(float level, String message) {
        if (!this.quiet) {
            System.out.print("\r" + message + "\t" + Float.toString(level) + "                            \r");
        }
    }

    public static void main(String[] args) throws Throwable {
        HDTCat hdtCat = new HDTCat();
        System.out.println("Welcome to hdtCat!");
        System.out.println("This tool was developed by Dennis Diefenbach and Jos\u0301e M. Gim\u0301enez-Garc\u0301\u0131a");
        JCommander com = new JCommander((Object)hdtCat, args);
        com.setProgramName("hdtCat");
        if (hdtCat.parameters.size() == 3) {
            hdtCat.hdtInput1 = hdtCat.parameters.get(0);
            hdtCat.hdtInput2 = hdtCat.parameters.get(1);
            hdtCat.hdtOutput = hdtCat.parameters.get(2);
        } else if (showVersion) {
            System.out.println(HDTVersion.get_version_string((String)"."));
            System.exit(0);
        } else {
            com.usage();
            System.exit(1);
        }
        System.out.println("Cat " + hdtCat.hdtInput1 + " and " + hdtCat.hdtInput2 + " to " + hdtCat.hdtOutput);
        hdtCat.execute();
    }
}

