/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli.libloader;

class LoaderResult {
    private Boolean alreadyLoaded = null;
    private Boolean loadedFromSystemLibraryPath = null;
    private String nativeLibName;
    private String libNameWithinClasspath;
    private Boolean usedThisClassloader;
    private Boolean usedSystemClassloader;
    private Boolean madeReadable;
    private Boolean madeExecutable;
    private String temporaryLibFile;

    LoaderResult() {
    }

    String asFormattedString() {
        String result = "";
        result = result + "os.name=\"" + System.getProperty("os.name") + "\"";
        result = result + ", ";
        result = result + "os.arch=\"" + System.getProperty("os.arch") + "\"";
        result = result + ", ";
        result = result + "os.version=\"" + System.getProperty("os.version") + "\"";
        result = result + ", ";
        result = result + "java.vm.name=\"" + System.getProperty("java.vm.name") + "\"";
        result = result + ", ";
        result = result + "java.vm.version=\"" + System.getProperty("java.vm.version") + "\"";
        result = result + ", ";
        result = result + "java.vm.vendor=\"" + System.getProperty("java.vm.vendor") + "\"";
        result = result + ", ";
        result = result + "alreadyLoaded=\"" + this.alreadyLoaded + "\"";
        if (this.loadedFromSystemLibraryPath != null) {
            result = result + ", ";
            result = result + "loadedFromSystemLibraryPath=\"" + this.loadedFromSystemLibraryPath + "\"";
        }
        if (this.nativeLibName != null) {
            result = result + ", ";
            result = result + "nativeLibName=\"" + this.nativeLibName + "\"";
        }
        if (this.temporaryLibFile != null) {
            result = result + ", ";
            result = result + "temporaryLibFile=\"" + this.temporaryLibFile + "\"";
        }
        if (this.libNameWithinClasspath != null) {
            result = result + ", ";
            result = result + "libNameWithinClasspath=\"" + this.libNameWithinClasspath + "\"";
        }
        if (this.usedThisClassloader != null) {
            result = result + ", ";
            result = result + "usedThisClassloader=\"" + this.usedThisClassloader + "\"";
        }
        if (this.usedSystemClassloader != null) {
            result = result + ", ";
            result = result + "usedSystemClassloader=\"" + this.usedSystemClassloader + "\"";
        }
        if (this.madeReadable != null) {
            result = result + ", ";
            result = result + "madeReadable=\"" + this.madeReadable + "\"";
        }
        if (this.madeExecutable != null) {
            result = result + ", ";
            result = result + "madeExecutable=\"" + this.madeExecutable + "\"";
        }
        result = result + ", ";
        result = result + "java.library.path=\"" + System.getProperty("java.library.path") + "\"";
        return String.format("[LoaderResult: %s]", result);
    }

    void setAlreadyLoaded(Boolean alreadyLoaded) {
        this.alreadyLoaded = alreadyLoaded;
    }

    void setLoadedFromSystemLibraryPath(Boolean loadedFromSystemLibraryPath) {
        this.loadedFromSystemLibraryPath = loadedFromSystemLibraryPath;
    }

    void setNativeLibName(String nativeLibName) {
        this.nativeLibName = nativeLibName;
    }

    void setLibNameWithinClasspath(String libNameWithinClasspath) {
        this.libNameWithinClasspath = libNameWithinClasspath;
    }

    void setTemporaryLibFile(String temporaryLibFile) {
        this.temporaryLibFile = temporaryLibFile;
    }

    void setUsedThisClassloader(boolean usedThisClassloader) {
        this.usedThisClassloader = usedThisClassloader;
    }

    boolean isUsedThisClassloader() {
        return Boolean.TRUE.equals(this.usedThisClassloader);
    }

    void setUsedSystemClassloader(boolean usedSystemClassloader) {
        this.usedSystemClassloader = usedSystemClassloader;
    }

    boolean isUsedSystemClassloader() {
        return Boolean.TRUE.equals(this.usedSystemClassloader);
    }

    void setMadeReadable(boolean madeReadable) {
        this.madeReadable = madeReadable;
    }

    void setMadeExecutable(boolean madeExecutable) {
        this.madeExecutable = madeExecutable;
    }
}

