/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli.io;

import java.io.IOException;
import java.io.OutputStream;
import org.meteogroup.jbrotli.Brotli;
import org.meteogroup.jbrotli.BrotliException;
import org.meteogroup.jbrotli.BrotliStreamCompressor;

public class BrotliOutputStream
extends OutputStream {
    private final BrotliStreamCompressor brotliStreamCompressor;
    private final OutputStream outputStream;

    public BrotliOutputStream(OutputStream outputStream) {
        this(outputStream, Brotli.DEFAULT_PARAMETER);
    }

    public BrotliOutputStream(OutputStream outputStream, Brotli.Parameter parameter) {
        this.outputStream = outputStream;
        this.brotliStreamCompressor = new BrotliStreamCompressor(parameter);
    }

    @Override
    public void write(int i) throws IOException {
        byte[] buf = new byte[]{(byte)(i & 0xFF)};
        byte[] compressedBuf = this.brotliStreamCompressor.compressArray(buf, false);
        if (compressedBuf.length > 0) {
            this.outputStream.write(compressedBuf);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        int maxInputBufferSize = this.brotliStreamCompressor.getMaxInputBufferSize();
        while (len > 0) {
            boolean doFlush;
            int stepSize = Math.min(maxInputBufferSize, len);
            byte[] compressedBuf = this.brotliStreamCompressor.compressArray(buffer, offset, stepSize, doFlush = len <= maxInputBufferSize);
            if (compressedBuf.length > 0) {
                this.outputStream.write(compressedBuf);
            }
            offset += stepSize;
            len -= stepSize;
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.write(this.brotliStreamCompressor.compressArray(new byte[0], true));
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.brotliStreamCompressor.close();
        this.outputStream.close();
    }

    public int getBrotliCompressionBufferSize() throws BrotliException {
        return this.brotliStreamCompressor.getMaxInputBufferSize();
    }
}

