/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.meteogroup.jbrotli.BrotliErrorChecker;
import org.meteogroup.jbrotli.BrotliException;
import org.meteogroup.jbrotli.DeCompressorResult;
import org.meteogroup.jbrotli.NativeDeCompressorResult;

public final class BrotliStreamDeCompressor
implements Closeable {
    private final long brotliDeCompressorState = 0L;
    private int lastErrorCode = 0;

    public BrotliStreamDeCompressor() throws BrotliException {
        BrotliErrorChecker.assertBrotliOk(this.initBrotliDeCompressor());
    }

    public final DeCompressorResult deCompress(byte[] in, byte[] out) {
        return this.deCompress(in, 0, in.length, out, 0, out.length);
    }

    public final DeCompressorResult deCompress(byte[] in, int inPosition, int inLength, byte[] out, int outPosition, int outLength) throws BrotliException {
        if (inPosition + inLength > in.length) {
            throw new IllegalArgumentException("The source position + length must me smaller then the source byte array's length.");
        }
        NativeDeCompressorResult nativeResult = this.deCompressBytes(in, inPosition, inLength, out, outPosition, outLength);
        DeCompressorResult result = new DeCompressorResult(nativeResult);
        this.lastErrorCode = nativeResult.errorCode;
        if (this.lastErrorCode == -33 || this.lastErrorCode == -34) {
            return result;
        }
        BrotliErrorChecker.assertBrotliOk(this.lastErrorCode);
        return result;
    }

    public boolean needsMoreInput() {
        return this.lastErrorCode == -33;
    }

    public boolean needsMoreOutput() {
        return this.lastErrorCode == -34;
    }

    public final int deCompress(ByteBuffer in, ByteBuffer out) throws BrotliException {
        NativeDeCompressorResult result;
        int inPosition = in.position();
        int inLimit = in.limit();
        int inRemain = inLimit - inPosition;
        if (inRemain < 0) {
            throw new IllegalArgumentException("Input buffer is empty: " + in);
        }
        int outPosition = out.position();
        int outRemain = out.limit() - outPosition;
        if (outRemain < 0) {
            throw new IllegalArgumentException("Output buffer is already full: " + out);
        }
        if (in.isDirect() && out.isDirect()) {
            result = this.deCompressByteBuffer(in, inPosition, inRemain, out, outPosition, outRemain);
        } else if (in.hasArray() && out.hasArray()) {
            result = this.deCompressBytes(in.array(), inPosition + in.arrayOffset(), inRemain, out.array(), outPosition + out.arrayOffset(), outRemain);
        } else {
            throw new UnsupportedOperationException("Not supported ByteBuffer implementation. Both (input and output) buffer has to be of the same type. Use either direct BB or wrapped byte arrays. You may raise an issue on GitHub too ;-)");
        }
        this.lastErrorCode = result.errorCode;
        switch (this.lastErrorCode) {
            case -33: {
                break;
            }
            case -34: {
                break;
            }
            default: {
                BrotliErrorChecker.assertBrotliOk(this.lastErrorCode);
            }
        }
        in.position(inPosition + result.bytesConsumed);
        out.limit(outPosition + result.bytesProduced);
        return result.bytesProduced;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() throws BrotliException {
        this.lastErrorCode = 0;
        BrotliErrorChecker.assertBrotliOk(this.freeNativeResources());
    }

    private static native int initJavaFieldIdCache();

    private native int initBrotliDeCompressor();

    private native int freeNativeResources();

    private native NativeDeCompressorResult deCompressBytes(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    private native NativeDeCompressorResult deCompressByteBuffer(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    static {
        BrotliErrorChecker.assertBrotliOk(BrotliStreamDeCompressor.initJavaFieldIdCache());
    }
}

