/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli;

import java.nio.ByteBuffer;
import org.meteogroup.jbrotli.BrotliErrorChecker;
import org.meteogroup.jbrotli.BrotliException;

public final class BrotliDeCompressor {
    public final int deCompress(byte[] in, byte[] out) throws BrotliException {
        return this.deCompress(in, 0, in.length, out, 0, out.length);
    }

    public final int deCompress(byte[] in, int inPosition, int inLength, byte[] out, int outPosition, int outLength) throws BrotliException {
        if (inPosition + inLength > in.length) {
            throw new IllegalArgumentException("The input array position and length must me smaller then the source byte array's length.");
        }
        if (outPosition + outLength > out.length) {
            throw new IllegalArgumentException("The output array position and length must me smaller then the source byte array's length.");
        }
        return BrotliErrorChecker.assertBrotliOk(BrotliDeCompressor.deCompressBytes(in, inPosition, inLength, out, outPosition, outLength));
    }

    public final int deCompress(ByteBuffer in, ByteBuffer out) throws BrotliException {
        int outLength;
        int inPosition = in.position();
        int inLimit = in.limit();
        int inRemain = inLimit - inPosition;
        if (inRemain <= 0) {
            throw new IllegalArgumentException("The source (in) position must me smaller then the source ByteBuffer's limit.");
        }
        int outPosition = out.position();
        int outLimit = out.limit();
        int outRemain = outLimit - outPosition;
        if (outRemain <= 0) {
            throw new IllegalArgumentException("The destination (out) position must me smaller then the source ByteBuffer's limit.");
        }
        if (in.isDirect() && out.isDirect()) {
            outLength = BrotliErrorChecker.assertBrotliOk(BrotliDeCompressor.deCompressByteBuffer(in, inPosition, inRemain, out, outPosition, outRemain));
        } else if (in.hasArray() && out.hasArray()) {
            outLength = BrotliErrorChecker.assertBrotliOk(BrotliDeCompressor.deCompressBytes(in.array(), inPosition + in.arrayOffset(), inRemain, out.array(), outPosition + out.arrayOffset(), outRemain));
        } else {
            throw new UnsupportedOperationException("Not supported ByteBuffer implementation. Both (input and output) buffer has to be of the same type. Use either direct BB or wrapped byte arrays. You may raise an issue on GitHub too ;-)");
        }
        in.position(inLimit);
        out.limit(outPosition + outLength);
        return outLength;
    }

    private static native int deCompressBytes(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5);

    private static native int deCompressByteBuffer(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5);
}

