/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.brotli;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.io.compress.Decompressor;
import org.meteogroup.jbrotli.BrotliStreamDeCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrotliDecompressor
implements Decompressor {
    private static final Logger LOG = LoggerFactory.getLogger(BrotliDecompressor.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final ByteBuffer outBuffer;
    private final StackTraceElement[] stack;
    private BrotliStreamDeCompressor decompressor = new BrotliStreamDeCompressor();
    private ByteBuffer inBuffer = EMPTY_BUFFER;
    private long totalBytesIn = 0L;
    private long totalBytesOut = 0L;

    public BrotliDecompressor() {
        this.outBuffer = ByteBuffer.allocate(8192);
        this.outBuffer.limit(0);
        this.stack = Thread.currentThread().getStackTrace();
    }

    private boolean hasMoreOutput() {
        return !this.isOutputBufferEmpty() || this.decompressor.needsMoreOutput();
    }

    private boolean hasMoreInput() {
        return this.inBuffer.remaining() > 0;
    }

    private boolean isOutputBufferEmpty() {
        return this.outBuffer.remaining() == 0;
    }

    private boolean isInputBufferEmpty() {
        return this.inBuffer.remaining() == 0;
    }

    public void setInput(byte[] inBytes, int off, int len) {
        Preconditions.checkState((boolean)this.isInputBufferEmpty(), (Object)"[BUG] Cannot call setInput with existing unconsumed input.");
        this.inBuffer = ByteBuffer.wrap(inBytes, off, len);
        this.getMoreOutput();
        this.totalBytesIn += (long)len;
    }

    private void getMoreOutput() {
        Preconditions.checkState((boolean)this.isOutputBufferEmpty(), (Object)"[BUG] Cannot call getMoreOutput without consuming all output.");
        this.outBuffer.clear();
        this.decompressor.deCompress(this.inBuffer, this.outBuffer);
    }

    public boolean needsInput() {
        return this.isInputBufferEmpty() && this.decompressor.needsMoreInput() && !this.hasMoreOutput();
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("Brotli decompression does not support dictionaries");
    }

    public boolean needsDictionary() {
        return false;
    }

    public boolean finished() {
        return this.isInputBufferEmpty() && !this.decompressor.needsMoreInput() && !this.hasMoreOutput();
    }

    public int decompress(byte[] out, int off, int len) throws IOException {
        int bytesCopied = 0;
        int currentOffset = off;
        if (this.isOutputBufferEmpty() && (this.hasMoreInput() || this.decompressor.needsMoreOutput())) {
            this.getMoreOutput();
        }
        while (bytesCopied < len && this.hasMoreOutput()) {
            int bytesToCopy = Math.min(len - bytesCopied, this.outBuffer.remaining());
            this.outBuffer.get(out, currentOffset, bytesToCopy);
            currentOffset += bytesToCopy;
            if (this.isOutputBufferEmpty() && (this.hasMoreInput() || this.decompressor.needsMoreOutput())) {
                this.getMoreOutput();
            }
            bytesCopied += bytesToCopy;
        }
        this.totalBytesOut += (long)bytesCopied;
        return bytesCopied;
    }

    public int getRemaining() {
        int available = this.outBuffer.remaining();
        if (available > 0) {
            return available;
        }
        if (this.decompressor.needsMoreOutput()) {
            this.getMoreOutput();
            return this.outBuffer.remaining();
        }
        if (this.decompressor.needsMoreInput()) {
            return 1;
        }
        return 0;
    }

    public void reset() {
        Preconditions.checkState((boolean)this.isOutputBufferEmpty(), (Object)"Reused without consuming all output");
        this.end();
        this.decompressor = new BrotliStreamDeCompressor();
        this.outBuffer.limit(0);
        this.inBuffer = EMPTY_BUFFER;
        this.totalBytesIn = 0L;
        this.totalBytesOut = 0L;
    }

    public void end() {
        if (!this.isOutputBufferEmpty()) {
            LOG.warn("Closed without consuming all output");
        }
        if (this.decompressor != null) {
            this.decompressor.close();
            this.decompressor = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.decompressor != null) {
            this.end();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.stack, 1, this.stack.length));
            LOG.warn("Unclosed Brotli decompression stream created by:\n\t" + trace);
        }
    }
}

