/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.PopupController;
import razerdp.basepopup.PopupWindowProxy;
import razerdp.library.R;
import razerdp.util.InputMethodUtils;
import razerdp.util.SimpleAnimUtil;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener,
PopupController {
    private static final String TAG = "BasePopupWindow";
    private PopupWindowProxy mPopupWindow;
    private View mPopupView;
    private Activity mContext;
    protected View mAnimaView;
    protected View mDismissView;
    private boolean autoShowInputMethod = false;
    private OnDismissListener mOnDismissListener;
    private OnBeforeShowCallback mOnBeforeShowCallback;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mExitAnimation;
    private Animator mExitAnimator;
    private boolean isExitAnimaPlaying = false;
    private boolean needPopupFadeAnima = true;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int popupViewWidth;
    private int popupViewHeight;
    private int[] mAnchorViewLocation;
    private boolean relativeToAnchorView;
    private boolean isAutoLocatePopup;
    private boolean showAtDown;
    private boolean dismissWhenTouchOuside;
    private int popupLayoutid;
    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = true;
        }

        public void onAnimationEnd(Animator animation) {
            BasePopupWindow.this.mPopupWindow.callSuperDismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationCancel(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    private Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            BasePopupWindow.this.isExitAnimaPlaying = true;
        }

        public void onAnimationEnd(Animation animation) {
            BasePopupWindow.this.mPopupWindow.callSuperDismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public BasePopupWindow(Activity context) {
        this.initView(context, -1, -1);
    }

    public BasePopupWindow(Activity context, int w, int h) {
        this.initView(context, w, h);
    }

    private void initView(Activity context, int w, int h) {
        this.mContext = context;
        this.mPopupView = this.onCreatePopupView();
        this.mAnimaView = this.initAnimaView();
        this.checkPopupAnimaView();
        this.mPopupWindow = new PopupWindowProxy(this.mPopupView, w, h, (PopupController)this);
        this.mPopupWindow.setOnDismissListener(this);
        this.setDismissWhenTouchOuside(true);
        this.preMeasurePopupView(w, h);
        this.setNeedPopupFade(Build.VERSION.SDK_INT <= 22);
        this.mDismissView = this.getClickToDismissView();
        if (this.mDismissView != null && !(this.mDismissView instanceof AdapterView)) {
            this.mDismissView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BasePopupWindow.this.dismiss();
                }
            });
        }
        if (this.mAnimaView != null && !(this.mAnimaView instanceof AdapterView)) {
            this.mAnimaView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
        this.mShowAnimation = this.initShowAnimation();
        this.mShowAnimator = this.initShowAnimator();
        this.mExitAnimation = this.initExitAnimation();
        this.mExitAnimator = this.initExitAnimator();
        this.mAnchorViewLocation = new int[2];
    }

    private void checkPopupAnimaView() {
        if (this.mPopupView != null && this.mAnimaView != null && this.mPopupView == this.mAnimaView) {
            try {
                this.mPopupView = new FrameLayout(this.getContext());
                if (this.popupLayoutid == 0) {
                    ((FrameLayout)this.mPopupView).addView(this.mAnimaView);
                } else {
                    this.mAnimaView = View.inflate((Context)this.getContext(), (int)this.popupLayoutid, (ViewGroup)((FrameLayout)this.mPopupView));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void preMeasurePopupView(int w, int h) {
        if (this.mPopupView != null) {
            if (Build.VERSION.SDK_INT <= 17) {
                int contentViewHeight = -1;
                ViewGroup.LayoutParams layoutParams = this.mPopupView.getLayoutParams();
                if (layoutParams != null && layoutParams.height == -2) {
                    contentViewHeight = -2;
                }
                ViewGroup.LayoutParams p = new ViewGroup.LayoutParams(-1, contentViewHeight);
                this.mPopupView.setLayoutParams(p);
            }
            this.mPopupView.measure(w, h);
            this.popupViewWidth = this.mPopupView.getMeasuredWidth();
            this.popupViewHeight = this.mPopupView.getMeasuredHeight();
            this.mPopupView.setFocusableInTouchMode(true);
        }
    }

    protected abstract Animation initShowAnimation();

    public abstract View getClickToDismissView();

    protected Animator initShowAnimator() {
        return null;
    }

    public EditText getInputView() {
        return null;
    }

    protected Animation initExitAnimation() {
        return null;
    }

    protected Animator initExitAnimator() {
        return null;
    }

    public void setNeedPopupFade(boolean needPopupFadeAnima) {
        this.needPopupFadeAnima = needPopupFadeAnima;
        this.setPopupAnimaStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
    }

    public boolean getNeedPopupFade() {
        return this.needPopupFadeAnima;
    }

    public void setPopupAnimaStyle(int animaStyleRes) {
        this.mPopupWindow.setAnimationStyle(animaStyleRes);
    }

    public void showPopupWindow() {
        if (this.checkPerformShow(null)) {
            this.tryToShowPopup(null);
        }
    }

    public void showPopupWindow(int anchorViewResid) {
        View v = this.mContext.findViewById(anchorViewResid);
        this.showPopupWindow(v);
    }

    public void showPopupWindow(View v) {
        if (this.checkPerformShow(v)) {
            this.setRelativeToAnchorView(true);
            this.tryToShowPopup(v);
        }
    }

    private void tryToShowPopup(View v) {
        try {
            if (v != null) {
                int[] offset = this.calcuateOffset(v);
                if (this.showAtDown) {
                    this.mPopupWindow.showAsDropDown(v, offset[0], offset[1]);
                } else {
                    this.mPopupWindow.showAtLocation(v, this.popupGravity, offset[0], offset[1]);
                }
            } else {
                this.mPopupWindow.showAtLocation(this.mContext.findViewById(0x1020002), this.popupGravity, this.offsetX, this.offsetY);
            }
            if (this.mShowAnimation != null && this.mAnimaView != null) {
                this.mAnimaView.clearAnimation();
                this.mAnimaView.startAnimation(this.mShowAnimation);
            }
            if (this.mShowAnimation == null && this.mShowAnimator != null && this.mAnimaView != null) {
                this.mShowAnimator.start();
            }
            if (this.autoShowInputMethod && this.getInputView() != null) {
                this.getInputView().requestFocus();
                InputMethodUtils.showInputMethod((View)this.getInputView(), 150L);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    private int[] calcuateOffset(View anchorView) {
        int[] offset = new int[]{0, 0};
        anchorView.getLocationOnScreen(this.mAnchorViewLocation);
        if (this.relativeToAnchorView) {
            offset[0] = offset[0] + this.offsetX;
            offset[1] = -anchorView.getHeight() + this.offsetY;
        }
        if (this.isAutoLocatePopup) {
            boolean onTop;
            boolean bl = onTop = this.getScreenHeight() - this.mAnchorViewLocation[1] + offset[1] < this.popupViewHeight;
            if (onTop) {
                offset[1] = offset[1] - this.popupViewHeight + this.offsetY;
                this.showOnTop(this.mPopupView);
            } else {
                this.showOnDown(this.mPopupView);
            }
        }
        return offset;
    }

    public void setAdjustInputMethod(boolean needAdjust) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(16);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
        }
    }

    public void setAutoShowInputMethod(boolean autoShow) {
        this.autoShowInputMethod = autoShow;
        if (autoShow) {
            this.setAdjustInputMethod(true);
        } else {
            this.setAdjustInputMethod(false);
        }
    }

    public void setBackPressEnable(boolean backPressEnable) {
        if (backPressEnable) {
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        } else {
            this.mPopupWindow.setBackgroundDrawable(null);
        }
    }

    public View createPopupById(int resId) {
        if (resId != 0) {
            this.popupLayoutid = resId;
            return LayoutInflater.from((Context)this.mContext).inflate(resId, null);
        }
        return null;
    }

    protected View findViewById(int id2) {
        if (this.mPopupView != null && id2 != 0) {
            return this.mPopupView.findViewById(id2);
        }
        return null;
    }

    public void setPopupWindowFullScreen(boolean needFullScreen) {
        this.fitPopupWindowOverStatusBar(needFullScreen);
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    private void fitPopupWindowOverStatusBar(boolean needFullScreen) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Field mLayoutInScreen = PopupWindow.class.getDeclaredField("mLayoutInScreen");
                mLayoutInScreen.setAccessible(true);
                mLayoutInScreen.set((Object)this.mPopupWindow, needFullScreen);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    public void setOnBeforeShowCallback(OnBeforeShowCallback mOnBeforeShowCallback) {
        this.mOnBeforeShowCallback = mOnBeforeShowCallback;
    }

    public void setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mShowAnimation.cancel();
        }
        if (showAnimation != null && showAnimation != this.mShowAnimation) {
            this.mShowAnimation = showAnimation;
        }
    }

    public Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    public void setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        if (showAnimator != null && showAnimator != this.mShowAnimator) {
            this.mShowAnimator = showAnimator;
        }
    }

    public Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    public void setExitAnimation(Animation exitAnimation) {
        if (this.mExitAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mExitAnimation.cancel();
        }
        if (exitAnimation != null && exitAnimation != this.mExitAnimation) {
            this.mExitAnimation = exitAnimation;
        }
    }

    public Animation getExitAnimation() {
        return this.mExitAnimation;
    }

    public void setExitAnimator(Animator exitAnimator) {
        if (this.mExitAnimator != null) {
            this.mExitAnimator.cancel();
        }
        if (exitAnimator != null && exitAnimator != this.mExitAnimator) {
            this.mExitAnimator = exitAnimator;
        }
    }

    public Animator getExitAnimator() {
        return this.mExitAnimator;
    }

    public Context getContext() {
        return this.mContext;
    }

    public View getPopupWindowView() {
        return this.mPopupView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getPopupGravity() {
        return this.popupGravity;
    }

    public void setPopupGravity(int popupGravity) {
        this.popupGravity = popupGravity;
    }

    public boolean isRelativeToAnchorView() {
        return this.relativeToAnchorView;
    }

    public void setRelativeToAnchorView(boolean relativeToAnchorView) {
        this.setShowAtDown(true);
        this.relativeToAnchorView = relativeToAnchorView;
    }

    public boolean isAutoLocatePopup() {
        return this.isAutoLocatePopup;
    }

    public void setAutoLocatePopup(boolean autoLocatePopup) {
        this.setShowAtDown(true);
        this.isAutoLocatePopup = autoLocatePopup;
    }

    public int getPopupViewWidth() {
        return this.popupViewWidth;
    }

    public int getPopupViewHeight() {
        return this.popupViewHeight;
    }

    public boolean isShowAtDown() {
        return this.showAtDown;
    }

    public void setShowAtDown(boolean showAtDown) {
        this.showAtDown = showAtDown;
    }

    public void setDismissWhenTouchOuside(boolean dismissWhenTouchOuside) {
        this.dismissWhenTouchOuside = dismissWhenTouchOuside;
        if (dismissWhenTouchOuside) {
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setOutsideTouchable(true);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        } else {
            this.mPopupWindow.setFocusable(false);
            this.mPopupWindow.setOutsideTouchable(false);
            this.mPopupWindow.setBackgroundDrawable(null);
        }
    }

    public boolean isDismissWhenTouchOuside() {
        return this.dismissWhenTouchOuside;
    }

    public void dismiss() {
        try {
            this.mPopupWindow.dismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
        }
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.checkPerformDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        boolean hasAnima = false;
        if (this.mExitAnimation != null && this.mAnimaView != null) {
            if (!this.isExitAnimaPlaying) {
                this.mExitAnimation.setAnimationListener(this.mAnimationListener);
                this.mAnimaView.clearAnimation();
                this.mAnimaView.startAnimation(this.mExitAnimation);
                this.isExitAnimaPlaying = true;
                hasAnima = true;
            }
        } else if (this.mExitAnimator != null && !this.isExitAnimaPlaying) {
            this.mExitAnimator.removeListener(this.mAnimatorListener);
            this.mExitAnimator.addListener(this.mAnimatorListener);
            this.mExitAnimator.start();
            this.isExitAnimaPlaying = true;
            hasAnima = true;
        }
        return !hasAnima;
    }

    public void dismissWithOutAnima() {
        if (!this.checkPerformDismiss()) {
            return;
        }
        try {
            if (this.mExitAnimation != null && this.mAnimaView != null) {
                this.mAnimaView.clearAnimation();
            }
            if (this.mExitAnimator != null) {
                this.mExitAnimator.removeAllListeners();
            }
            this.mPopupWindow.callSuperDismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
        }
    }

    private boolean checkPerformDismiss() {
        boolean callDismiss = true;
        if (this.mOnDismissListener != null) {
            callDismiss = this.mOnDismissListener.onBeforeDismiss();
        }
        return callDismiss && !this.isExitAnimaPlaying;
    }

    private boolean checkPerformShow(View v) {
        boolean result = true;
        if (this.mOnBeforeShowCallback != null) {
            result = this.mOnBeforeShowCallback.onBeforeShow(this.mPopupView, v, this.mShowAnimation != null || this.mShowAnimator != null);
        }
        return result;
    }

    protected Animation getTranslateAnimation(int start, int end, int durationMillis) {
        return SimpleAnimUtil.getTranslateAnimation(start, end, durationMillis);
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        return SimpleAnimUtil.getScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
    }

    protected Animation getDefaultScaleAnimation() {
        return SimpleAnimUtil.getDefaultScaleAnimation();
    }

    protected Animation getDefaultAlphaAnimation() {
        return SimpleAnimUtil.getDefaultAlphaAnimation();
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        return SimpleAnimUtil.getDefaultSlideFromBottomAnimationSet(this.mAnimaView);
    }

    public int getScreenHeight() {
        return this.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public int getScreenWidth() {
        return this.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    protected void showOnTop(View mPopupView) {
    }

    protected void showOnDown(View mPopupView) {
    }

    public void onDismiss() {
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
        this.isExitAnimaPlaying = false;
    }

    public static abstract class OnDismissListener
    implements PopupWindow.OnDismissListener {
        public boolean onBeforeDismiss() {
            return true;
        }
    }

    public static interface OnBeforeShowCallback {
        public boolean onBeforeShow(View var1, View var2, boolean var3);
    }
}

