/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.util.Property;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import razerdp.util.PopupUtils;
import razerdp.util.animation.BaseAnimationConfig;
import razerdp.util.animation.Direction;
import razerdp.util.animation.FloatPropertyCompat;
import razerdp.util.log.PopupLog;

public class TranslationConfig
extends BaseAnimationConfig<TranslationConfig> {
    private static final String TAG = "TranslationConfig";
    float fromX;
    float toX;
    float fromY;
    float toY;
    boolean isPercentageFromX;
    boolean isPercentageToX;
    boolean isPercentageFromY;
    boolean isPercentageToY;
    public static final TranslationConfig FROM_LEFT = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.LEFT);
        }
    };
    public static final TranslationConfig FROM_TOP = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.TOP);
        }
    };
    public static final TranslationConfig FROM_RIGHT = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.RIGHT);
        }
    };
    public static final TranslationConfig FROM_BOTTOM = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.from(Direction.BOTTOM);
        }
    };
    public static final TranslationConfig TO_LEFT = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.to(Direction.LEFT);
        }
    };
    public static final TranslationConfig TO_TOP = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.to(Direction.TOP);
        }
    };
    public static final TranslationConfig TO_RIGHT = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.to(Direction.RIGHT);
        }
    };
    public static final TranslationConfig TO_BOTTOM = new TranslationConfig(true, true){

        @Override
        void resetInternal() {
            super.resetInternal();
            this.to(Direction.BOTTOM);
        }
    };

    @Override
    void resetInternal() {
        this.toY = 0.0f;
        this.fromY = 0.0f;
        this.toX = 0.0f;
        this.fromX = 0.0f;
        this.isPercentageToY = false;
        this.isPercentageFromY = false;
        this.isPercentageToX = false;
        this.isPercentageFromX = false;
    }

    public TranslationConfig() {
        super(false, false);
        this.resetInternal();
    }

    TranslationConfig(boolean resetParent, boolean resetInternal) {
        super(resetParent, resetInternal);
        this.resetInternal();
    }

    public TranslationConfig from(Direction ... directions) {
        if (directions != null) {
            this.fromY = 0.0f;
            this.fromX = 0.0f;
            int flag = 0;
            for (Direction direction : directions) {
                flag |= direction.flag;
            }
            PopupLog.i(TAG, "from", PopupUtils.gravityToString(flag));
            if (Direction.isDirectionFlag(Direction.LEFT, flag)) {
                this.fromX(this.fromX - 1.0f, true);
            }
            if (Direction.isDirectionFlag(Direction.RIGHT, flag)) {
                this.fromX(this.fromX + 1.0f, true);
            }
            if (Direction.isDirectionFlag(Direction.CENTER_HORIZONTAL, flag)) {
                this.fromX(this.fromX + 0.5f, true);
            }
            if (Direction.isDirectionFlag(Direction.TOP, flag)) {
                this.fromY(this.fromY - 1.0f, true);
            }
            if (Direction.isDirectionFlag(Direction.BOTTOM, flag)) {
                this.fromY(this.fromY + 1.0f, true);
            }
            if (Direction.isDirectionFlag(Direction.CENTER_VERTICAL, flag)) {
                this.fromY(this.fromY + 0.5f, true);
            }
            this.isPercentageToY = true;
            this.isPercentageToX = true;
            this.isPercentageFromY = true;
            this.isPercentageFromX = true;
        }
        return this;
    }

    public TranslationConfig to(Direction ... directions) {
        if (directions != null) {
            this.toY = 0.0f;
            this.toX = 0.0f;
            int flag = 0;
            for (Direction direction : directions) {
                flag |= direction.flag;
            }
            PopupLog.i(TAG, "to", PopupUtils.gravityToString(flag));
            if (Direction.isDirectionFlag(Direction.LEFT, flag)) {
                this.toX += -1.0f;
            }
            if (Direction.isDirectionFlag(Direction.RIGHT, flag)) {
                this.toX += 1.0f;
            }
            if (Direction.isDirectionFlag(Direction.CENTER_HORIZONTAL, flag)) {
                this.toX += 0.5f;
            }
            if (Direction.isDirectionFlag(Direction.TOP, flag)) {
                this.toY += -1.0f;
            }
            if (Direction.isDirectionFlag(Direction.BOTTOM, flag)) {
                this.toY += 1.0f;
            }
            if (Direction.isDirectionFlag(Direction.CENTER_VERTICAL, flag)) {
                this.toY += 0.5f;
            }
            this.isPercentageToY = true;
            this.isPercentageToX = true;
            this.isPercentageFromY = true;
            this.isPercentageFromX = true;
        }
        return this;
    }

    public TranslationConfig fromX(float fromX) {
        this.fromX(fromX, true);
        return this;
    }

    public TranslationConfig toX(float toX) {
        this.toX(toX, true);
        return this;
    }

    public TranslationConfig fromY(float fromY) {
        this.fromY(fromY, true);
        return this;
    }

    public TranslationConfig toY(float toY) {
        this.toY(toY, true);
        return this;
    }

    public TranslationConfig fromX(int fromX) {
        this.fromX(fromX, false);
        return this;
    }

    public TranslationConfig toX(int toX) {
        this.toX(toX, false);
        return this;
    }

    public TranslationConfig fromY(int fromY) {
        this.fromY(fromY, false);
        return this;
    }

    public TranslationConfig toY(int toY) {
        this.toY(toY, false);
        return this;
    }

    TranslationConfig fromX(float fromX, boolean percentage) {
        this.isPercentageFromX = percentage;
        this.fromX = fromX;
        return this;
    }

    TranslationConfig toX(float toX, boolean percentage) {
        this.isPercentageToX = percentage;
        this.toX = toX;
        return this;
    }

    TranslationConfig fromY(float fromY, boolean percentage) {
        this.isPercentageFromY = percentage;
        this.fromY = fromY;
        return this;
    }

    TranslationConfig toY(float toY, boolean percentage) {
        this.isPercentageToY = percentage;
        this.toY = toY;
        return this;
    }

    public String toString() {
        return "TranslationConfig{fromX=" + this.fromX + ", toX=" + this.toX + ", fromY=" + this.fromY + ", toY=" + this.toY + ", isPercentageFromX=" + this.isPercentageFromX + ", isPercentageToX=" + this.isPercentageToX + ", isPercentageFromY=" + this.isPercentageFromY + ", isPercentageToY=" + this.isPercentageToY + '}';
    }

    @Override
    protected Animation buildAnimation(boolean isRevert) {
        TranslateAnimation animation = new TranslateAnimation(this.isPercentageFromX ? 1 : 0, this.fromX, this.isPercentageToX ? 1 : 0, this.toX, this.isPercentageFromY ? 1 : 0, this.fromY, this.isPercentageToY ? 1 : 0, this.toY);
        this.deploy((Animation)animation);
        return animation;
    }

    @Override
    protected Animator buildAnimator(boolean isRevert) {
        AnimatorSet animatorSet = new AnimatorSet();
        FloatPropertyCompat<Object> TRANSLATION_X = this.isPercentageFromX && this.isPercentageToY ? new FloatPropertyCompat<View>(View.TRANSLATION_X.getName()){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationX((float)object.getWidth() * value);
            }

            public Float get(View object) {
                return Float.valueOf(object.getTranslationX());
            }
        } : View.TRANSLATION_X;
        FloatPropertyCompat<Object> TRANSLATION_Y = this.isPercentageFromY && this.isPercentageToY ? new FloatPropertyCompat<View>(View.TRANSLATION_Y.getName()){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationY((float)object.getHeight() * value);
            }

            public Float get(View object) {
                return Float.valueOf(object.getTranslationY());
            }
        } : View.TRANSLATION_Y;
        ObjectAnimator translationX = ObjectAnimator.ofFloat(null, (Property)TRANSLATION_X, (float[])new float[]{this.fromX, this.toX});
        ObjectAnimator translationY = ObjectAnimator.ofFloat(null, (Property)TRANSLATION_Y, (float[])new float[]{this.fromY, this.toY});
        animatorSet.playTogether(new Animator[]{translationX, translationY});
        this.deploy((Animator)animatorSet);
        return animatorSet;
    }
}

