/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import java.lang.ref.WeakReference;

public final class BasePopupSDK {
    private static volatile Application mApplicationContext;
    private WeakReference<Activity> mTopActivity;

    private BasePopupSDK() {
    }

    synchronized void init(Context context) {
        if (mApplicationContext != null) {
            return;
        }
        mApplicationContext = (Application)context.getApplicationContext();
        this.regLifeCallback();
    }

    public Activity getTopActivity() {
        return this.mTopActivity == null ? null : (Activity)this.mTopActivity.get();
    }

    private void regLifeCallback() {
        mApplicationContext.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                if (BasePopupSDK.this.mTopActivity != null) {
                    BasePopupSDK.this.mTopActivity.clear();
                }
                BasePopupSDK.this.mTopActivity = new WeakReference<Activity>(activity);
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    public static BasePopupSDK getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static Application getApplication() {
        return mApplicationContext;
    }

    private static class SingletonHolder {
        private static BasePopupSDK INSTANCE = new BasePopupSDK();

        private SingletonHolder() {
        }
    }
}

