/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.PopupMaskLayout;
import razerdp.util.KeyboardUtils;
import razerdp.util.PopupUiUtils;
import razerdp.util.log.PopupLog;

final class PopupDecorViewProxy
extends ViewGroup
implements KeyboardUtils.OnKeyboardChangeListener,
ClearMemoryObject {
    private static final String TAG = "PopupDecorViewProxy";
    private PopupMaskLayout mMaskLayout;
    private BasePopupHelper mHelper;
    private View mTarget;
    private Rect popupRect = new Rect();
    private Rect anchorRect = new Rect();
    private Rect contentRect = new Rect();
    private Rect contentBounds = new Rect();
    private int childLeftMargin;
    private int childTopMargin;
    private int childRightMargin;
    private int childBottomMargin;
    private int[] location = new int[2];
    private Rect lastKeyboardBounds = new Rect();
    private View.OnClickListener emptyInterceptClickListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    private PopupDecorViewProxy(Context context) {
        super(context);
    }

    PopupDecorViewProxy(Context context, BasePopupHelper helper) {
        this(context);
        this.init(helper);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(BasePopupHelper helper) {
        this.mHelper = helper;
        this.mHelper.mKeyboardStateChangeListener = this;
        this.setClipChildren(this.mHelper.isClipChildren());
        this.mMaskLayout = new PopupMaskLayout(this.getContext(), this.mHelper);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addViewInLayout((View)this.mMaskLayout, -1, new ViewGroup.LayoutParams(-1, -1));
    }

    public void wrapPopupDecorView(View target, WindowManager.LayoutParams params) {
        if (target == null) {
            throw new NullPointerException("contentView\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (target.getParent() != null) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount >= 2) {
            this.removeViewsInLayout(1, childCount - 1);
        }
        this.mTarget = target;
        target.setOnClickListener(this.emptyInterceptClickListener);
        WindowManager.LayoutParams wp = new WindowManager.LayoutParams();
        wp.copyFrom(params);
        wp.x = 0;
        wp.y = 0;
        View contentView = target.findViewById(this.mHelper.contentRootId);
        if (contentView != null) {
            ViewGroup.LayoutParams lp = contentView.getLayoutParams();
            if (lp == null) {
                lp = new FrameLayout.LayoutParams(this.mHelper.getLayoutParams());
            } else {
                lp.width = this.mHelper.getLayoutParams().width;
                lp.height = this.mHelper.getLayoutParams().height;
                if (lp instanceof ViewGroup.MarginLayoutParams) {
                    ((ViewGroup.MarginLayoutParams)lp).leftMargin = this.mHelper.getLayoutParams().leftMargin;
                    ((ViewGroup.MarginLayoutParams)lp).topMargin = this.mHelper.getLayoutParams().topMargin;
                    ((ViewGroup.MarginLayoutParams)lp).rightMargin = this.mHelper.getLayoutParams().rightMargin;
                    ((ViewGroup.MarginLayoutParams)lp).bottomMargin = this.mHelper.getLayoutParams().bottomMargin;
                }
            }
            View parent = (View)contentView.getParent();
            if (PopupUiUtils.isPopupBackgroundView(parent)) {
                ViewGroup.LayoutParams p = parent.getLayoutParams();
                if (p == null) {
                    p = new ViewGroup.LayoutParams(lp);
                } else {
                    p.width = lp.width;
                    p.height = lp.height;
                }
                parent.setLayoutParams(p);
            }
            contentView.setLayoutParams(lp);
            if (contentView.isFocusable()) {
                if (contentView instanceof ViewGroup) {
                    ((ViewGroup)contentView).setDescendantFocusability(262144);
                }
                PopupUiUtils.requestFocus(contentView);
            }
            if (this.mHelper.isAutoShowInputMethod()) {
                EditText focusTarget = this.mHelper.mAutoShowInputEdittext;
                if (focusTarget == null) {
                    focusTarget = contentView.findFocus();
                }
                KeyboardUtils.open((View)(focusTarget == null ? contentView : focusTarget), 350L);
            }
        }
        wp.width = this.mHelper.getLayoutParams().width;
        wp.height = this.mHelper.getLayoutParams().height;
        this.childLeftMargin = this.mHelper.getLayoutParams().leftMargin;
        this.childTopMargin = this.mHelper.getLayoutParams().topMargin;
        this.childRightMargin = this.mHelper.getLayoutParams().rightMargin;
        this.childBottomMargin = this.mHelper.getLayoutParams().bottomMargin;
        this.mHelper.refreshNavigationBarBounds();
        this.addView(target, (ViewGroup.LayoutParams)wp);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mMaskLayout) {
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                continue;
            }
            this.measureWrappedDecorView(child, widthMeasureSpec, heightMeasureSpec);
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    private void measureWrappedDecorView(View mTarget, int widthMeasureSpec, int heightMeasureSpec) {
        if (mTarget == null || mTarget.getVisibility() == 8) {
            return;
        }
        ViewGroup.LayoutParams lp = mTarget.getLayoutParams();
        widthMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
        heightMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int gravity = this.mHelper.getPopupGravity();
        int navigationBarGravity = this.mHelper.getNavigationBarGravity();
        int navigationBarSize = this.mHelper.getNavigationBarSize();
        if (this.mHelper.isWithAnchor()) {
            Rect anchorBound = this.mHelper.getAnchorViewBound();
            int rl = anchorBound.left;
            int rt = anchorBound.top;
            int rr = widthSize - anchorBound.right;
            int rb = heightSize - anchorBound.bottom;
            if (this.mHelper.horizontalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE) {
                rl = widthSize - anchorBound.left;
                rr = anchorBound.right;
            }
            if (this.mHelper.verticalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE) {
                rt = heightSize - anchorBound.top;
                rb = anchorBound.bottom;
            }
            switch (navigationBarGravity) {
                case 3: {
                    rl -= navigationBarSize;
                    break;
                }
                case 48: {
                    rt -= navigationBarSize;
                    break;
                }
                case 5: {
                    rr -= navigationBarSize;
                    break;
                }
                case 80: {
                    rb -= navigationBarSize;
                }
            }
            switch (gravity & 7) {
                case 3: {
                    if (lp.width == -1) {
                        widthSize = rl;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    widthSize = Math.min(widthSize, rl);
                    break;
                }
                case 5: {
                    if (lp.width == -1) {
                        widthSize = rr;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    widthSize = Math.min(widthSize, rr);
                    break;
                }
            }
            switch (gravity & 0x70) {
                case 48: {
                    if (lp.height == -1) {
                        heightSize = rt;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    heightSize = Math.min(heightSize, rt);
                    break;
                }
                case 80: {
                    if (lp.height == -1) {
                        heightSize = rb;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    heightSize = Math.min(heightSize, rb);
                    break;
                }
            }
        } else {
            switch (navigationBarGravity) {
                case 3: 
                case 5: {
                    widthSize -= navigationBarSize;
                    break;
                }
                case 48: 
                case 80: {
                    heightSize -= navigationBarSize;
                }
            }
        }
        if (this.mHelper.isAlignAnchorWidth()) {
            widthSize = this.mHelper.getAnchorViewBound().width();
            widthMode = 0x40000000;
        }
        if (this.mHelper.isAlignAnchorHeight()) {
            heightSize = this.mHelper.getAnchorViewBound().height();
            heightMode = 0x40000000;
        }
        if (this.mHelper.getMinWidth() > 0 && widthSize < this.mHelper.getMinWidth()) {
            widthSize = this.mHelper.getMinWidth();
            widthMode = 0x40000000;
        }
        if (this.mHelper.getMaxWidth() > 0 && widthSize > this.mHelper.getMaxWidth()) {
            widthSize = this.mHelper.getMaxWidth();
            widthMode = 0x40000000;
        }
        if (this.mHelper.getMinHeight() > 0 && heightSize < this.mHelper.getMinHeight()) {
            heightSize = this.mHelper.getMinHeight();
            heightMode = 0x40000000;
        }
        if (this.mHelper.getMaxHeight() > 0 && heightSize > this.mHelper.getMaxHeight()) {
            heightSize = this.mHelper.getMaxHeight();
            heightMode = 0x40000000;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        mTarget.measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutInternal(l, t, r, b);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void layoutInternal(int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isOutsideScreen;
            boolean delayLayoutMask;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            this.contentBounds.set(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
            int navigationBarGravity = this.mHelper.getNavigationBarGravity();
            int navigationBarSize = this.mHelper.getNavigationBarSize();
            switch (navigationBarGravity) {
                case 3: {
                    this.contentBounds.left += navigationBarSize;
                    break;
                }
                case 5: {
                    this.contentBounds.right -= navigationBarSize;
                    break;
                }
                case 48: {
                    this.contentBounds.top += navigationBarSize;
                    break;
                }
                case 80: {
                    this.contentBounds.bottom -= navigationBarSize;
                }
            }
            int gravity = this.mHelper.getPopupGravity();
            int offsetX = this.mHelper.getOffsetX();
            int offsetY = this.mHelper.getOffsetY();
            boolean bl = delayLayoutMask = this.mHelper.isAlignBackground() && this.mHelper.getAlignBackgroundGravity() != 0;
            if (child == this.mMaskLayout) {
                child.layout(this.contentBounds.left, this.contentBounds.top, this.contentBounds.left + this.getMeasuredWidth(), this.contentBounds.top + this.getMeasuredHeight());
                continue;
            }
            Rect anchorBound = this.mHelper.getAnchorViewBound();
            boolean isRelativeToAnchor = this.mHelper.isWithAnchor();
            boolean isHorizontalAlignAnchorSlide = this.mHelper.horizontalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
            boolean isVerticalAlignAnchorSlide = this.mHelper.verticalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
            switch (gravity & 7) {
                case 3: {
                    this.contentRect.left = isRelativeToAnchor ? (isHorizontalAlignAnchorSlide ? anchorBound.left : anchorBound.left - width) : this.contentBounds.left;
                    if (this.mHelper.layoutDirection != 1) break;
                    offsetX = ~offsetX + 1;
                    break;
                }
                case 5: {
                    if (isRelativeToAnchor) {
                        this.contentRect.left = isHorizontalAlignAnchorSlide ? anchorBound.right - width : anchorBound.right;
                        break;
                    }
                    this.contentRect.left = this.contentBounds.right - width;
                    break;
                }
                case 1: {
                    if (isRelativeToAnchor) {
                        this.contentRect.left = anchorBound.left;
                        offsetX += anchorBound.centerX() - (this.contentRect.left + (width >> 1));
                        break;
                    }
                    this.contentRect.left = this.contentBounds.left + (this.contentBounds.width() - width >> 1);
                    break;
                }
                default: {
                    this.contentRect.left = isRelativeToAnchor ? anchorBound.left : this.contentBounds.left;
                }
            }
            this.contentRect.left += this.childLeftMargin - this.childRightMargin;
            switch (gravity & 0x70) {
                case 48: {
                    if (isRelativeToAnchor) {
                        this.contentRect.top = isVerticalAlignAnchorSlide ? anchorBound.top : anchorBound.top - height;
                        break;
                    }
                    this.contentRect.top = this.contentBounds.top;
                    break;
                }
                case 80: {
                    if (isRelativeToAnchor) {
                        this.contentRect.top = isVerticalAlignAnchorSlide ? anchorBound.bottom - height : anchorBound.bottom;
                        break;
                    }
                    this.contentRect.top = this.contentBounds.bottom - height;
                    break;
                }
                case 16: {
                    if (isRelativeToAnchor) {
                        this.contentRect.top = anchorBound.bottom;
                        offsetY += anchorBound.centerY() - (this.contentRect.top + (height >> 1));
                        break;
                    }
                    this.contentRect.top = this.contentBounds.top + (this.contentBounds.height() - height >> 1);
                    break;
                }
                default: {
                    this.contentRect.top = isRelativeToAnchor ? anchorBound.bottom : this.contentBounds.top;
                }
            }
            this.contentRect.top = this.contentRect.top + this.childTopMargin - this.childBottomMargin - (this.mHelper.isOverlayStatusbar() ? 0 : PopupUiUtils.getStatusBarHeight());
            if (this.mHelper.isAutoLocatePopup() && this.mHelper.isWithAnchor()) {
                int tBottom = this.contentRect.top + height + offsetY;
                switch (gravity & 0x70) {
                    case 48: {
                        int restHeight;
                        int n = restHeight = isVerticalAlignAnchorSlide ? b - anchorBound.top : anchorBound.top;
                        if (height <= restHeight) break;
                        offsetY += isVerticalAlignAnchorSlide ? 0 : anchorBound.bottom - this.contentRect.top;
                        break;
                    }
                    default: {
                        int restHeight;
                        int n = restHeight = isVerticalAlignAnchorSlide ? anchorBound.bottom : this.contentBounds.height() - anchorBound.bottom;
                        if (height <= restHeight) break;
                        offsetY -= isVerticalAlignAnchorSlide ? 0 : tBottom - anchorBound.top;
                    }
                }
            }
            this.contentRect.set(this.contentRect.left, this.contentRect.top, this.contentRect.left + width, this.contentRect.top + height);
            this.contentRect.offset(offsetX, offsetY);
            boolean bl2 = isOutsideScreen = !this.contentBounds.contains(this.contentRect);
            if (isOutsideScreen) {
                if (this.contentRect.left < this.contentBounds.left) {
                    this.contentRect.offsetTo(this.contentBounds.left, this.contentRect.top);
                }
                if (this.contentRect.right > this.contentBounds.right) {
                    int subWidth = this.contentRect.right - this.contentBounds.right;
                    if (subWidth > this.contentRect.left - this.contentBounds.left) {
                        this.contentRect.offsetTo(this.contentBounds.left, this.contentRect.top);
                        this.contentRect.right = this.contentBounds.right;
                    } else {
                        this.contentRect.offset(-subWidth, 0);
                    }
                }
                if (this.contentRect.top < this.contentBounds.top) {
                    this.contentRect.offsetTo(this.contentRect.left, this.contentBounds.top);
                }
                if (this.contentRect.bottom > this.contentBounds.bottom) {
                    int subHeight = this.contentRect.bottom - this.contentBounds.bottom;
                    if (subHeight > this.contentRect.bottom - this.contentBounds.bottom) {
                        this.contentRect.offsetTo(this.contentRect.left, this.contentBounds.top);
                        this.contentRect.bottom = this.contentBounds.bottom;
                    } else {
                        this.contentRect.offset(0, -subHeight);
                    }
                }
            }
            child.layout(this.contentRect.left, this.contentRect.top, this.contentRect.right, this.contentRect.bottom);
            if (delayLayoutMask) {
                this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), this.contentRect.left, this.contentRect.top, this.contentRect.right, this.contentRect.bottom);
            }
            if (!isRelativeToAnchor) continue;
            this.popupRect.set(this.contentRect);
            this.anchorRect.set(this.mHelper.getAnchorViewBound());
            this.mHelper.onPopupLayout(this.popupRect, this.anchorRect);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mMaskLayout != null) {
            this.mMaskLayout.handleStart(-2L);
        }
        if (this.mHelper != null) {
            this.mHelper.onAttachToWindow();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onInterceptTouchEvent(ev);
        if (intercept) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.mHelper != null) {
                PopupLog.i(TAG, "dispatchKeyEvent: >>> onBackPressed");
                return this.mHelper.onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mHelper != null && this.mHelper.onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
            if (this.mHelper != null) {
                PopupLog.i(TAG, "onTouchEvent:[ACTION_DOWN] >>> onOutSideTouch");
                return this.mHelper.onOutSideTouch();
            }
        } else if (event.getAction() == 4 && this.mHelper != null) {
            PopupLog.i(TAG, "onTouchEvent:[ACTION_OUTSIDE] >>> onOutSideTouch");
            return this.mHelper.onOutSideTouch();
        }
        return super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear(true);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void updateLayout() {
        if (this.mHelper != null) {
            this.mHelper.onUpdate();
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.update();
        }
        this.requestLayout();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        PopupDecorViewProxy v = this;
        if (this.getContext() instanceof Activity) {
            v = ((Activity)this.getContext()).getWindow().getDecorView();
        }
        v.post(new Runnable(){

            @Override
            public void run() {
                PopupDecorViewProxy.this.updateLayout();
            }
        });
    }

    @Override
    public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
        boolean process;
        if (this.mHelper.isOutSideTouchable() && !this.mHelper.isOverlayStatusbar()) {
            return;
        }
        int offset = 0;
        boolean forceAdjust = (this.mHelper.flag & 0x100000) != 0;
        boolean bl = process = forceAdjust || PopupUiUtils.getScreenOrientation() != 2 && (this.mHelper.getSoftInputMode() == 32 || this.mHelper.getSoftInputMode() == 16);
        if (!process) {
            return;
        }
        View alignWhat = null;
        if ((this.mHelper.flag & 0x10000) != 0 && this.mHelper.keybaordAlignViewId != 0) {
            alignWhat = this.mTarget.findViewById(this.mHelper.keybaordAlignViewId);
        }
        if ((this.mHelper.flag & 0x20000) != 0 || alignWhat == null) {
            alignWhat = this.mTarget;
        }
        boolean animate = (this.mHelper.flag & 0x80000) != 0;
        alignWhat.getLocationOnScreen(this.location);
        int bottom = this.location[1] + alignWhat.getHeight();
        if (isVisible && keyboardBounds.height() > 0) {
            int gravity;
            offset = keyboardBounds.top - bottom;
            if (bottom <= keyboardBounds.top && (this.mHelper.flag & 0x40000) != 0 && this.lastKeyboardBounds.isEmpty()) {
                offset = 0;
            } else if (this.mHelper.isWithAnchor() && ((gravity = PopupUiUtils.computeGravity(this.popupRect, this.anchorRect)) & 0x70) == 48) {
                offset -= this.mHelper.getAnchorViewBound().height();
            }
        }
        if (animate) {
            this.animateTranslate(this.mTarget, isVisible, offset);
        } else {
            this.mTarget.setTranslationY(isVisible ? this.mTarget.getTranslationY() + (float)offset : 0.0f);
        }
        if (isVisible) {
            this.lastKeyboardBounds.set(keyboardBounds);
        } else {
            this.lastKeyboardBounds.setEmpty();
        }
    }

    private void animateTranslate(View target, boolean isVisible, int offset) {
        target.animate().cancel();
        if (isVisible) {
            target.animate().translationYBy((float)offset).setDuration(300L).start();
        } else {
            target.animate().translationY(0.0f).setDuration(200L).start();
        }
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mHelper != null) {
            this.mHelper.mKeyboardStateChangeListener = null;
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.clear(destroy);
        }
        if (this.mTarget != null) {
            this.mTarget.setOnClickListener(null);
        }
        this.mHelper = null;
        this.mTarget = null;
    }
}

