/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import razerdp.basepopup.BasePopupSDK;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

public class PopupUiUtils {
    public static final String POPUP_DECORVIEW = "android.widget.PopupWindow$PopupDecorView";
    public static final String POPUP_VIEWCONTAINER = "android.widget.PopupWindow$PopupViewContainer";
    public static final String POPUP_BACKGROUNDVIEW = "android.widget.PopupWindow$PopupBackgroundView";
    private static final List<String> NAVIGATION_BAR_NAMES = new ArrayList<String>();
    private static int statusBarHeight;

    public static boolean isPopupDecorView(View view) {
        return view != null && TextUtils.equals((CharSequence)view.getClass().getName(), (CharSequence)POPUP_DECORVIEW);
    }

    public static boolean isPopupViewContainer(View view) {
        return view != null && TextUtils.equals((CharSequence)view.getClass().getName(), (CharSequence)POPUP_VIEWCONTAINER);
    }

    public static boolean isPopupBackgroundView(View view) {
        return view != null && TextUtils.equals((CharSequence)view.getClass().getName(), (CharSequence)POPUP_BACKGROUNDVIEW);
    }

    public static void requestFocus(View v) {
        if (v == null) {
            return;
        }
        if (v.isInTouchMode()) {
            v.requestFocusFromTouch();
        } else {
            v.requestFocus();
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int getNavigationBarHeight(Context context) {
        Activity act = PopupUtils.getActivity(context);
        if (!PopupUtils.isActivityAlive(act)) {
            return 0;
        }
        ViewGroup decorView = (ViewGroup)act.getWindow().getDecorView();
        int childCount = decorView.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = decorView.getChildAt(i);
            if (child.getId() == -1 || !child.isShown()) continue;
            try {
                String resourceEntryName = act.getResources().getResourceEntryName(child.getId());
                if (!NAVIGATION_BAR_NAMES.contains(resourceEntryName.toLowerCase())) continue;
                return child.getHeight();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getScreenOrientation() {
        return BasePopupSDK.getApplication().getResources().getConfiguration().orientation;
    }

    public static int getStatusBarHeight() {
        PopupUiUtils.checkStatusBarHeight();
        return statusBarHeight;
    }

    private static void checkStatusBarHeight() {
        if (statusBarHeight != 0) {
            return;
        }
        int result = 0;
        Resources resources = BasePopupSDK.getApplication().getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }

    public static void setBackground(View v, Drawable background) {
        if (v == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(background);
        } else {
            v.setBackgroundDrawable(background);
        }
    }

    public static void safeAddGlobalLayoutListener(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        try {
            v.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
            v.getViewTreeObserver().addOnGlobalLayoutListener(listener);
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
    }

    public static void safeRemoveGlobalLayoutListener(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        try {
            v.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
    }

    public static boolean isActivityFullScreen(Activity act) {
        if (act == null || act.getWindow() == null) {
            return false;
        }
        return (act.getWindow().getAttributes().flags & 0x400) == 1024;
    }

    public static int computeGravity(@NonNull Rect popupRect, @NonNull Rect anchorRect) {
        int gravity = 0;
        int xDelta = popupRect.centerX() - anchorRect.centerX();
        int yDelta = popupRect.centerY() - anchorRect.centerY();
        if (xDelta == 0) {
            int n = yDelta == 0 ? 17 : (gravity = 1 | (yDelta > 0 ? 80 : 48));
        }
        if (yDelta == 0) {
            int n = xDelta == 0 ? 17 : (gravity = 0x10 | (xDelta > 0 ? 5 : 3));
        }
        if (gravity == 0) {
            gravity = xDelta > 0 ? 5 : 3;
            gravity |= yDelta > 0 ? 80 : 48;
        }
        return gravity;
    }

    static {
        NAVIGATION_BAR_NAMES.add("navigationbarbackground");
        NAVIGATION_BAR_NAMES.add("immersion_navigation_bar_view");
    }
}

