/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Message;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.animation.Animation;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import java.util.Map;
import java.util.WeakHashMap;
import razerdp.basepopup.BasePopupEvent;
import razerdp.basepopup.BasePopupFlag;
import razerdp.basepopup.BasePopupSDK;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.blur.PopupBlurOption;
import razerdp.library.R;
import razerdp.util.KeyboardUtils;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

final class BasePopupHelper
implements KeyboardUtils.OnKeyboardChangeListener,
BasePopupFlag,
ClearMemoryObject {
    BasePopupWindow mPopupWindow;
    WeakHashMap<Object, BasePopupEvent.EventObserver> eventObserverMap;
    private static final int CONTENT_VIEW_ID = R.id.base_popup_content_root;
    ShowMode mShowMode = ShowMode.SCREEN;
    int contentRootId = CONTENT_VIEW_ID;
    int flag = 114781;
    static int showCount;
    Animation mShowAnimation;
    Animator mShowAnimator;
    Animation mDismissAnimation;
    Animator mDismissAnimator;
    long showDuration;
    long dismissDuration;
    BasePopupWindow.OnDismissListener mOnDismissListener;
    BasePopupWindow.OnBeforeShowCallback mOnBeforeShowCallback;
    BasePopupWindow.GravityMode gravityMode = BasePopupWindow.GravityMode.RELATIVE_TO_ANCHOR;
    int popupGravity = 0;
    int offsetX;
    int offsetY;
    int preMeasureWidth;
    int preMeasureHeight;
    int popupViewWidth = 0;
    int popupViewHeight = 0;
    Rect mAnchorViewBound;
    PopupBlurOption mBlurOption;
    Drawable mBackgroundDrawable = new ColorDrawable(BasePopupWindow.DEFAULT_BACKGROUND_COLOR);
    int alignBackgroundGravity = 48;
    View mBackgroundView;
    EditText mAutoShowInputEdittext;
    KeyboardUtils.OnKeyboardChangeListener mKeyboardStateChangeListener;
    int mSoftInputMode = 16;
    ViewGroup.MarginLayoutParams layoutParams;
    Point mTempOffset = new Point();
    int maxWidth;
    int maxHeight;
    int minWidth;
    int minHeight;
    int keybaordAlignViewId;
    InnerShowInfo mShowInfo;
    ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;
    LinkedViewLayoutChangeListenerWrapper mLinkedViewLayoutChangeListenerWrapper;
    View mLinkedTarget;

    BasePopupHelper(BasePopupWindow popupWindow) {
        this.mAnchorViewBound = new Rect();
        this.mPopupWindow = popupWindow;
        this.eventObserverMap = new WeakHashMap();
    }

    void observerEvent(Object who, BasePopupEvent.EventObserver observer) {
        this.eventObserverMap.put(who, observer);
    }

    void removeEventObserver(Object who) {
        this.eventObserverMap.remove(who);
    }

    void sendEvent(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.what < 0) {
            return;
        }
        for (Map.Entry<Object, BasePopupEvent.EventObserver> entry : this.eventObserverMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().onEvent(msg);
        }
    }

    View inflate(Context context, int layoutId) {
        try {
            FrameLayout tempLayout = new FrameLayout(context);
            View result = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)tempLayout, false);
            ViewGroup.LayoutParams childParams = result.getLayoutParams();
            if (childParams != null) {
                this.checkAndSetGravity(childParams);
                this.layoutParams = childParams instanceof ViewGroup.MarginLayoutParams ? new ViewGroup.MarginLayoutParams((ViewGroup.MarginLayoutParams)childParams) : new ViewGroup.MarginLayoutParams(childParams);
                if (this.popupViewWidth != 0 && this.layoutParams.width != this.popupViewWidth) {
                    this.layoutParams.width = this.popupViewWidth;
                }
                if (this.popupViewHeight != 0 && this.layoutParams.height != this.popupViewHeight) {
                    this.layoutParams.height = this.popupViewHeight;
                }
                tempLayout = null;
                return result;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void preMeasurePopupView(View mContentView, int w, int h) {
        if (mContentView != null) {
            int measureWidth = View.MeasureSpec.makeMeasureSpec((int)Math.max(w, 0), (int)(w == -2 ? 0 : 0x40000000));
            int measureHeight = View.MeasureSpec.makeMeasureSpec((int)Math.max(w, h), (int)(h == -2 ? 0 : 0x40000000));
            mContentView.measure(measureWidth, measureHeight);
            this.setPreMeasureWidth(mContentView.getMeasuredWidth());
            this.setPreMeasureHeight(mContentView.getMeasuredHeight());
            mContentView.setFocusableInTouchMode(true);
        }
    }

    void checkAndSetGravity(ViewGroup.LayoutParams p) {
        if (p == null) {
            return;
        }
        if (p instanceof LinearLayout.LayoutParams) {
            this.setPopupGravity(this.gravityMode, ((LinearLayout.LayoutParams)p).gravity);
        } else if (p instanceof FrameLayout.LayoutParams) {
            this.setPopupGravity(this.gravityMode, ((FrameLayout.LayoutParams)p).gravity);
        }
    }

    void startShowAnimate(int width, int height) {
        if (this.getShowAnimation(width, height) == null) {
            this.getShowAnimator(width, height);
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
            this.mPopupWindow.mDisplayAnimateView.startAnimation(this.mShowAnimation);
        } else if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
            this.mShowAnimator.start();
        }
    }

    void startDismissAnimate(int width, int height) {
        if (this.getDismissAnimation(width, height) == null) {
            this.getDismissAnimator(width, height);
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
            this.mPopupWindow.mDisplayAnimateView.startAnimation(this.mDismissAnimation);
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismissAnimationStart();
            }
            this.setFlag(0x8000000, true);
        } else if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
            this.mDismissAnimator.start();
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismissAnimationStart();
            }
            this.setFlag(0x8000000, true);
        }
    }

    Animation getShowAnimation(int width, int height) {
        if (this.mShowAnimation == null) {
            this.mShowAnimation = this.mPopupWindow.onCreateShowAnimation(width, height);
            if (this.mShowAnimation != null) {
                this.showDuration = PopupUtils.getAnimationDuration(this.mShowAnimation, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mShowAnimation;
    }

    Animator getShowAnimator(int width, int height) {
        if (this.mShowAnimator == null) {
            this.mShowAnimator = this.mPopupWindow.onCreateShowAnimator(width, height);
            if (this.mShowAnimator != null) {
                this.showDuration = PopupUtils.getAnimatorDuration(this.mShowAnimator, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mShowAnimator;
    }

    Animation getDismissAnimation(int width, int height) {
        if (this.mDismissAnimation == null) {
            this.mDismissAnimation = this.mPopupWindow.onCreateDismissAnimation(width, height);
            if (this.mDismissAnimation != null) {
                this.dismissDuration = PopupUtils.getAnimationDuration(this.mDismissAnimation, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mDismissAnimation;
    }

    Animator getDismissAnimator(int width, int height) {
        if (this.mDismissAnimator == null) {
            this.mDismissAnimator = this.mPopupWindow.onCreateDismissAnimator(width, height);
            if (this.mDismissAnimator != null) {
                this.dismissDuration = PopupUtils.getAnimatorDuration(this.mDismissAnimator, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mDismissAnimator;
    }

    void setToBlur(PopupBlurOption option) {
        this.mBlurOption = option;
        if (option != null) {
            if (option.getBlurInDuration() <= 0L && this.showDuration > 0L) {
                option.setBlurInDuration(this.showDuration);
            }
            if (option.getBlurOutDuration() <= 0L && this.dismissDuration > 0L) {
                option.setBlurOutDuration(this.dismissDuration);
            }
        }
    }

    void setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation == showAnimation) {
            return;
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
        }
        this.mShowAnimation = showAnimation;
        this.showDuration = PopupUtils.getAnimationDuration(this.mShowAnimation, 0L);
        this.setToBlur(this.mBlurOption);
    }

    void setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimation != null || this.mShowAnimator == showAnimator) {
            return;
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        this.mShowAnimator = showAnimator;
        this.showDuration = PopupUtils.getAnimatorDuration(this.mShowAnimator, 0L);
        this.setToBlur(this.mBlurOption);
    }

    void setDismissAnimation(Animation dismissAnimation) {
        if (this.mDismissAnimation == dismissAnimation) {
            return;
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        this.mDismissAnimation = dismissAnimation;
        this.dismissDuration = PopupUtils.getAnimationDuration(this.mDismissAnimation, 0L);
        this.setToBlur(this.mBlurOption);
    }

    void setDismissAnimator(Animator dismissAnimator) {
        if (this.mDismissAnimation != null || this.mDismissAnimator == dismissAnimator) {
            return;
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        this.mDismissAnimator = dismissAnimator;
        this.dismissDuration = PopupUtils.getAnimatorDuration(this.mDismissAnimator, 0L);
        this.setToBlur(this.mBlurOption);
    }

    BasePopupHelper setPopupViewWidth(int popupViewWidth) {
        if (popupViewWidth != 0) {
            this.getLayoutParams().width = popupViewWidth;
        }
        return this;
    }

    BasePopupHelper setPopupViewHeight(int popupViewHeight) {
        if (popupViewHeight != 0) {
            this.getLayoutParams().height = popupViewHeight;
        }
        return this;
    }

    int getPreMeasureWidth() {
        return this.preMeasureWidth;
    }

    BasePopupHelper setPreMeasureWidth(int preMeasureWidth) {
        this.preMeasureWidth = preMeasureWidth;
        return this;
    }

    int getPreMeasureHeight() {
        return this.preMeasureHeight;
    }

    BasePopupHelper setPreMeasureHeight(int preMeasureHeight) {
        this.preMeasureHeight = preMeasureHeight;
        return this;
    }

    boolean isPopupFadeEnable() {
        return (this.flag & 0x40) != 0;
    }

    BasePopupHelper setPopupFadeEnable(PopupWindow popupWindow, boolean fadeEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(64, fadeEnable);
        return this;
    }

    boolean isWithAnchor() {
        return (this.flag & 0x100) != 0;
    }

    boolean isFitsizable() {
        return (this.flag & 0x800) != 0;
    }

    BasePopupHelper withAnchor(boolean showAsDropDown) {
        this.setFlag(256, showAsDropDown);
        return this;
    }

    BasePopupHelper setShowLocation(int x, int y) {
        this.mAnchorViewBound.set(x, y, x + 1, y + 1);
        return this;
    }

    BasePopupWindow.GravityMode getGravityMode() {
        return this.gravityMode;
    }

    int getPopupGravity() {
        return this.popupGravity;
    }

    BasePopupHelper setPopupGravity(BasePopupWindow.GravityMode mode, int popupGravity) {
        if (popupGravity == this.popupGravity && this.gravityMode == mode) {
            return this;
        }
        this.gravityMode = mode;
        this.popupGravity = popupGravity;
        return this;
    }

    BasePopupHelper setClipChildren(boolean clipChildren) {
        this.setFlag(16, clipChildren);
        return this;
    }

    int getOffsetX() {
        return this.offsetX;
    }

    BasePopupHelper setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    int getOffsetY() {
        return this.offsetY;
    }

    BasePopupHelper setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    boolean isAutoShowInputMethod() {
        return (this.flag & 0x200) != 0;
    }

    BasePopupHelper autoShowInputMethod(PopupWindow popupWindow, boolean autoShowInputMethod) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(512, autoShowInputMethod);
        popupWindow.setSoftInputMode(autoShowInputMethod ? 16 : 1);
        return this;
    }

    BasePopupHelper setSoftInputMode(int inputMethodType) {
        this.mSoftInputMode = inputMethodType;
        return this;
    }

    boolean isAutoLocatePopup() {
        return (this.flag & 0x80) != 0;
    }

    BasePopupHelper autoLocatePopup(boolean autoLocatePopup) {
        this.setFlag(128, autoLocatePopup);
        return this;
    }

    BasePopupWindow.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    BasePopupHelper setOnDismissListener(BasePopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    BasePopupWindow.OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    BasePopupHelper setOnBeforeShowCallback(BasePopupWindow.OnBeforeShowCallback onBeforeShowCallback) {
        this.mOnBeforeShowCallback = onBeforeShowCallback;
        return this;
    }

    boolean isOutSideDismiss() {
        return (this.flag & 1) != 0;
    }

    BasePopupHelper dismissOutSideTouch(PopupWindow popupWindow, boolean dismissWhenTouchOutside) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(1, dismissWhenTouchOutside);
        return this;
    }

    boolean isOutSideTouchable() {
        return (this.flag & 2) != 0;
    }

    BasePopupHelper outSideTouchable(PopupWindow popupWindow, boolean touchAble) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(2, touchAble);
        return this;
    }

    BasePopupHelper getAnchorLocation(View v) {
        if (v == null) {
            return this;
        }
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        this.mAnchorViewBound.set(location[0], location[1], location[0] + v.getWidth(), location[1] + v.getHeight());
        return this;
    }

    public Rect getAnchorViewBound() {
        return this.mAnchorViewBound;
    }

    Point getTempOffset() {
        return this.mTempOffset;
    }

    Point getTempOffset(int x, int y) {
        this.mTempOffset.set(x, y);
        return this.mTempOffset;
    }

    boolean isBackPressEnable() {
        return (this.flag & 4) != 0;
    }

    BasePopupHelper backPressEnable(PopupWindow popupWindow, boolean backPressEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(4, backPressEnable);
        return this;
    }

    boolean isFullScreen() {
        return (this.flag & 8) != 0;
    }

    BasePopupHelper fullScreen(boolean fullScreen) {
        this.setFlag(8, fullScreen);
        return this;
    }

    PopupBlurOption getBlurOption() {
        return this.mBlurOption;
    }

    Drawable getPopupBackground() {
        return this.mBackgroundDrawable;
    }

    BasePopupHelper setPopupBackground(Drawable background) {
        this.mBackgroundDrawable = background;
        return this;
    }

    boolean isAlignBackground() {
        return (this.flag & 0x400) != 0;
    }

    BasePopupHelper setAlignBackgound(boolean mAlignBackground) {
        this.setFlag(1024, mAlignBackground);
        if (!mAlignBackground) {
            this.setAlignBackgroundGravity(0);
        }
        return this;
    }

    int getAlignBackgroundGravity() {
        if (this.isAlignBackground() && this.alignBackgroundGravity == 0) {
            this.alignBackgroundGravity = 48;
        }
        return this.alignBackgroundGravity;
    }

    BasePopupHelper setAlignBackgroundGravity(int gravity) {
        this.alignBackgroundGravity = gravity;
        return this;
    }

    BasePopupHelper setForceAdjustKeyboard(boolean adjust) {
        this.setFlag(131072, adjust);
        return this;
    }

    boolean isAllowToBlur() {
        return this.mBlurOption != null && this.mBlurOption.isAllowToBlur();
    }

    boolean isClipChildren() {
        return (this.flag & 0x10) != 0;
    }

    ViewGroup.MarginLayoutParams getLayoutParams() {
        if (this.layoutParams == null) {
            int w = this.popupViewWidth == 0 ? -1 : this.popupViewWidth;
            int h = this.popupViewHeight == 0 ? -2 : this.popupViewHeight;
            this.layoutParams = new ViewGroup.MarginLayoutParams(w, h);
        }
        return this.layoutParams;
    }

    int getShowCount() {
        return showCount;
    }

    BasePopupHelper setContentRootId(View contentRoot) {
        if (contentRoot == null) {
            return this;
        }
        if (contentRoot.getId() == -1) {
            contentRoot.setId(CONTENT_VIEW_ID);
        }
        this.contentRootId = contentRoot.getId();
        return this;
    }

    int getContentRootId() {
        return this.contentRootId;
    }

    int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    View getBackgroundView() {
        return this.mBackgroundView;
    }

    BasePopupHelper setBackgroundView(View backgroundView) {
        this.mBackgroundView = backgroundView;
        return this;
    }

    int getMaxWidth() {
        return this.maxWidth;
    }

    BasePopupHelper setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    int getMaxHeight() {
        return this.maxHeight;
    }

    BasePopupHelper setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    ShowMode getShowMode() {
        return this.mShowMode;
    }

    BasePopupHelper setShowMode(ShowMode showMode) {
        this.mShowMode = showMode;
        return this;
    }

    int getMinWidth() {
        return this.minWidth;
    }

    BasePopupHelper setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    int getMinHeight() {
        return this.minHeight;
    }

    BasePopupHelper setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    BasePopupHelper resize(boolean keep) {
        this.setFlag(2048, keep);
        return this;
    }

    boolean isResizeable() {
        return (this.flag & 0x800) != 0;
    }

    public BasePopupHelper linkTo(View anchorView) {
        if (anchorView == null) {
            if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
                this.mLinkedViewLayoutChangeListenerWrapper.removeListener();
                this.mLinkedViewLayoutChangeListenerWrapper = null;
            }
            this.mLinkedTarget = null;
            return this;
        }
        this.mLinkedTarget = anchorView;
        return this;
    }

    void prepare(View v, boolean positionMode) {
        if (this.mShowInfo == null) {
            this.mShowInfo = new InnerShowInfo(v, positionMode);
        } else {
            this.mShowInfo.mAnchorView = v;
            this.mShowInfo.positionMode = positionMode;
        }
        if (positionMode) {
            this.setShowMode(ShowMode.POSITION);
        } else {
            this.setShowMode(v == null ? ShowMode.SCREEN : ShowMode.RELATIVE_TO_ANCHOR);
        }
        this.getAnchorLocation(v);
    }

    void onDismiss() {
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            --showCount;
            showCount = Math.max(0, showCount);
        }
        if (this.mGlobalLayoutListener != null) {
            PopupUiUtils.safeRemoveGlobalLayoutListener(this.mPopupWindow.getContext().getWindow().getDecorView(), this.mGlobalLayoutListener);
        }
        if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
            this.mLinkedViewLayoutChangeListenerWrapper.removeListener();
        }
    }

    void setFlag(int flag, boolean added) {
        if (!added) {
            this.flag &= ~flag;
        } else {
            this.flag |= flag;
            if (flag == 128) {
                this.flag |= 0x100;
            }
        }
    }

    boolean onDispatchKeyEvent(KeyEvent event) {
        return this.mPopupWindow.onDispatchKeyEvent(event);
    }

    boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mPopupWindow.onInterceptTouchEvent(event);
    }

    boolean onTouchEvent(MotionEvent event) {
        return this.mPopupWindow.onTouchEvent(event);
    }

    boolean onBackPressed() {
        return this.mPopupWindow.onBackPressed();
    }

    boolean onOutSideTouch() {
        return this.mPopupWindow.onOutSideTouch();
    }

    void onShow() {
        this.prepareShow();
        if ((this.flag & 0x4000000) != 0) {
            return;
        }
        if (this.mShowAnimation == null || this.mShowAnimator == null) {
            this.mPopupWindow.mDisplayAnimateView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    BasePopupHelper.this.startShowAnimate(BasePopupHelper.this.mPopupWindow.mDisplayAnimateView.getWidth(), BasePopupHelper.this.mPopupWindow.mDisplayAnimateView.getHeight());
                    BasePopupHelper.this.mPopupWindow.mDisplayAnimateView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            });
        } else {
            this.startShowAnimate(this.mPopupWindow.mDisplayAnimateView.getWidth(), this.mPopupWindow.mDisplayAnimateView.getHeight());
        }
        if (this.isAutoShowInputMethod()) {
            if (this.mAutoShowInputEdittext != null) {
                this.mAutoShowInputEdittext.requestFocus();
                KeyboardUtils.open((View)this.mAutoShowInputEdittext, 350L);
            } else {
                KeyboardUtils.open(this.mPopupWindow.getContentView(), 350L);
            }
        }
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            ++showCount;
        }
    }

    private void prepareShow() {
        if (this.mGlobalLayoutListener == null) {
            this.mGlobalLayoutListener = KeyboardUtils.observerKeyboardChange(this.mPopupWindow.getContext(), this);
        } else {
            PopupUiUtils.safeAddGlobalLayoutListener(this.mPopupWindow.getContext().getWindow().getDecorView(), this.mGlobalLayoutListener);
        }
        if (this.mLinkedTarget != null) {
            if (this.mLinkedViewLayoutChangeListenerWrapper == null) {
                this.mLinkedViewLayoutChangeListenerWrapper = new LinkedViewLayoutChangeListenerWrapper(this.mLinkedTarget);
            }
            if (!this.mLinkedViewLayoutChangeListenerWrapper.isAdded) {
                this.mLinkedViewLayoutChangeListenerWrapper.addSelf();
            }
        }
    }

    void dismiss(boolean animateDismiss) {
        if (this.mOnDismissListener != null && !this.mOnDismissListener.onBeforeDismiss()) {
            return;
        }
        if (this.mPopupWindow.mDisplayAnimateView == null || animateDismiss && (this.flag & 0x8000000) != 0) {
            return;
        }
        if (this.isAutoShowInputMethod()) {
            KeyboardUtils.close(this.mPopupWindow.getContext());
        }
        Message msg = BasePopupEvent.getMessage(2);
        if (animateDismiss) {
            this.startDismissAnimate(this.mPopupWindow.mDisplayAnimateView.getWidth(), this.mPopupWindow.mDisplayAnimateView.getHeight());
            msg.arg1 = 1;
            this.mPopupWindow.mDisplayAnimateView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BasePopupHelper.this.flag &= 0xF7FFFFFF;
                    BasePopupHelper.this.mPopupWindow.superDismiss();
                }
            }, Math.max(this.dismissDuration, 0L));
        } else {
            msg.arg1 = 0;
            this.mPopupWindow.superDismiss();
        }
        this.sendEvent(msg);
    }

    void forceDismiss() {
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        KeyboardUtils.close(this.mPopupWindow.getContext());
        this.flag &= 0xF7FFFFFF;
        this.mPopupWindow.superDismiss();
    }

    void onAutoLocationChange(int oldGravity, int newGravity) {
        PopupLog.i("onAutoLocationChange", oldGravity, newGravity);
    }

    void onAnchorTop() {
    }

    void onAnchorBottom() {
    }

    @Override
    public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
        if (this.mKeyboardStateChangeListener != null) {
            this.mKeyboardStateChangeListener.onKeyboardChange(keyboardBounds, isVisible);
        }
    }

    void update(View v, boolean positionMode) {
        if (!this.mPopupWindow.isShowing() || this.mPopupWindow.mContentView == null) {
            return;
        }
        this.prepare(v, positionMode);
        this.mPopupWindow.mPopupWindow.update();
    }

    void onUpdate() {
        if (this.mShowInfo != null) {
            this.prepare(this.mShowInfo.mAnchorView == null ? null : this.mShowInfo.mAnchorView, this.mShowInfo.positionMode);
        }
    }

    void dispatchOutSideEvent(MotionEvent event) {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dispatchOutSideEvent(event);
        }
    }

    @Nullable
    static Activity findActivity(Object parent) {
        return BasePopupHelper.findActivity(parent, true);
    }

    @Nullable
    static Activity findActivity(Object parent, boolean returnTopIfNull) {
        Activity act = null;
        if (parent instanceof Context) {
            act = PopupUtils.getActivity((Context)parent);
        } else if (parent instanceof Fragment) {
            act = ((Fragment)parent).getActivity();
        } else if (parent instanceof Dialog) {
            act = PopupUtils.getActivity(((Dialog)parent).getContext());
        }
        if (act == null && returnTopIfNull) {
            act = BasePopupSDK.getInstance().getTopActivity();
        }
        return act;
    }

    @Nullable
    static View findDecorView(Object parent) {
        View decorView = null;
        Window window = null;
        if (parent instanceof Dialog) {
            window = ((Dialog)parent).getWindow();
        } else if (parent instanceof DialogFragment) {
            if (((DialogFragment)parent).getDialog() == null) {
                decorView = ((DialogFragment)parent).getView();
            } else {
                window = ((DialogFragment)parent).getDialog().getWindow();
            }
        } else if (parent instanceof Fragment) {
            decorView = ((Fragment)parent).getView();
        } else if (parent instanceof Context) {
            Activity act = PopupUtils.getActivity((Context)parent);
            View view = decorView = act == null ? null : act.findViewById(0x1020002);
        }
        if (decorView != null) {
            return decorView;
        }
        return window == null ? null : window.getDecorView();
    }

    @Override
    public void clear(boolean destroy) {
        if (this.eventObserverMap != null) {
            this.eventObserverMap.clear();
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
            this.mShowAnimation.setAnimationListener(null);
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
            this.mDismissAnimation.setAnimationListener(null);
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
            this.mShowAnimator.removeAllListeners();
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
            this.mDismissAnimator.removeAllListeners();
        }
        if (this.mBlurOption != null) {
            this.mBlurOption.clear();
        }
        if (this.mShowInfo != null) {
            this.mShowInfo.mAnchorView = null;
        }
        if (this.mGlobalLayoutListener != null) {
            try {
                this.mPopupWindow.getContext().getWindow().getDecorView().getViewTreeObserver().removeOnGlobalLayoutListener(this.mGlobalLayoutListener);
            }
            catch (Exception e) {
                PopupLog.e(e);
            }
        }
        if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
            this.mLinkedViewLayoutChangeListenerWrapper.removeListener();
        }
        this.mShowAnimation = null;
        this.mDismissAnimation = null;
        this.mShowAnimator = null;
        this.mDismissAnimator = null;
        this.eventObserverMap = null;
        this.mPopupWindow = null;
        this.mOnDismissListener = null;
        this.mOnBeforeShowCallback = null;
        this.mBlurOption = null;
        this.mBackgroundDrawable = null;
        this.mBackgroundView = null;
        this.mAutoShowInputEdittext = null;
        this.mKeyboardStateChangeListener = null;
        this.mShowInfo = null;
        this.mLinkedViewLayoutChangeListenerWrapper = null;
        this.mLinkedTarget = null;
        this.mGlobalLayoutListener = null;
    }

    class LinkedViewLayoutChangeListenerWrapper
    implements ViewTreeObserver.OnPreDrawListener {
        private View mTarget;
        private boolean isAdded;
        private float lastX;
        private float lastY;
        private int lastWidth;
        private int lastHeight;
        private int lastVisible;
        private boolean lastShowState;
        private boolean hasChange;
        Rect lastLocationRect = new Rect();
        Rect newLocationRect = new Rect();

        public LinkedViewLayoutChangeListenerWrapper(View target) {
            this.mTarget = target;
        }

        void addSelf() {
            if (this.mTarget == null || this.isAdded) {
                return;
            }
            this.mTarget.getGlobalVisibleRect(this.lastLocationRect);
            this.refreshViewParams();
            this.mTarget.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.isAdded = true;
        }

        void removeListener() {
            if (this.mTarget == null || !this.isAdded) {
                return;
            }
            try {
                this.mTarget.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isAdded = false;
        }

        void refreshViewParams() {
            if (this.mTarget == null) {
                return;
            }
            float curX = this.mTarget.getX();
            float curY = this.mTarget.getY();
            int curWidth = this.mTarget.getWidth();
            int curHeight = this.mTarget.getHeight();
            int curVisible = this.mTarget.getVisibility();
            boolean isShow = this.mTarget.isShown();
            boolean bl = this.hasChange = (curX != this.lastX || curY != this.lastY || curWidth != this.lastWidth || curHeight != this.lastHeight || curVisible != this.lastVisible) && this.isAdded;
            if (!this.hasChange) {
                this.mTarget.getGlobalVisibleRect(this.newLocationRect);
                if (!this.newLocationRect.equals((Object)this.lastLocationRect)) {
                    this.lastLocationRect.set(this.newLocationRect);
                    if (!this.handleShowChange(this.mTarget, this.lastShowState, isShow)) {
                        this.hasChange = true;
                    }
                }
            }
            this.lastX = curX;
            this.lastY = curY;
            this.lastWidth = curWidth;
            this.lastHeight = curHeight;
            this.lastVisible = curVisible;
            this.lastShowState = isShow;
        }

        private boolean handleShowChange(View target, boolean lastShowState, boolean isShow) {
            if (lastShowState && !isShow) {
                if (BasePopupHelper.this.mPopupWindow.isShowing()) {
                    BasePopupHelper.this.dismiss(false);
                    return true;
                }
            } else if (!lastShowState && isShow && !BasePopupHelper.this.mPopupWindow.isShowing()) {
                BasePopupHelper.this.mPopupWindow.tryToShowPopup(target, false);
                return true;
            }
            return false;
        }

        public boolean onPreDraw() {
            if (this.mTarget == null) {
                return true;
            }
            this.refreshViewParams();
            if (this.hasChange) {
                BasePopupHelper.this.update(this.mTarget, false);
            }
            return true;
        }
    }

    static class InnerShowInfo {
        View mAnchorView;
        boolean positionMode;

        InnerShowInfo(View mAnchorView, boolean positionMode) {
            this.mAnchorView = mAnchorView;
            this.positionMode = positionMode;
        }
    }

    static enum ShowMode {
        RELATIVE_TO_ANCHOR,
        SCREEN,
        POSITION;

    }
}

