/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

class PopupWindowProxy
extends PopupWindow
implements ClearMemoryObject {
    private static final String TAG = "PopupWindowProxy";
    private BasePopupHelper mHelper;
    WindowManagerProxy mWindowManagerProxy;
    private boolean oldFocusable = true;
    private boolean isHandledFullScreen;
    private static final int FULL_SCREEN_FLAG = 5894;
    private int[] anchorLocation = new int[2];

    PopupWindowProxy(View contentView, BasePopupHelper mHelper) {
        super(contentView);
        this.mHelper = mHelper;
        this.init();
    }

    private void init() {
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.tryToHookWindowManager();
    }

    public void setContentView(View contentView) {
        super.setContentView(contentView);
        this.tryToHookWindowManager();
    }

    private void tryToHookWindowManager() {
        if (this.mWindowManagerProxy != null || this.mHelper == null) {
            return;
        }
        try {
            Field fieldWindowManager = PopupWindow.class.getDeclaredField("mWindowManager");
            fieldWindowManager.setAccessible(true);
            WindowManager windowManager = (WindowManager)fieldWindowManager.get(this);
            if (windowManager == null) {
                return;
            }
            this.mWindowManagerProxy = new WindowManagerProxy(windowManager, this.mHelper);
            fieldWindowManager.set(this, this.mWindowManagerProxy);
            Field fieldScroll = PopupWindow.class.getDeclaredField("mOnScrollChangedListener");
            fieldScroll.setAccessible(true);
            fieldScroll.set(this, null);
        }
        catch (Exception ignore) {
            PopupLog.e(TAG, ignore);
        }
    }

    public void update() {
        try {
            if (this.mHelper != null && this.mWindowManagerProxy != null) {
                this.mWindowManagerProxy.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleFullScreenFocusable() {
        this.oldFocusable = this.isFocusable();
        this.setFocusable(false);
        this.isHandledFullScreen = true;
    }

    private void restoreFocusable() {
        if (this.mWindowManagerProxy != null) {
            this.mWindowManagerProxy.updateFocus(this.oldFocusable);
        }
        this.isHandledFullScreen = false;
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        if (this.isShowing()) {
            return;
        }
        Activity activity = PopupUtils.getActivity(parent.getContext());
        if (activity == null) {
            Log.e((String)TAG, (String)"please make sure that context is instance of activity");
            return;
        }
        this.onBeforeShowExec(activity);
        super.showAtLocation(parent, gravity, x, y);
        this.onAfterShowExec(activity);
    }

    void onBeforeShowExec(Activity act) {
        if (this.needObserverUiVisibilityChange(act)) {
            this.handleFullScreenFocusable();
        }
    }

    void onAfterShowExec(Activity act) {
        if (this.isHandledFullScreen) {
            this.getContentView().setSystemUiVisibility(5894);
            this.restoreFocusable();
        }
    }

    boolean needObserverUiVisibilityChange(Activity act) {
        if (act == null) {
            return false;
        }
        try {
            View decorView = act.getWindow().getDecorView();
            WindowManager.LayoutParams lp = act.getWindow().getAttributes();
            int i = lp.flags;
            int f = decorView.getWindowSystemUiVisibility();
            return (i & 0x400) != 0 && ((f & 2) != 0 || (f & 0x200) != 0);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void dismiss() {
        this.mHelper.dismiss(true);
    }

    void superDismiss() {
        try {
            super.dismiss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clear(false);
        }
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mWindowManagerProxy != null) {
            this.mWindowManagerProxy.clear(destroy);
        }
        PopupUtils.clearViewFromParent(this.getContentView());
        if (destroy) {
            this.mHelper = null;
            this.mWindowManagerProxy = null;
        }
    }
}

