/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import androidx.annotation.FloatRange;
import razerdp.util.log.PopupLog;

public abstract class BaseAnimationConfig<T> {
    protected String TAG = this.getClass().getSimpleName();
    static final long DEFAULT_DURATION = Resources.getSystem().getInteger(0x10E0001);
    static final Interpolator DEFAULT_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    Interpolator interpolator = DEFAULT_INTERPOLATOR;
    long duration = DEFAULT_DURATION;
    float pivotX;
    float pivotY;
    float pivotX2;
    float pivotY2;
    boolean fillBefore;
    boolean fillAfter = true;
    final boolean mResetParent;
    final boolean mResetInternal;

    BaseAnimationConfig(boolean resetParent, boolean resetInternal) {
        this.mResetParent = resetParent;
        this.mResetInternal = resetInternal;
    }

    void reset() {
        this.duration = DEFAULT_DURATION;
        this.interpolator = DEFAULT_INTERPOLATOR;
        this.pivotY2 = 0.0f;
        this.pivotY = 0.0f;
        this.pivotX = 0.0f;
        this.fillBefore = false;
        this.fillAfter = true;
    }

    void resetInternal() {
    }

    public T interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return (T)this;
    }

    public T duration(long duration) {
        this.duration = duration;
        return (T)this;
    }

    public T pivot(@FloatRange(from=0.0, to=1.0) float x, @FloatRange(from=0.0, to=1.0) float y) {
        this.pivotX = x;
        this.pivotY = y;
        return (T)this;
    }

    T pivot2(@FloatRange(from=0.0, to=1.0) float x, @FloatRange(from=0.0, to=1.0) float y) {
        this.pivotX2 = x;
        this.pivotY2 = y;
        return (T)this;
    }

    public T pivotX(@FloatRange(from=0.0, to=1.0) float x) {
        this.pivotX = x;
        return (T)this;
    }

    public T pivotY(@FloatRange(from=0.0, to=1.0) float y) {
        this.pivotY = y;
        return (T)this;
    }

    public T fillBefore(boolean fillBefore) {
        this.fillBefore = fillBefore;
        return (T)this;
    }

    public T fillAfter(boolean fillAfter) {
        this.fillAfter = fillAfter;
        return (T)this;
    }

    void deploy(Animation animation) {
        if (animation == null) {
            return;
        }
        animation.setFillBefore(this.fillBefore);
        animation.setFillAfter(this.fillAfter);
        animation.setDuration(this.duration);
        animation.setInterpolator(this.interpolator);
    }

    void deploy(Animator animator) {
        if (animator == null) {
            return;
        }
        animator.setDuration(this.duration);
        animator.setInterpolator((TimeInterpolator)this.interpolator);
    }

    void log() {
        if (PopupLog.isOpenLog()) {
            PopupLog.i(this.TAG, this.$toString(), this.toString());
        }
    }

    public String $toString() {
        return "BaseConfig{interpolator=" + (this.interpolator == null ? "null" : this.interpolator.getClass().getSimpleName()) + ", duration=" + this.duration + ", pivotX=" + this.pivotX + ", pivotY=" + this.pivotY + ", fillBefore=" + this.fillBefore + ", fillAfter=" + this.fillAfter + '}';
    }

    final Animation $buildAnimation(boolean isRevert) {
        this.log();
        Animation animation = this.buildAnimation(isRevert);
        if (this.mResetParent) {
            this.reset();
        }
        if (this.mResetInternal) {
            this.resetInternal();
        }
        return animation;
    }

    final Animator $buildAnimator(boolean isRevert) {
        this.log();
        Animator animator = this.buildAnimator(isRevert);
        if (this.mResetParent) {
            this.reset();
        }
        if (this.mResetInternal) {
            this.resetInternal();
        }
        return animator;
    }

    protected abstract Animation buildAnimation(boolean var1);

    protected abstract Animator buildAnimator(boolean var1);

    protected int key() {
        return String.valueOf(this.getClass()).hashCode();
    }
}

