/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Pair;
import android.view.View;
import android.view.animation.Animation;
import java.util.HashMap;
import razerdp.basepopup.BasePopupFlag;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.blur.PopupBlurOption;
import razerdp.util.KeyboardUtils;
import razerdp.util.animation.AnimationHelper;
import razerdp.util.animation.ScaleConfig;

public class QuickPopupConfig
implements BasePopupFlag,
ClearMemoryObject {
    protected int contentViewLayoutid;
    protected Animation mShowAnimation;
    protected Animation mDismissAnimation;
    protected Animator mShowAnimator;
    protected Animator mDismissAnimator;
    public int flag = 151912637;
    protected BasePopupWindow.OnDismissListener mDismissListener;
    protected KeyboardUtils.OnKeyboardChangeListener mOnKeyboardChangeListener;
    protected BasePopupWindow.KeyEventListener mKeyEventListener;
    protected BasePopupWindow.OnBlurOptionInitListener mOnBlurOptionInitListener;
    protected PopupBlurOption mPopupBlurOption;
    protected int gravity = 17;
    protected int alignBackgroundGravity = 48;
    protected int offsetX;
    protected int offsetY;
    protected int maskOffsetX;
    protected int maskOffsetY;
    protected int overlayStatusBarMode = 0x30000000;
    protected int overlayNavigationBarMode = 0x10000000;
    protected int minWidth;
    protected int maxWidth;
    protected int minHeight;
    protected int maxHeight;
    protected Drawable background = new ColorDrawable(BasePopupWindow.DEFAULT_BACKGROUND_COLOR);
    protected View mLinkedView;
    HashMap<Integer, Pair<View.OnClickListener, Boolean>> mListenersHolderMap;
    volatile boolean destroyed;

    public QuickPopupConfig() {
        if (Build.VERSION.SDK_INT == 23) {
            this.flag &= 0xFFFFFF7F;
        }
    }

    public static QuickPopupConfig generateDefault() {
        return new QuickPopupConfig().withShowAnimation(((AnimationHelper.AnimationBuilder)AnimationHelper.asAnimation().withScale(ScaleConfig.CENTER)).toShow()).withDismissAnimation(((AnimationHelper.AnimationBuilder)AnimationHelper.asAnimation().withScale(ScaleConfig.CENTER)).toDismiss()).fadeInAndOut(Build.VERSION.SDK_INT != 23);
    }

    public QuickPopupConfig withShowAnimation(Animation showAnimation) {
        this.mShowAnimation = showAnimation;
        return this;
    }

    public QuickPopupConfig withDismissAnimation(Animation dismissAnimation) {
        this.mDismissAnimation = dismissAnimation;
        return this;
    }

    public QuickPopupConfig withShowAnimator(Animator showAnimator) {
        this.mShowAnimator = showAnimator;
        return this;
    }

    public QuickPopupConfig withDismissAnimator(Animator dismissAnimator) {
        this.mDismissAnimator = dismissAnimator;
        return this;
    }

    public QuickPopupConfig dismissListener(BasePopupWindow.OnDismissListener dismissListener) {
        this.mDismissListener = dismissListener;
        return this;
    }

    public QuickPopupConfig blurBackground(boolean blurBackground) {
        return this.blurBackground(blurBackground, null);
    }

    public QuickPopupConfig blurBackground(boolean blurBackground, BasePopupWindow.OnBlurOptionInitListener mInitListener) {
        this.setFlag(16384, blurBackground);
        this.mOnBlurOptionInitListener = mInitListener;
        return this;
    }

    public QuickPopupConfig withBlurOption(PopupBlurOption popupBlurOption) {
        this.mPopupBlurOption = popupBlurOption;
        return this;
    }

    public QuickPopupConfig withClick(int viewId, View.OnClickListener listener) {
        return this.withClick(viewId, listener, false);
    }

    public QuickPopupConfig withClick(int viewId, View.OnClickListener listener, boolean dismissWhenClick) {
        if (this.mListenersHolderMap == null) {
            this.mListenersHolderMap = new HashMap();
        }
        this.mListenersHolderMap.put(viewId, (Pair<View.OnClickListener, Boolean>)Pair.create((Object)listener, (Object)dismissWhenClick));
        return this;
    }

    public QuickPopupConfig fadeInAndOut(boolean fadeEnable) {
        this.setFlag(128, fadeEnable);
        return this;
    }

    public QuickPopupConfig offsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public QuickPopupConfig maskOffsetX(int offsetX) {
        this.maskOffsetX = offsetX;
        return this;
    }

    public QuickPopupConfig offsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public QuickPopupConfig maskOffsetY(int offsetY) {
        this.maskOffsetY = offsetY;
        return this;
    }

    public QuickPopupConfig overlayStatusbarMode(int mode) {
        this.overlayStatusBarMode = mode;
        return this;
    }

    public QuickPopupConfig overlayNavigationBarMode(int mode) {
        this.overlayNavigationBarMode = mode;
        return this;
    }

    public QuickPopupConfig overlayStatusbar(boolean overlay) {
        this.flag = !overlay ? (this.flag &= 0xFFFFFFF7) : (this.flag |= 8);
        return this;
    }

    public QuickPopupConfig overlayNavigationBar(boolean overlay) {
        this.flag = !overlay ? (this.flag &= 0xFFFFFFDF) : (this.flag |= 0x20);
        return this;
    }

    public QuickPopupConfig alignBackground(boolean alignBackground) {
        this.setFlag(2048, alignBackground);
        return this;
    }

    public QuickPopupConfig alignBackgroundGravity(int gravity) {
        this.alignBackgroundGravity = gravity;
        return this;
    }

    public QuickPopupConfig autoLocated(boolean autoLocated) {
        this.setFlag(256, autoLocated);
        return this;
    }

    public QuickPopupConfig background(Drawable background) {
        this.background = background;
        return this;
    }

    public QuickPopupConfig backgroundColor(int color) {
        return this.background((Drawable)new ColorDrawable(color));
    }

    public QuickPopupConfig gravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public QuickPopupConfig clipChildren(boolean clipChildren) {
        this.setFlag(16, clipChildren);
        return this;
    }

    @Deprecated
    public QuickPopupConfig allowInterceptTouchEvent(boolean allowInterceptTouchEvent) {
        this.setFlag(2, !allowInterceptTouchEvent);
        return this;
    }

    public QuickPopupConfig outSideTouchable(boolean outSideTouchable) {
        this.setFlag(2, outSideTouchable);
        return this;
    }

    public QuickPopupConfig linkTo(View linkedView) {
        this.mLinkedView = linkedView;
        return this;
    }

    QuickPopupConfig contentViewLayoutid(int contentViewLayoutid) {
        this.contentViewLayoutid = contentViewLayoutid;
        return this;
    }

    @Deprecated
    public QuickPopupConfig dismissOnOutSideTouch(boolean dismissOutSide) {
        this.setFlag(1, dismissOutSide);
        return this;
    }

    public QuickPopupConfig minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public QuickPopupConfig maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public QuickPopupConfig minHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public QuickPopupConfig maxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public QuickPopupConfig backpressEnable(boolean enable) {
        this.setFlag(4, enable);
        return this;
    }

    public QuickPopupConfig fullScreen(boolean fullscreen) {
        this.setFlag(8, fullscreen);
        return this;
    }

    public QuickPopupConfig fitSize(boolean keep) {
        this.setFlag(4096, keep);
        return this;
    }

    public QuickPopupConfig outSideDismiss(boolean outsideDismiss) {
        this.setFlag(1, outsideDismiss);
        return this;
    }

    public QuickPopupConfig keyEventListener(BasePopupWindow.KeyEventListener keyEventListener) {
        this.mKeyEventListener = keyEventListener;
        return this;
    }

    public QuickPopupConfig keyBoardChangeListener(KeyboardUtils.OnKeyboardChangeListener listener) {
        this.mOnKeyboardChangeListener = listener;
        return this;
    }

    public Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    public Animation getDismissAnimation() {
        return this.mDismissAnimation;
    }

    public Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    public Animator getDismissAnimator() {
        return this.mDismissAnimator;
    }

    public PopupBlurOption getPopupBlurOption() {
        return this.mPopupBlurOption;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public HashMap<Integer, Pair<View.OnClickListener, Boolean>> getListenersHolderMap() {
        return this.mListenersHolderMap;
    }

    public BasePopupWindow.OnBlurOptionInitListener getOnBlurOptionInitListener() {
        return this.mOnBlurOptionInitListener;
    }

    public int getAlignBackgroundGravity() {
        return this.alignBackgroundGravity;
    }

    public BasePopupWindow.OnDismissListener getDismissListener() {
        return this.mDismissListener;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public int getGravity() {
        return this.gravity;
    }

    public int getContentViewLayoutid() {
        return this.contentViewLayoutid;
    }

    public View getLinkedView() {
        return this.mLinkedView;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    private void setFlag(int flag, boolean added) {
        this.flag = !added ? (this.flag &= ~flag) : (this.flag |= flag);
    }

    public int getMaskOffsetX() {
        return this.maskOffsetX;
    }

    public int getMaskOffsetY() {
        return this.maskOffsetY;
    }

    public int getOverlayStatusBarMode() {
        return this.overlayStatusBarMode;
    }

    public int getOverlayNavigationBarMode() {
        return this.overlayNavigationBarMode;
    }

    public KeyboardUtils.OnKeyboardChangeListener getOnKeyboardChangeListener() {
        return this.mOnKeyboardChangeListener;
    }

    public BasePopupWindow.KeyEventListener getKeyEventListener() {
        return this.mKeyEventListener;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void clear(boolean destroy) {
        this.destroyed = true;
        if (this.mPopupBlurOption != null) {
            this.mPopupBlurOption.clear();
        }
        this.mShowAnimation = null;
        this.mDismissAnimation = null;
        this.mShowAnimator = null;
        this.mDismissAnimator = null;
        this.mDismissListener = null;
        this.mOnBlurOptionInitListener = null;
        this.background = null;
        this.mLinkedView = null;
        if (this.mListenersHolderMap != null) {
            this.mListenersHolderMap.clear();
        }
        this.mKeyEventListener = null;
        this.mOnKeyboardChangeListener = null;
        this.mListenersHolderMap = null;
    }
}

