/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.view.View;
import java.lang.ref.WeakReference;
import razerdp.basepopup.QuickPopupConfig;
import razerdp.widget.QuickPopup;

public class QuickPopupBuilder {
    private WeakReference<Context> mContextWeakReference;
    private QuickPopupConfig mConfig;
    private OnConfigApplyListener mOnConfigApplyListener;
    int width = -2;
    int height = -2;

    private QuickPopupBuilder(Context context) {
        this.mContextWeakReference = new WeakReference<Context>(context);
        this.mConfig = QuickPopupConfig.generateDefault();
    }

    public static QuickPopupBuilder with(Context context) {
        return new QuickPopupBuilder(context);
    }

    public QuickPopupBuilder contentView(int resId) {
        this.mConfig.contentViewLayoutid(resId);
        return this;
    }

    public QuickPopupBuilder width(int width) {
        this.width = width;
        return this;
    }

    public QuickPopupBuilder height(int height) {
        this.height = height;
        return this;
    }

    @Deprecated
    public QuickPopupBuilder wrapContentMode() {
        return this.width(-2).height(-2);
    }

    public QuickPopupBuilder setOnConfigApplyListener(OnConfigApplyListener onConfigApplyListener) {
        this.mOnConfigApplyListener = onConfigApplyListener;
        return this;
    }

    public final <C extends QuickPopupConfig> C getConfig() {
        return (C)this.mConfig;
    }

    public OnConfigApplyListener getOnConfigApplyListener() {
        return this.mOnConfigApplyListener;
    }

    public <C extends QuickPopupConfig> QuickPopupBuilder config(C quickPopupConfig) {
        if (quickPopupConfig == null) {
            return this;
        }
        if (quickPopupConfig != this.mConfig) {
            quickPopupConfig.contentViewLayoutid(this.mConfig.contentViewLayoutid);
        }
        this.mConfig = quickPopupConfig;
        return this;
    }

    public QuickPopup build() {
        return new QuickPopup(this.getContext(), this.mConfig, this.mOnConfigApplyListener, this.width, this.height);
    }

    public QuickPopup show() {
        return this.show(null);
    }

    public QuickPopup show(int anchorViewResid) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(anchorViewResid);
        return quickPopup;
    }

    public QuickPopup show(View anchorView) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(anchorView);
        return quickPopup;
    }

    public QuickPopup show(int x, int y) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(x, y);
        return quickPopup;
    }

    private Context getContext() {
        return this.mContextWeakReference == null ? null : (Context)this.mContextWeakReference.get();
    }

    public static interface OnConfigApplyListener {
        public void onConfigApply(QuickPopup var1, QuickPopupConfig var2);
    }
}

