/*
 * Decompiled with CFR 0.152.
 */
package razerdp.widget;

import android.animation.Animator;
import android.content.Context;
import android.util.Pair;
import android.view.View;
import android.view.animation.Animation;
import java.util.HashMap;
import java.util.Map;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.QuickPopupBuilder;
import razerdp.basepopup.QuickPopupConfig;
import razerdp.widget.OnQuickPopupClickListenerWrapper;

public class QuickPopup
extends BasePopupWindow {
    private QuickPopupConfig mConfig;
    private QuickPopupBuilder.OnConfigApplyListener mOnConfigApplyListener;

    private QuickPopup(Context context) {
        super(context);
    }

    private QuickPopup(Context context, boolean delayInit) {
        super(context, delayInit);
    }

    private QuickPopup(Context context, int width, int height) {
        super(context, width, height);
    }

    private QuickPopup(Context context, int width, int height, boolean delayInit) {
        super(context, width, height, delayInit);
    }

    public QuickPopup(Context context, QuickPopupConfig config, QuickPopupBuilder.OnConfigApplyListener onConfigApplyListener, int w, int h) {
        super(context, w, h, true);
        this.mConfig = config;
        this.mOnConfigApplyListener = onConfigApplyListener;
        if (this.mConfig == null) {
            throw new NullPointerException("QuickPopupConfig must be not null!");
        }
        this.delayInit();
        this.applyConfigSetting(this.mConfig);
    }

    protected <C extends QuickPopupConfig> void applyConfigSetting(C config) {
        if (config.getPopupBlurOption() != null) {
            this.setBlurOption(config.getPopupBlurOption());
        } else {
            this.setBlurBackgroundEnable((config.flag & 0x800) != 0, config.getOnBlurOptionInitListener());
        }
        this.setPopupFadeEnable((config.flag & 0x40) != 0);
        this.applyClick();
        this.setOffsetX(config.getOffsetX());
        this.setOffsetY(config.getOffsetY());
        this.setClipChildren((config.flag & 0x10) != 0);
        this.setClipToScreen((config.flag & 0x20) != 0);
        this.setOutSideDismiss((config.flag & 1) != 0);
        this.setOutSideTouchable((config.flag & 2) != 0);
        this.setPopupGravity(config.getGravity());
        this.setAlignBackground((config.flag & 0x400) != 0);
        this.setAlignBackgroundGravity(config.getAlignBackgroundGravity());
        this.setAutoLocatePopup((config.flag & 0x80) != 0);
        this.setPopupWindowFullScreen((config.flag & 8) != 0);
        this.setOnDismissListener(config.getDismissListener());
        this.setBackground(config.getBackground());
        this.linkTo(config.getLinkedView());
        this.setMinWidth(config.getMinWidth());
        this.setMaxWidth(config.getMaxWidth());
        this.setMinHeight(config.getMinHeight());
        this.setMaxHeight(config.getMaxHeight());
        this.setKeepSize((config.flag & 0x800) != 0);
        if (this.mOnConfigApplyListener != null) {
            this.mOnConfigApplyListener.onConfigApply(this, config);
        }
    }

    private void applyClick() {
        HashMap<Integer, Pair<View.OnClickListener, Boolean>> eventsMap = this.mConfig.getListenersHolderMap();
        if (eventsMap == null || eventsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, Pair<View.OnClickListener, Boolean>> entry : eventsMap.entrySet()) {
            int viewId = entry.getKey();
            final Pair<View.OnClickListener, Boolean> event = entry.getValue();
            Object v = this.findViewById(viewId);
            if (v == null) continue;
            if (((Boolean)event.second).booleanValue()) {
                v.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (event.first != null) {
                            if (event.first instanceof OnQuickPopupClickListenerWrapper) {
                                ((OnQuickPopupClickListenerWrapper)event.first).mQuickPopup = QuickPopup.this;
                            }
                            ((View.OnClickListener)event.first).onClick(v);
                        }
                        QuickPopup.this.dismiss();
                    }
                });
                continue;
            }
            v.setOnClickListener((View.OnClickListener)event.first);
        }
    }

    public QuickPopupConfig getConfig() {
        return this.mConfig;
    }

    @Override
    protected Animation onCreateShowAnimation() {
        return this.mConfig.getShowAnimation();
    }

    @Override
    protected Animation onCreateDismissAnimation() {
        return this.mConfig.getDismissAnimation();
    }

    @Override
    protected Animator onCreateDismissAnimator() {
        return this.mConfig.getDismissAnimator();
    }

    @Override
    protected Animator onCreateShowAnimator() {
        return this.mConfig.getShowAnimator();
    }

    @Override
    public View onCreateContentView() {
        return this.createPopupById(this.mConfig.getContentViewLayoutid());
    }
}

