/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.log;

import android.text.TextUtils;
import android.util.Log;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import razerdp.util.log.LogPrinterParser;

public class PopupLog {
    private static final boolean[] mIsDebugMode = new boolean[]{false};
    private static final String TAG = "BasePopup";
    private static final int MAX_LOG_MSG_LENGTH = 4000;
    private static final boolean LOG_LONG = true;

    private static void logInternal(LogMethod method, String tag, Object ... content) {
        if (!PopupLog.isOpenLog()) {
            return;
        }
        try {
            String logCat = PopupLog.getContent(content);
            long length = logCat.length();
            if (length <= 4000L) {
                PopupLog.logMethod(method, tag, logCat);
            } else {
                while (logCat.length() > 4000) {
                    String logContent = logCat.substring(0, 4000);
                    logCat = logCat.replace(logContent, "");
                    PopupLog.logMethod(method, tag, logCat);
                }
                PopupLog.logMethod(method, tag, logCat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logMethod(LogMethod method, String tag, String logCat) {
        if (!PopupLog.isOpenLog()) {
            return;
        }
        switch (method) {
            case d: {
                Log.d((String)tag, (String)logCat);
                break;
            }
            case e: {
                Log.e((String)tag, (String)logCat);
                break;
            }
            case i: {
                Log.i((String)tag, (String)logCat);
                break;
            }
            case v: {
                Log.v((String)tag, (String)logCat);
                break;
            }
            case w: {
                Log.w((String)tag, (String)logCat);
                break;
            }
            default: {
                Log.i((String)tag, (String)logCat);
            }
        }
    }

    private static String getContent(Object ... content) {
        String result = LogPrinterParser.parseContent(content);
        return PopupLog.wrapLogWithMethodLocation(result);
    }

    private static String wrapLogWithMethodLocation(String msg) {
        StackTraceElement element = PopupLog.getCurrentStackTrace();
        String className = "unknow";
        String methodName = "unknow";
        int lineNumber = -1;
        if (element != null) {
            className = element.getFileName();
            methodName = element.getMethodName();
            lineNumber = element.getLineNumber();
        }
        StringBuilder sb = new StringBuilder();
        msg = PopupLog.wrapJson(msg);
        sb.append("  (").append(className).append(":").append(lineNumber).append(") #").append(methodName).append("\uff1a").append('\n').append(msg);
        return sb.toString();
    }

    private static StackTraceElement getCurrentStackTrace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int stackOffset = PopupLog.getStackOffset(trace, PopupLog.class);
        if (stackOffset == -1 && (stackOffset = PopupLog.getStackOffset(trace, Logger.class)) == -1 && (stackOffset = PopupLog.getStackOffset(trace, Log.class)) == -1) {
            return null;
        }
        return trace[stackOffset];
    }

    private static int getStackOffset(StackTraceElement[] trace, Class cla) {
        int logIndex = -1;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            String tClass = element.getClassName();
            if (TextUtils.equals((CharSequence)tClass, (CharSequence)cla.getName())) {
                logIndex = i;
                continue;
            }
            if (logIndex > -1) break;
        }
        if (logIndex != -1 && ++logIndex >= trace.length) {
            logIndex = trace.length - 1;
        }
        return logIndex;
    }

    public static String wrapLocation(Class cla, int lineNumber) {
        return ".(" + cla.getSimpleName() + ".java:" + lineNumber + ")";
    }

    public static String wrapJson(String jsonStr) {
        String message;
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return "json\u4e3a\u7a7a";
        }
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(jsonStr);
                message = jsonObject.toString(2);
                message = "\n================JSON================\n" + message + '\n' + "================JSON================\n";
            } else if (jsonStr.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(jsonStr);
                message = jsonArray.toString(4);
                message = "\n================JSONARRAY================\n" + message + '\n' + "================JSONARRAY================\n";
            } else {
                message = jsonStr;
            }
        }
        catch (JSONException e) {
            message = jsonStr;
        }
        return message;
    }

    public static void setOpenLog(boolean openLog) {
        PopupLog.mIsDebugMode[0] = openLog;
    }

    public static boolean isOpenLog() {
        return mIsDebugMode[0];
    }

    public static void i(Object content) {
        PopupLog.i(TAG, content);
    }

    public static void i(String tag, Object ... content) {
        PopupLog.logInternal(LogMethod.i, tag, content);
    }

    public static void d(Object ... content) {
        PopupLog.d(TAG, content);
    }

    public static void d(String tag, Object ... content) {
        PopupLog.logInternal(LogMethod.d, tag, content);
    }

    public static void e(Object ... content) {
        PopupLog.e(TAG, content);
    }

    public static void e(String tag, Object ... content) {
        PopupLog.logInternal(LogMethod.e, tag, content);
    }

    public static void v(Object ... content) {
        PopupLog.v(TAG, content);
    }

    public static void v(String tag, Object ... content) {
        PopupLog.logInternal(LogMethod.v, tag, content);
    }

    public static void w(Object ... content) {
        PopupLog.w(TAG, content);
    }

    public static void w(String tag, Object ... content) {
        PopupLog.logInternal(LogMethod.w, tag, content);
    }

    private static enum LogMethod {
        i,
        d,
        w,
        e,
        v;

    }
}

